/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.display;

import kotlin.Metadata;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.display.Display;
import ru.octol1ttle.flightassistant.api.display.HudFrame;
import ru.octol1ttle.flightassistant.api.util.extensions.GuiGraphicsExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\f\u0010\f\u001a\u00020\t*\u00020\u000bH\u0002J\f\u0010\r\u001a\u00020\t*\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u0010"}, d2={"Lru/octol1ttle/flightassistant/impl/display/CourseDeviationDisplay;", "Lru/octol1ttle/flightassistant/api/display/Display;", "computers", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;)V", "allowedByConfig", "", "render", "", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "renderLateralDeviation", "renderVerticalDeviation", "renderFaulted", "Companion", "flightassistant-forge"})
public final class CourseDeviationDisplay
extends Display {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_forge("course_deviation");

    public CourseDeviationDisplay(@NotNull ComputerBus computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
    }

    @Override
    public boolean allowedByConfig() {
        return FAConfig.INSTANCE.getDisplay().getShowCourseDeviation();
    }

    @Override
    public void render(@NotNull GuiGraphics guiGraphics) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        GuiGraphics $this$render_u24lambda_u240 = guiGraphics;
        boolean bl = false;
        this.renderLateralDeviation($this$render_u24lambda_u240);
        this.renderVerticalDeviation($this$render_u24lambda_u240);
    }

    private final void renderLateralDeviation(GuiGraphics $this$renderLateralDeviation) {
        Double d = this.getComputers().getPlan().getLateralDeviation(this.getComputers().getHudData().getLerpedPosition());
        if (d == null) {
            return;
        }
        double deviation = RangesKt.coerceIn((double)d, (double)-22.5, (double)22.5);
        int pixelsPerBlock = 2;
        int step = 10;
        int n = -step * 2;
        int n2 = step * 2;
        int i = n;
        int n3 = ProgressionUtilKt.getProgressionLastElement((int)n, (int)n2, (int)step);
        if (i <= n3) {
            while (true) {
                GuiGraphicsExtensionsKt.drawMiddleAlignedString$default($this$renderLateralDeviation, "\u25e6", GuiGraphicsExtensionsKt.getCenterX($this$renderLateralDeviation) - i * pixelsPerBlock, HudFrame.INSTANCE.getBottom() - 10, GuiGraphicsExtensionsKt.getSecondaryColor(), false, 16, null);
                if (i == n3) break;
                i += step;
            }
        }
        $this$renderLateralDeviation.m_280637_(MathKt.roundToInt((double)((double)GuiGraphicsExtensionsKt.getCenterX($this$renderLateralDeviation) - deviation * (double)pixelsPerBlock - (double)4)), HudFrame.INSTANCE.getBottom() - 11, 9, 9, GuiGraphicsExtensionsKt.getSecondaryAdvisoryColor());
    }

    private final void renderVerticalDeviation(GuiGraphics $this$renderVerticalDeviation) {
        Double d = this.getComputers().getPlan().getVerticalDeviation(this.getComputers().getHudData().getLerpedPosition());
        if (d == null) {
            return;
        }
        double deviation = RangesKt.coerceIn((double)d, (double)-12.5, (double)12.5);
        int pixelsPerBlock = 4;
        int step = 5;
        int n = -step * 2;
        int n2 = step * 2;
        int i = n;
        int n3 = ProgressionUtilKt.getProgressionLastElement((int)n, (int)n2, (int)step);
        if (i <= n3) {
            while (true) {
                GuiGraphicsExtensionsKt.drawRightAlignedString$default($this$renderVerticalDeviation, "\u25e6", HudFrame.INSTANCE.getRight() - 10, GuiGraphicsExtensionsKt.getCenterY($this$renderVerticalDeviation) - i * pixelsPerBlock - 4, GuiGraphicsExtensionsKt.getSecondaryColor(), false, 16, null);
                if (i == n3) break;
                i += step;
            }
        }
        $this$renderVerticalDeviation.m_280637_(HudFrame.INSTANCE.getRight() - 17, MathKt.roundToInt((double)((double)GuiGraphicsExtensionsKt.getCenterY($this$renderVerticalDeviation) - deviation * (double)pixelsPerBlock - (double)5)), 9, 9, GuiGraphicsExtensionsKt.getSecondaryAdvisoryColor());
    }

    @Override
    public void renderFaulted(@NotNull GuiGraphics guiGraphics) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        GuiGraphics $this$renderFaulted_u24lambda_u241 = guiGraphics;
        boolean bl = false;
        MutableComponent mutableComponent = Component.m_237115_((String)"short.flightassistant.lateral_deviation");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        GuiGraphicsExtensionsKt.drawMiddleAlignedString$default($this$renderFaulted_u24lambda_u241, (Component)mutableComponent, GuiGraphicsExtensionsKt.getCenterX($this$renderFaulted_u24lambda_u241), HudFrame.INSTANCE.getBottom() - 10, GuiGraphicsExtensionsKt.getWarningColor(), false, 16, null);
        MutableComponent mutableComponent2 = Component.m_237115_((String)"short.flightassistant.vertical_deviation");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"translatable(...)");
        GuiGraphicsExtensionsKt.drawRightAlignedString$default($this$renderFaulted_u24lambda_u241, (Component)mutableComponent2, HudFrame.INSTANCE.getRight() - 10, GuiGraphicsExtensionsKt.getCenterY($this$renderFaulted_u24lambda_u241) - 5, GuiGraphicsExtensionsKt.getWarningColor(), false, 16, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lru/octol1ttle/flightassistant/impl/display/CourseDeviationDisplay$Companion;", "", "<init>", "()V", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-forge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

