/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.display;

import kotlin.Metadata;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.display.Display;
import ru.octol1ttle.flightassistant.api.display.HudFrame;
import ru.octol1ttle.flightassistant.api.util.MathHelperKt;
import ru.octol1ttle.flightassistant.api.util.extensions.GuiGraphicsExtensionsKt;
import ru.octol1ttle.flightassistant.api.util.extensions.StringExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.AutoFlightComputer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0005\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\f\u0010\f\u001a\u00020\t*\u00020\u000bH\u0002J\u001c\u0010\r\u001a\u00020\t*\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002JD\u0010\u0011\u001a\u00020\u0007*\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\u001c\u0010\u0018\u001a\u00020\t*\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u001b"}, d2={"Lru/octol1ttle/flightassistant/impl/display/HeadingDisplay;", "Lru/octol1ttle/flightassistant/api/display/Display;", "computers", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;)V", "allowedByConfig", "", "render", "", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "renderHeadingReading", "renderHeadingScale", "x", "", "y", "drawHeadingLine", "left", "right", "heading", "currentHeading", "", "isLeft", "renderHeadingTarget", "renderFaulted", "Companion", "flightassistant-forge"})
public final class HeadingDisplay
extends Display {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_forge("heading");

    public HeadingDisplay(@NotNull ComputerBus computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
    }

    @Override
    public boolean allowedByConfig() {
        return FAConfig.INSTANCE.getDisplay().getShowHeadingReading() || FAConfig.INSTANCE.getDisplay().getShowHeadingScale();
    }

    @Override
    public void render(@NotNull GuiGraphics guiGraphics) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        GuiGraphics $this$render_u24lambda_u240 = guiGraphics;
        boolean bl = false;
        if (FAConfig.INSTANCE.getDisplay().getShowHeadingReading()) {
            this.renderHeadingReading($this$render_u24lambda_u240);
        }
        if (FAConfig.INSTANCE.getDisplay().getShowHeadingScale()) {
            this.renderHeadingScale($this$render_u24lambda_u240, GuiGraphicsExtensionsKt.getCenterX($this$render_u24lambda_u240), HudFrame.INSTANCE.getBottom() + 1);
        }
        if (FAConfig.INSTANCE.getDisplay().getShowAutomationModes()) {
            this.renderHeadingTarget($this$render_u24lambda_u240, GuiGraphicsExtensionsKt.getCenterX($this$render_u24lambda_u240), HudFrame.INSTANCE.getBottom() - 8);
        }
    }

    private final void renderHeadingReading(GuiGraphics $this$renderHeadingReading) {
        int x = GuiGraphicsExtensionsKt.getCenterX($this$renderHeadingReading);
        int y = HudFrame.INSTANCE.getBottom() + 1;
        int headingInt = MathKt.roundToInt((float)this.getComputers().getData().getHeading());
        $this$renderHeadingReading.m_280637_(x - 11, y, 23, 11, GuiGraphicsExtensionsKt.getPrimaryColor());
        Object[] objectArray = new Object[]{headingInt};
        GuiGraphicsExtensionsKt.drawMiddleAlignedString$default($this$renderHeadingReading, StringExtensionsKt.formatRoot("%03d", objectArray), x, y + 2, GuiGraphicsExtensionsKt.getPrimaryColor(), false, 16, null);
    }

    private final void renderHeadingScale(GuiGraphics $this$renderHeadingScale, int x, int y) {
        int i;
        int headingRoundedUp;
        int i2;
        int headingRoundedDown;
        int left = (int)((float)x - HudFrame.INSTANCE.getHeight() * 0.5f);
        int right = (int)((float)x + HudFrame.INSTANCE.getHeight() * 0.5f);
        $this$renderHeadingScale.m_280656_(left, right, y, GuiGraphicsExtensionsKt.getPrimaryColor());
        $this$renderHeadingScale.m_280315_(left, y, y + 20, GuiGraphicsExtensionsKt.getPrimaryColor());
        $this$renderHeadingScale.m_280315_(right, y, y + 20, GuiGraphicsExtensionsKt.getPrimaryColor());
        $this$renderHeadingScale.m_280588_(left, 0, x - 12, $this$renderHeadingScale.m_280206_());
        int n = ProgressionUtilKt.getProgressionLastElement((int)headingRoundedDown, (int)-360, (int)-10);
        if (n <= i2) {
            for (i2 = headingRoundedDown = Mth.m_184628_((double)this.getComputers().getData().getHeading(), (int)10); this.drawHeadingLine($this$renderHeadingScale, x, y, left, right, i2, this.getComputers().getData().getHeading(), true) && i2 != n; i2 -= 10) {
            }
        }
        $this$renderHeadingScale.m_280618_();
        $this$renderHeadingScale.m_280588_(x + 13, 0, right, $this$renderHeadingScale.m_280206_());
        int n2 = ProgressionUtilKt.getProgressionLastElement((int)headingRoundedUp, (int)720, (int)10);
        if (i <= n2) {
            for (i = headingRoundedUp = Mth.m_144941_((int)MathKt.roundToInt((float)this.getComputers().getData().getHeading()), (int)10); this.drawHeadingLine($this$renderHeadingScale, x, y, left, right, i, this.getComputers().getData().getHeading(), false) && i != n2; i += 10) {
            }
        }
        $this$renderHeadingScale.m_280618_();
    }

    private final boolean drawHeadingLine(GuiGraphics $this$drawHeadingLine, int x, int y, int left, int right, int heading, float currentHeading, boolean isLeft) {
        int textX = (int)((float)x + (float)2 * MathHelperKt.findShortestPath(currentHeading, heading, 360.0f));
        if (textX < left - 100 || textX > right + 100) {
            return false;
        }
        int wrappedHeading = heading > 0 ? heading % 360 : 360 + heading % 360;
        $this$drawHeadingLine.m_280315_(textX, y, y + 3, GuiGraphicsExtensionsKt.getPrimaryColor());
        if (wrappedHeading % 30 == 0) {
            GuiGraphicsExtensionsKt.drawMiddleAlignedString$default($this$drawHeadingLine, String.valueOf(wrappedHeading == 0 ? 360 : wrappedHeading), textX, y + 4, GuiGraphicsExtensionsKt.getPrimaryColor(), false, 16, null);
        }
        if (wrappedHeading % 90 == 0) {
            $this$drawHeadingLine.m_280618_();
            $this$drawHeadingLine.m_280588_(left, 0, right, $this$drawHeadingLine.m_280206_());
            GuiGraphicsExtensionsKt.drawMiddleAlignedString$default($this$drawHeadingLine, switch (wrappedHeading) {
                case 0, 360 -> "Z-";
                case 90 -> "X+";
                case 180 -> "Z+";
                case 270 -> "X-";
                default -> throw new IllegalArgumentException("Degree range out of bounds: " + heading);
            }, textX, y + 12, GuiGraphicsExtensionsKt.getPrimaryColor(), false, 16, null);
            $this$drawHeadingLine.m_280618_();
            if (isLeft) {
                $this$drawHeadingLine.m_280588_(left, 0, x - 12, $this$drawHeadingLine.m_280206_());
            } else {
                $this$drawHeadingLine.m_280588_(x + 13, 0, right, $this$drawHeadingLine.m_280206_());
            }
        }
        return true;
    }

    private final void renderHeadingTarget(GuiGraphics $this$renderHeadingTarget, int x, int y) {
        AutoFlightComputer.LateralMode active = this.getComputers().getAutoflight().getActiveLateralMode();
        if (this.getComputers().getAutoflight().getHeadingInput() != null && active instanceof AutoFlightComputer.FollowsHeadingMode) {
            Object[] objectArray = new Object[]{((AutoFlightComputer.FollowsHeadingMode)((Object)active)).getTargetHeading()};
            GuiGraphicsExtensionsKt.drawMiddleAlignedString$default($this$renderHeadingTarget, StringExtensionsKt.formatRoot("%03d", objectArray), x, y, GuiGraphicsExtensionsKt.getPrimaryAdvisoryColor(), false, 16, null);
        }
    }

    @Override
    public void renderFaulted(@NotNull GuiGraphics guiGraphics) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        GuiGraphics $this$renderFaulted_u24lambda_u241 = guiGraphics;
        boolean bl = false;
        MutableComponent mutableComponent = Component.m_237115_((String)"short.flightassistant.heading");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        GuiGraphicsExtensionsKt.drawMiddleAlignedString$default($this$renderFaulted_u24lambda_u241, (Component)mutableComponent, GuiGraphicsExtensionsKt.getCenterX($this$renderFaulted_u24lambda_u241), HudFrame.INSTANCE.getBottom() + 1, GuiGraphicsExtensionsKt.getWarningColor(), false, 16, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lru/octol1ttle/flightassistant/impl/display/HeadingDisplay$Companion;", "", "<init>", "()V", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-forge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

