/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.display;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.ModuleController;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.display.Display;
import ru.octol1ttle.flightassistant.api.display.HudDisplayRegistrationCallback;
import ru.octol1ttle.flightassistant.api.display.HudFrame;
import ru.octol1ttle.flightassistant.api.util.FATickCounter;
import ru.octol1ttle.flightassistant.api.util.RenderMatrices;
import ru.octol1ttle.flightassistant.api.util.ScreenSpace;
import ru.octol1ttle.flightassistant.api.util.extensions.GuiGraphicsExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;
import ru.octol1ttle.flightassistant.impl.display.AlertDisplay;
import ru.octol1ttle.flightassistant.impl.display.AltitudeDisplay;
import ru.octol1ttle.flightassistant.impl.display.AttitudeDisplay;
import ru.octol1ttle.flightassistant.impl.display.AutomationModesDisplay;
import ru.octol1ttle.flightassistant.impl.display.CoordinatesDisplay;
import ru.octol1ttle.flightassistant.impl.display.CourseDeviationDisplay;
import ru.octol1ttle.flightassistant.impl.display.ElytraDurabilityDisplay;
import ru.octol1ttle.flightassistant.impl.display.FlightDirectorsDisplay;
import ru.octol1ttle.flightassistant.impl.display.FlightPathDisplay;
import ru.octol1ttle.flightassistant.impl.display.HeadingDisplay;
import ru.octol1ttle.flightassistant.impl.display.RadarAltitudeDisplay;
import ru.octol1ttle.flightassistant.impl.display.SpeedDisplay;
import ru.octol1ttle.flightassistant.impl.display.StatusDisplay;
import ru.octol1ttle.flightassistant.impl.display.VelocityComponentsDisplay;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0007H\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0007H\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0007H\u0016J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u0007J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0002H\u0002J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0015\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001dJ\b\u0010\u001e\u001a\u00020\u0017H\u0002J\u000e\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\""}, d2={"Lru/octol1ttle/flightassistant/impl/display/HudDisplayHost;", "Lru/octol1ttle/flightassistant/api/ModuleController;", "Lru/octol1ttle/flightassistant/api/display/Display;", "<init>", "()V", "displays", "", "Lnet/minecraft/resources/ResourceLocation;", "modulesResettable", "", "getModulesResettable", "()Z", "get", "identifier", "isEnabled", "isFaulted", "setEnabled", "enabled", "countFaults", "", "identifiers", "", "register", "", "module", "registerBuiltin", "computers", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "sendRegistrationEvent", "sendRegistrationEvent$flightassistant_forge", "logRegisterComplete", "render", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "flightassistant-forge"})
@SourceDebugExtension(value={"SMAP\nHudDisplayHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HudDisplayHost.kt\nru/octol1ttle/flightassistant/impl/display/HudDisplayHost\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,146:1\n536#2:147\n521#2,6:148\n*S KotlinDebug\n*F\n+ 1 HudDisplayHost.kt\nru/octol1ttle/flightassistant/impl/display/HudDisplayHost\n*L\n113#1:147\n113#1:148,6\n*E\n"})
public final class HudDisplayHost
implements ModuleController<Display> {
    @NotNull
    public static final HudDisplayHost INSTANCE = new HudDisplayHost();
    @NotNull
    private static final Map<ResourceLocation, Display> displays = new HashMap();
    private static final boolean modulesResettable;

    private HudDisplayHost() {
    }

    @Override
    public boolean getModulesResettable() {
        return modulesResettable;
    }

    @Override
    @NotNull
    public Display get(@NotNull ResourceLocation identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Display display = displays.get(identifier);
        if (display == null) {
            throw new IllegalArgumentException("No display was found with identifier: " + identifier);
        }
        return display;
    }

    @Override
    public boolean isEnabled(@NotNull ResourceLocation identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        return this.get(identifier).getEnabled();
    }

    @Override
    public boolean isFaulted(@NotNull ResourceLocation identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        return this.get(identifier).getFaulted();
    }

    @Override
    public boolean setEnabled(@NotNull ResourceLocation identifier, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Display display = this.get(identifier);
        boolean oldEnabled = display.getEnabled();
        display.setEnabled$flightassistant_forge(enabled);
        return oldEnabled;
    }

    public final int countFaults(@NotNull ResourceLocation identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        return this.get(identifier).getFaultCount();
    }

    @NotNull
    public Set<ResourceLocation> identifiers() {
        return displays.keySet();
    }

    private final void register(ResourceLocation identifier, Display module) {
        if (FlightAssistant.INSTANCE.getInitComplete$flightassistant_forge()) {
            throw new IllegalStateException("Initialization is already complete, but trying to register a display with identifier: " + identifier);
        }
        if (displays.containsKey(identifier)) {
            throw new IllegalArgumentException("Already registered display with identifier: " + identifier);
        }
        displays.put(identifier, module);
    }

    private final void registerBuiltin(ComputerBus computers) {
        this.register(AlertDisplay.Companion.getID(), new AlertDisplay(computers));
        this.register(AltitudeDisplay.Companion.getID(), new AltitudeDisplay(computers));
        this.register(AttitudeDisplay.Companion.getID(), new AttitudeDisplay(computers));
        this.register(AutomationModesDisplay.Companion.getID(), new AutomationModesDisplay(computers));
        this.register(CoordinatesDisplay.Companion.getID(), new CoordinatesDisplay(computers));
        this.register(CourseDeviationDisplay.Companion.getID(), new CourseDeviationDisplay(computers));
        this.register(ElytraDurabilityDisplay.Companion.getID(), new ElytraDurabilityDisplay(computers));
        this.register(FlightDirectorsDisplay.Companion.getID(), new FlightDirectorsDisplay(computers));
        this.register(FlightPathDisplay.Companion.getID(), new FlightPathDisplay(computers));
        this.register(HeadingDisplay.Companion.getID(), new HeadingDisplay(computers));
        this.register(RadarAltitudeDisplay.Companion.getID(), new RadarAltitudeDisplay(computers));
        this.register(SpeedDisplay.Companion.getID(), new SpeedDisplay(computers));
        this.register(StatusDisplay.Companion.getID(), new StatusDisplay(computers));
        this.register(VelocityComponentsDisplay.Companion.getID(), new VelocityComponentsDisplay(computers));
    }

    public final void sendRegistrationEvent$flightassistant_forge(@NotNull ComputerBus computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        this.registerBuiltin(computers);
        ((HudDisplayRegistrationCallback)HudDisplayRegistrationCallback.EVENT.invoker()).register(computers, this::register);
        this.logRegisterComplete();
    }

    private final void logRegisterComplete() {
        ArrayList<String> namespaces = new ArrayList<String>();
        for (ResourceLocation id : displays.keySet()) {
            if (namespaces.contains(id.m_135827_())) continue;
            namespaces.add(id.m_135827_());
        }
        FlightAssistant.INSTANCE.getLogger$flightassistant_forge().info("Registered {} displays from mods: {}", (Object)displays.size(), (Object)CollectionsKt.joinToString$default((Iterable)namespaces, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
    }

    /*
     * WARNING - void declaration
     */
    public final void render(@NotNull GuiGraphics guiGraphics) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        if (!FAConfig.INSTANCE.getHudEnabled$flightassistant_forge()) {
            return;
        }
        FlightAssistant.INSTANCE.getProfiler$flightassistant_forge().m_6180_("flightassistant:hud_display_host");
        HudFrame.INSTANCE.updateDimensions();
        ScreenSpace.INSTANCE.updateViewport$flightassistant_forge();
        Map<ResourceLocation, Display> $this$filter$iv = displays;
        boolean $i$f$filter = false;
        Map<ResourceLocation, Display> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!((Display)entry.getValue()).allowedByConfig()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        for (Map.Entry entry : destination$iv$iv.entrySet()) {
            ResourceLocation id = (ResourceLocation)entry.getKey();
            Display display = (Display)entry.getValue();
            if (FATickCounter.INSTANCE.getTicksSinceWorldLoad() < FATickCounter.INSTANCE.getWorldLoadWaitTime()) {
                GuiGraphics $this$render_u24lambda_u241 = guiGraphics;
                boolean bl = false;
                MutableComponent mutableComponent = Component.m_237115_((String)"misc.flightassistant.waiting_for_world_load");
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
                GuiGraphicsExtensionsKt.drawMiddleAlignedString$default($this$render_u24lambda_u241, (Component)mutableComponent, GuiGraphicsExtensionsKt.getCenterX($this$render_u24lambda_u241), GuiGraphicsExtensionsKt.getCenterY($this$render_u24lambda_u241) - 16, GuiGraphicsExtensionsKt.getPrimaryColor(), false, 16, null);
                MutableComponent mutableComponent2 = Component.m_237115_((String)"misc.flightassistant.waiting_for_world_load.maximum_time");
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"translatable(...)");
                GuiGraphicsExtensionsKt.drawMiddleAlignedString$default($this$render_u24lambda_u241, (Component)mutableComponent2, GuiGraphicsExtensionsKt.getCenterX($this$render_u24lambda_u241), GuiGraphicsExtensionsKt.getCenterY($this$render_u24lambda_u241) + 8, GuiGraphicsExtensionsKt.getPrimaryColor(), false, 16, null);
                return;
            }
            FlightAssistant.INSTANCE.getProfiler$flightassistant_forge().m_6180_(id.toString());
            if (!display.getEnabled() || !RenderMatrices.INSTANCE.getReady()) {
                try {
                    display.renderFaulted(guiGraphics);
                }
                catch (Throwable t) {
                    FlightAssistant.INSTANCE.getLogger$flightassistant_forge().error("Exception rendering disabled display with identifier: " + id, t);
                }
                continue;
            }
            try {
                display.render(guiGraphics);
                display.setFaulted$flightassistant_forge(false);
            }
            catch (Throwable t) {
                display.setFaulted$flightassistant_forge(true);
                int n = display.getFaultCount();
                display.setFaultCount$flightassistant_forge(n + 1);
                display.setEnabled$flightassistant_forge(false);
                FlightAssistant.INSTANCE.getLogger$flightassistant_forge().error("Exception rendering display with identifier: " + id, t);
            }
            FlightAssistant.INSTANCE.getProfiler$flightassistant_forge().m_7238_();
        }
        FlightAssistant.INSTANCE.getProfiler$flightassistant_forge().m_7238_();
    }

    @Override
    public boolean toggleEnabled(@NotNull ResourceLocation identifier) {
        return ModuleController.super.toggleEnabled(identifier);
    }
}

