/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.api.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0019\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001e\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lru/octol1ttle/flightassistant/api/util/PIDController;", "", "proportional", "", "integral", "derivative", "filterConstant", "", "minimumValue", "maximumValue", "<init>", "(DDDIDD)V", "a0", "a1", "lastLastError", "lastError", "error", "output", "Ljava/lang/Double;", "a0d", "a1d", "a2d", "tau", "alpha", "d0", "d1", "fd0", "fd1", "calculate", "target", "current", "startOutput", "flightassistant-neoforge"})
public final class PIDController {
    private final double derivative;
    private final double minimumValue;
    private final double maximumValue;
    private final double a0;
    private final double a1;
    private double lastLastError;
    private double lastError;
    private double error;
    @Nullable
    private Double output;
    private final double a0d;
    private final double a1d;
    private final double a2d;
    private final double tau;
    private final double alpha;
    private double d0;
    private double d1;
    private double fd0;
    private double fd1;

    public PIDController(double proportional, double integral, double derivative, int filterConstant, double minimumValue, double maximumValue) {
        this.derivative = derivative;
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
        this.a0 = proportional + integral * (double)0.05f;
        this.a1 = -proportional;
        this.a0d = this.derivative * (double)0.05f;
        this.a1d = -2.0 * this.derivative * (double)0.05f;
        this.a2d = this.derivative * (double)0.05f;
        this.tau = this.derivative / (proportional * (double)filterConstant);
        this.alpha = (double)0.05f / ((double)2 * this.tau);
    }

    public final double calculate(double target, double current, double startOutput) {
        this.lastLastError = this.lastError;
        this.lastError = this.error;
        this.error = target - current;
        if (this.output == null) {
            this.output = startOutput;
        }
        Double d = this.output;
        Intrinsics.checkNotNull((Object)d);
        this.output = d + this.a0 * this.error + this.a1 * this.lastError;
        if (this.derivative > 0.0) {
            this.d1 = this.d0;
            this.d0 = this.a0d * this.error + this.a1d * this.lastError + this.a2d * this.lastLastError;
            this.fd1 = this.fd0;
            this.fd0 = this.alpha / (this.alpha + 1.0) * (this.d0 + this.d1) - (this.alpha - 1.0) / (this.alpha + 1.0) * this.fd1;
            Double d2 = this.output;
            Intrinsics.checkNotNull((Object)d2);
            this.output = d2 + this.fd0;
        }
        Double d3 = this.output;
        Intrinsics.checkNotNull((Object)d3);
        Double d4 = this.output = (Double)RangesKt.coerceIn((Comparable)d3, (ClosedFloatingPointRange)RangesKt.rangeTo((double)this.minimumValue, (double)this.maximumValue));
        Intrinsics.checkNotNull((Object)d4);
        return d4;
    }
}

