/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.api.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL11;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.util.RenderMatrices;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\bJ\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0003J\u0012\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\nH\u0002J\u0015\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u0015\u0010\u0016\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lru/octol1ttle/flightassistant/api/util/ScreenSpace;", "", "<init>", "()V", "viewport", "", "updateViewport", "", "updateViewport$flightassistant_neoforge", "fromWorldSpace", "Lorg/joml/Vector3f;", "deltaPos", "Lnet/minecraft/world/phys/Vec3;", "useNoRollMatrix", "", "isVisible", "pos", "getX", "", "heading", "", "(F)Ljava/lang/Integer;", "getY", "pitch", "getVector3f", "flightassistant-neoforge"})
public final class ScreenSpace {
    @NotNull
    public static final ScreenSpace INSTANCE = new ScreenSpace();
    @NotNull
    private static int[] viewport = new int[4];

    private ScreenSpace() {
    }

    public final void updateViewport$flightassistant_neoforge() {
        GL11.glGetIntegerv((int)2978, (int[])viewport);
    }

    @Contract(value="_ -> new", pure=true)
    private final Vector3f fromWorldSpace(Vec3 deltaPos, boolean useNoRollMatrix) {
        int displayHeight = FlightAssistant.INSTANCE.getMc$flightassistant_neoforge().getWindow().getHeight();
        Vector3f target = new Vector3f();
        Vector4f vector4f = new Vector4f((float)deltaPos.x, (float)deltaPos.y, (float)deltaPos.z, 1.0f).mul((Matrix4fc)(useNoRollMatrix ? RenderMatrices.INSTANCE.getWorldSpaceNoRollMatrix() : RenderMatrices.INSTANCE.getWorldSpaceMatrix()));
        Intrinsics.checkNotNullExpressionValue((Object)vector4f, (String)"mul(...)");
        Vector4f transformedCoordinates = vector4f;
        Matrix4f matrixProj = new Matrix4f((Matrix4fc)RenderMatrices.INSTANCE.getProjectionMatrix());
        Matrix4f matrixModel = new Matrix4f((Matrix4fc)RenderMatrices.INSTANCE.getModelViewMatrix());
        matrixProj.mul((Matrix4fc)matrixModel).project(transformedCoordinates.x(), transformedCoordinates.y(), transformedCoordinates.z(), viewport, target);
        return new Vector3f(target.x / (float)FlightAssistant.INSTANCE.getMc$flightassistant_neoforge().getWindow().getGuiScale(), ((float)displayHeight - target.y) / (float)FlightAssistant.INSTANCE.getMc$flightassistant_neoforge().getWindow().getGuiScale(), target.z);
    }

    static /* synthetic */ Vector3f fromWorldSpace$default(ScreenSpace screenSpace, Vec3 vec3, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return screenSpace.fromWorldSpace(vec3, bl);
    }

    private final boolean isVisible(Vector3f pos) {
        if (pos == null) {
            return false;
        }
        return pos.z > -1.0f && pos.z < 1.0f;
    }

    @Nullable
    public final Integer getX(float heading) {
        Vec3 vec3 = Vec3.directionFromRotation((float)0.0f, (float)(heading - 180.0f));
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"directionFromRotation(...)");
        Vector3f vec = this.fromWorldSpace(vec3, true);
        if (!this.isVisible(vec)) {
            return null;
        }
        return (int)vec.x;
    }

    @Nullable
    public final Integer getY(float pitch) {
        Vec3 vec3 = Vec3.directionFromRotation((float)(-pitch), (float)FlightAssistant.INSTANCE.getMc$flightassistant_neoforge().getEntityRenderDispatcher().camera.getYRot());
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"directionFromRotation(...)");
        Vector3f vec = this.fromWorldSpace(vec3, true);
        if (!this.isVisible(vec)) {
            return null;
        }
        return (int)vec.y;
    }

    @Nullable
    public final Vector3f getVector3f(@NotNull Vec3 deltaPos, boolean useNoRollMatrix) {
        Intrinsics.checkNotNullParameter((Object)deltaPos, (String)"deltaPos");
        Vector3f vec = this.fromWorldSpace(deltaPos, useNoRollMatrix);
        if (!this.isVisible(vec)) {
            return null;
        }
        return vec;
    }

    public static /* synthetic */ Vector3f getVector3f$default(ScreenSpace screenSpace, Vec3 vec3, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return screenSpace.getVector3f(vec3, bl);
    }
}

