/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.alert.fault;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.api.alert.Alert;
import ru.octol1ttle.flightassistant.api.alert.AlertData;
import ru.octol1ttle.flightassistant.api.alert.ECAMAlert;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.util.extensions.GuiGraphicsExtensionsKt;
import ru.octol1ttle.flightassistant.impl.display.HudDisplayHost;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J(\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\fH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lru/octol1ttle/flightassistant/impl/alert/fault/DisplayFaultAlert;", "Lru/octol1ttle/flightassistant/api/alert/Alert;", "Lru/octol1ttle/flightassistant/api/alert/ECAMAlert;", "computers", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "identifier", "Lnet/minecraft/resources/ResourceLocation;", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;Lnet/minecraft/resources/ResourceLocation;)V", "getIdentifier", "()Lnet/minecraft/resources/ResourceLocation;", "priorityOffset", "", "getPriorityOffset", "()I", "data", "Lru/octol1ttle/flightassistant/api/alert/AlertData;", "getData", "()Lru/octol1ttle/flightassistant/api/alert/AlertData;", "shouldActivate", "", "render", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "firstLineX", "otherLinesX", "firstLineY", "flightassistant-neoforge"})
public final class DisplayFaultAlert
extends Alert
implements ECAMAlert {
    @NotNull
    private final ResourceLocation identifier;
    private final int priorityOffset;
    @NotNull
    private final AlertData data;

    public DisplayFaultAlert(@NotNull ComputerBus computers, @NotNull ResourceLocation identifier) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        super(computers);
        this.identifier = identifier;
        this.priorityOffset = 45;
        this.data = AlertData.Companion.getMASTER_CAUTION();
    }

    @NotNull
    public final ResourceLocation getIdentifier() {
        return this.identifier;
    }

    @Override
    public int getPriorityOffset() {
        return this.priorityOffset;
    }

    @Override
    @NotNull
    public AlertData getData() {
        return this.data;
    }

    @Override
    public boolean shouldActivate() {
        return HudDisplayHost.INSTANCE.isFaulted(this.identifier);
    }

    @Override
    public int render(@NotNull GuiGraphics guiGraphics, int firstLineX, int otherLinesX, int firstLineY) {
        int n;
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        int i = 0;
        MutableComponent mutableComponent = Component.translatable((String)("alert.flightassistant.fault.hud." + this.identifier));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        i += GuiGraphicsExtensionsKt.drawString$default(guiGraphics, (Component)mutableComponent, firstLineX, firstLineY, GuiGraphicsExtensionsKt.getCautionColor(), false, 16, null);
        if (HudDisplayHost.INSTANCE.countFaults(this.identifier) == 1) {
            MutableComponent mutableComponent2 = Component.translatable((String)"alert.flightassistant.fault.hud.reset");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"translatable(...)");
            n = GuiGraphicsExtensionsKt.drawString$default(guiGraphics, (Component)mutableComponent2, otherLinesX, firstLineY + 11, GuiGraphicsExtensionsKt.getPrimaryAdvisoryColor(), false, 16, null);
        } else {
            n = 0;
        }
        return i += n;
    }
}

