/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.alert.gpws;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.api.alert.Alert;
import ru.octol1ttle.flightassistant.api.alert.AlertData;
import ru.octol1ttle.flightassistant.api.alert.ECAMAlert;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.util.extensions.GuiGraphicsExtensionsKt;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.FlightPlanComputer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\r\u001a\u00020\fH\u0016J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fH\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lru/octol1ttle/flightassistant/impl/alert/gpws/MinimumsReachedAlert;", "Lru/octol1ttle/flightassistant/api/alert/Alert;", "Lru/octol1ttle/flightassistant/api/alert/ECAMAlert;", "computers", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;)V", "data", "Lru/octol1ttle/flightassistant/api/alert/AlertData;", "getData", "()Lru/octol1ttle/flightassistant/api/alert/AlertData;", "reached", "", "shouldActivate", "render", "", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "firstLineX", "otherLinesX", "firstLineY", "flightassistant-neoforge"})
public final class MinimumsReachedAlert
extends Alert
implements ECAMAlert {
    private boolean reached;

    public MinimumsReachedAlert(@NotNull ComputerBus computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
    }

    @Override
    @NotNull
    public AlertData getData() {
        return AlertData.Companion.getMINIMUMS_REACHED();
    }

    @Override
    public boolean shouldActivate() {
        if (this.getComputers().getPlan().getCurrentPhase() != FlightPlanComputer.FlightPhase.LANDING) {
            this.reached = false;
            return false;
        }
        if (this.reached) {
            return true;
        }
        double minimums = this.getComputers().getPlan().getArrivalData().getMinimumsType() == FlightPlanComputer.ArrivalData.MinimumsType.ABSOLUTE ? (double)this.getComputers().getPlan().getArrivalData().getMinimums() : this.getComputers().getPlan().getComputers().getGpws().getGroundOrVoidY() + (double)this.getComputers().getPlan().getArrivalData().getMinimums();
        this.reached = this.getComputers().getPlan().getComputers().getData().getAltitude() <= minimums;
        return this.reached;
    }

    @Override
    public int render(@NotNull GuiGraphics guiGraphics, int firstLineX, int otherLinesX, int firstLineY) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        MutableComponent mutableComponent = Component.translatable((String)"alert.flightassistant.gpws.minimums_reached");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        return GuiGraphicsExtensionsKt.drawString$default(guiGraphics, (Component)mutableComponent, firstLineX, firstLineY, GuiGraphicsExtensionsKt.getCautionColor(), false, 16, null);
    }
}

