/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.computer.autoflight.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.autoflight.ControlInput;
import ru.octol1ttle.flightassistant.api.autoflight.FlightController;
import ru.octol1ttle.flightassistant.api.autoflight.roll.RollControllerRegistrationCallback;
import ru.octol1ttle.flightassistant.api.autoflight.roll.RollSource;
import ru.octol1ttle.flightassistant.api.autoflight.roll.RollSourceRegistrationCallback;
import ru.octol1ttle.flightassistant.api.computer.Computer;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.util.FATickCounter;
import ru.octol1ttle.flightassistant.api.util.MathHelperKt;
import ru.octol1ttle.flightassistant.api.util.extensions.CollectionExtensionsKt;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.base.RollComputer;
import ru.octol1ttle.flightassistant.impl.computer.data.AirDataComputer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J \u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\fH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/base/RollComputer;", "Lru/octol1ttle/flightassistant/api/computer/Computer;", "computers", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;)V", "sources", "", "Lru/octol1ttle/flightassistant/api/autoflight/roll/RollSource;", "controllers", "Lru/octol1ttle/flightassistant/api/autoflight/FlightController;", "invokeEvents", "", "renderTick", "smoothSetRoll", "rollSource", "target", "", "deltaTimeMultiplier", "reset", "Companion", "flightassistant-neoforge"})
@SourceDebugExtension(value={"SMAP\nRollComputer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RollComputer.kt\nru/octol1ttle/flightassistant/impl/computer/autoflight/base/RollComputer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1617#2,9:60\n1869#2:69\n1870#2:71\n1626#2:72\n1056#2:73\n669#2,11:74\n1#3:70\n*S KotlinDebug\n*F\n+ 1 RollComputer.kt\nru/octol1ttle/flightassistant/impl/computer/autoflight/base/RollComputer\n*L\n29#1:60,9\n29#1:69\n29#1:71\n29#1:72\n29#1:73\n36#1:74,11\n29#1:70\n*E\n"})
public final class RollComputer
extends Computer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<RollSource> sources;
    @NotNull
    private final List<FlightController> controllers;
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_neoforge("roll");

    public RollComputer(@NotNull ComputerBus computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
        this.sources = new ArrayList();
        this.controllers = new ArrayList();
    }

    @Override
    public void invokeEvents() {
        ((RollSourceRegistrationCallback)RollSourceRegistrationCallback.EVENT.invoker()).register(p0 -> this.sources.add((RollSource)p0));
        ((RollControllerRegistrationCallback)RollControllerRegistrationCallback.EVENT.invoker()).register(p0 -> this.controllers.add((FlightController)p0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void renderTick() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = CollectionExtensionsKt.filterWorking(this.controllers);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ControlInput it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            FlightController it = (FlightController)element$iv$iv;
            boolean bl2 = false;
            if ((ControlInput)this.getComputers().guardedCall(it, renderTick.inputs.1.1.INSTANCE) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List inputs2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ControlInput it = (ControlInput)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getPriority().getValue());
                it = (ControlInput)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority().getValue()));
            }
        });
        if (inputs2.isEmpty()) {
            return;
        }
        ControlInput controlInput = (ControlInput)CollectionsKt.firstOrNull(CollectionExtensionsKt.getActiveHighestPriority(inputs2));
        if (controlInput == null) {
            return;
        }
        ControlInput finalInput = controlInput;
        if (AirDataComputer.automationsAllowed$default(this.getComputers().getData(), false, 1, null) && finalInput.getStatus() == ControlInput.Status.ACTIVE) {
            Object v1;
            block7: {
                Iterable $this$singleOrNull$iv = CollectionExtensionsKt.filterWorking(this.sources);
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    RollSource it = (RollSource)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(this.getComputers().guardedCall(it, renderTick.rollSource.1.1.INSTANCE), (Object)true)) continue;
                    if (found$iv) {
                        v1 = null;
                        break block7;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v1 = !found$iv ? null : single$iv;
            }
            RollSource rollSource2 = v1;
            if (rollSource2 == null) {
                return;
            }
            RollSource rollSource3 = rollSource2;
            this.smoothSetRoll(rollSource3, MathHelperKt.throwIfNotInRange(finalInput.getTarget(), (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)-180.0f, (float)180.0f)), MathHelperKt.throwIfNotInRange(finalInput.getDeltaTimeMultiplier(), (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)0.001f, (float)Float.MAX_VALUE)));
        }
    }

    private final void smoothSetRoll(RollSource rollSource2, float target, float deltaTimeMultiplier) {
        float diff = MathHelperKt.findShortestPath(rollSource2.getRoll(), target, 360.0f);
        float closeDistanceMultiplier = diff == 0.0f ? 1.0f : RangesKt.coerceAtLeast((float)(1.0f / Math.abs(diff)), (float)1.0f);
        float delta = diff * ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(FATickCounter.INSTANCE.getTimePassed() * deltaTimeMultiplier * closeDistanceMultiplier), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)))).floatValue();
        rollSource2.addRoll(delta);
    }

    @Override
    public void reset() {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/base/RollComputer$Companion;", "", "<init>", "()V", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

