/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.computer.safety;

import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.autoflight.ControlInput;
import ru.octol1ttle.flightassistant.api.autoflight.FlightController;
import ru.octol1ttle.flightassistant.api.autoflight.thrust.ThrustControllerRegistrationCallback;
import ru.octol1ttle.flightassistant.api.computer.Computer;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.computer.ComputerQuery;
import ru.octol1ttle.flightassistant.config.FAConfig;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.base.PitchComputer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0002\u0018\u0019B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u001c\u0010\u0013\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u000fH\u0016R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/safety/StallComputer;", "Lru/octol1ttle/flightassistant/api/computer/Computer;", "Lru/octol1ttle/flightassistant/api/autoflight/FlightController;", "computers", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;)V", "value", "Lru/octol1ttle/flightassistant/impl/computer/safety/StallComputer$Status;", "status", "getStatus", "()Lru/octol1ttle/flightassistant/impl/computer/safety/StallComputer$Status;", "maximumSafePitch", "", "subscribeToEvents", "", "tick", "getThrustInput", "Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;", "handleQuery", "Response", "query", "Lru/octol1ttle/flightassistant/api/computer/ComputerQuery;", "reset", "Status", "Companion", "flightassistant-neoforge"})
public final class StallComputer
extends Computer
implements FlightController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Status status;
    private float maximumSafePitch;
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_neoforge("stall");

    public StallComputer(@NotNull ComputerBus computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
        this.status = Status.SAFE;
        this.maximumSafePitch = 90.0f;
    }

    @NotNull
    public final Status getStatus() {
        return this.status;
    }

    @Override
    public void subscribeToEvents() {
        ThrustControllerRegistrationCallback.EVENT.register(arg_0 -> StallComputer.subscribeToEvents$lambda$0(this, arg_0));
    }

    @Override
    public void tick() {
        float angleOfAttack = this.getComputers().getData().getPitch() - this.getComputers().getData().getFlightPitch();
        this.status = this.getComputers().getData().getFlying() && !this.getComputers().getData().getFallDistanceSafe() && angleOfAttack > 90.0f ? (this.status == Status.FULL_STALL || this.getComputers().getData().getVelocityPerSecond().y <= -10.0 ? Status.FULL_STALL : Status.APPROACHING_STALL) : Status.SAFE;
        this.maximumSafePitch = (float)RangesKt.coerceAtMost((double)((double)this.getComputers().getData().getFlightPitch() + 90.0), (double)(this.getComputers().getData().getForwardVelocityPerSecond().length() * 3.0 + 45.0));
    }

    @Override
    @Nullable
    public ControlInput getThrustInput() {
        if (this.status != Status.SAFE) {
            return new ControlInput(1.0f, (Component)Component.translatable((String)"mode.flightassistant.thrust.toga"), ControlInput.Priority.HIGHEST, 0.0f, ControlInput.Status.Companion.fromBooleans$default(ControlInput.Status.Companion, this.status == Status.FULL_STALL, false, FAConfig.INSTANCE.getSafety().getStallAutoThrust(), 2, null), 8, null);
        }
        return null;
    }

    @Override
    public <Response> void handleQuery(@NotNull ComputerQuery<Response> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        if (query instanceof PitchComputer.MaximumPitchQuery && this.maximumSafePitch <= 90.0f && !this.getComputers().getData().getFallDistanceSafe()) {
            ((PitchComputer.MaximumPitchQuery)query).respond(new ControlInput(this.maximumSafePitch - 5.0f, (Component)Component.translatable((String)"mode.flightassistant.vertical.stall_protection"), ControlInput.Priority.HIGHEST, 1.5f, ControlInput.Status.Companion.fromBooleans$default(ControlInput.Status.Companion, true, false, FAConfig.INSTANCE.getSafety().getStallLimitPitch(), 2, null)));
        }
    }

    @Override
    public void reset() {
        this.status = Status.SAFE;
        this.maximumSafePitch = 90.0f;
    }

    @Override
    @Nullable
    public ControlInput getPitchInput() {
        return FlightController.super.getPitchInput();
    }

    @Override
    @Nullable
    public ControlInput getHeadingInput() {
        return FlightController.super.getHeadingInput();
    }

    @Override
    @Nullable
    public ControlInput getRollInput() {
        return FlightController.super.getRollInput();
    }

    private static final void subscribeToEvents$lambda$0(StallComputer this$0, Consumer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.accept(this$0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/safety/StallComputer$Companion;", "", "<init>", "()V", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/safety/StallComputer$Status;", "", "<init>", "(Ljava/lang/String;I)V", "FULL_STALL", "APPROACHING_STALL", "SAFE", "flightassistant-neoforge"})
    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status FULL_STALL = new Status();
        public static final /* enum */ Status APPROACHING_STALL = new Status();
        public static final /* enum */ Status SAFE = new Status();
        private static final /* synthetic */ Status[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String value) {
            return Enum.valueOf(Status.class, value);
        }

        @NotNull
        public static EnumEntries<Status> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = statusArray = new Status[]{Status.FULL_STALL, Status.APPROACHING_STALL, Status.SAFE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

