/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.display;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.display.Display;
import ru.octol1ttle.flightassistant.api.display.HudFrame;
import ru.octol1ttle.flightassistant.api.util.extensions.GuiGraphicsExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;
import ru.octol1ttle.flightassistant.impl.computer.safety.VoidProximityComputer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u000e"}, d2={"Lru/octol1ttle/flightassistant/impl/display/RadarAltitudeDisplay;", "Lru/octol1ttle/flightassistant/api/display/Display;", "computers", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;)V", "allowedByConfig", "", "render", "", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "renderFaulted", "Companion", "flightassistant-neoforge"})
public final class RadarAltitudeDisplay
extends Display {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_neoforge("radar_altitude");

    public RadarAltitudeDisplay(@NotNull ComputerBus computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
    }

    @Override
    public boolean allowedByConfig() {
        return FAConfig.INSTANCE.getDisplay().getShowRadarAltitude();
    }

    @Override
    public void render(@NotNull GuiGraphics guiGraphics) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        Double groundLevel = this.getComputers().getGpws().getGroundY();
        if (!this.getComputers().getChunk().isCurrentLoaded() || groundLevel != null && groundLevel > this.getComputers().getHudData().getLerpedAltitude()) {
            this.renderFaulted(guiGraphics);
            return;
        }
        GuiGraphics $this$render_u24lambda_u240 = guiGraphics;
        boolean bl = false;
        int x = HudFrame.INSTANCE.getRight();
        int y = HudFrame.INSTANCE.getBottom() + 2;
        MutableComponent altType = null;
        String altString = null;
        int color = 0;
        if (groundLevel != null) {
            MutableComponent mutableComponent = Component.translatable((String)"short.flightassistant.ground");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            altType = mutableComponent;
            altString = String.valueOf(MathKt.roundToInt((double)(this.getComputers().getHudData().getLerpedAltitude() - groundLevel)));
            color = GuiGraphicsExtensionsKt.getPrimaryColor();
        } else {
            MutableComponent mutableComponent = Component.translatable((String)"short.flightassistant.void");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            altType = mutableComponent;
            altString = String.valueOf(MathKt.roundToInt((double)(this.getComputers().getHudData().getLerpedAltitude() - (double)this.getComputers().getData().getVoidY())));
            color = switch (WhenMappings.$EnumSwitchMapping$0[this.getComputers().getVoidProximity().getStatus().ordinal()]) {
                case 1 -> GuiGraphicsExtensionsKt.getWarningColor();
                case 2 -> GuiGraphicsExtensionsKt.getCautionColor();
                default -> GuiGraphicsExtensionsKt.getPrimaryColor();
            };
        }
        int xOffset = GuiGraphicsExtensionsKt.textWidth((FormattedText)altType) + 1;
        GuiGraphicsExtensionsKt.drawString$default($this$render_u24lambda_u240, (Component)altType, x - xOffset, y + 2, color, false, 16, null);
        $this$render_u24lambda_u240.renderOutline(x, y, GuiGraphicsExtensionsKt.textWidth(altString) + 5, 11, color);
        GuiGraphicsExtensionsKt.drawString$default($this$render_u24lambda_u240, altString, x + 3, y + 2, color, false, 16, null);
    }

    @Override
    public void renderFaulted(@NotNull GuiGraphics guiGraphics) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        GuiGraphics $this$renderFaulted_u24lambda_u241 = guiGraphics;
        boolean bl = false;
        MutableComponent mutableComponent = Component.translatable((String)"short.flightassistant.radar_altitude");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        GuiGraphicsExtensionsKt.drawString$default($this$renderFaulted_u24lambda_u241, (Component)mutableComponent, HudFrame.INSTANCE.getRight(), HudFrame.INSTANCE.getBottom() + 4, GuiGraphicsExtensionsKt.getWarningColor(), false, 16, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lru/octol1ttle/flightassistant/impl/display/RadarAltitudeDisplay$Companion;", "", "<init>", "()V", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VoidProximityComputer.Status.values().length];
            try {
                nArray[VoidProximityComputer.Status.REACHED_DAMAGE_ALTITUDE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VoidProximityComputer.Status.APPROACHING_DAMAGE_ALTITUDE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

