/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.display;

import com.mojang.blaze3d.vertex.PoseStack;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.display.Display;
import ru.octol1ttle.flightassistant.api.display.HudFrame;
import ru.octol1ttle.flightassistant.api.util.extensions.GuiGraphicsExtensionsKt;
import ru.octol1ttle.flightassistant.api.util.extensions.VectorExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.AutoFlightComputer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\u00020\t*\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u001c\u0010\u0010\u001a\u00020\t*\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0011H\u0002J4\u0010\u0012\u001a\u00020\u0007*\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0011H\u0002J\u001c\u0010\u0017\u001a\u00020\t*\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0011H\u0002J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u001a"}, d2={"Lru/octol1ttle/flightassistant/impl/display/SpeedDisplay;", "Lru/octol1ttle/flightassistant/api/display/Display;", "computers", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;)V", "allowedByConfig", "", "render", "", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "renderSpeedReading", "x", "", "y", "renderSpeedScale", "", "drawSpeedLine", "speed", "currentSpeed", "", "color", "renderSpeedTarget", "renderFaulted", "Companion", "flightassistant-neoforge"})
public final class SpeedDisplay
extends Display {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final float READING_MATRIX_SCALE = 1.5f;
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_neoforge("speed");

    public SpeedDisplay(@NotNull ComputerBus computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
    }

    @Override
    public boolean allowedByConfig() {
        return FAConfig.INSTANCE.getDisplay().getShowSpeedReading() || FAConfig.INSTANCE.getDisplay().getShowSpeedScale();
    }

    @Override
    public void render(@NotNull GuiGraphics guiGraphics) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        GuiGraphics $this$render_u24lambda_u240 = guiGraphics;
        boolean bl = false;
        if (FAConfig.INSTANCE.getDisplay().getShowSpeedReading()) {
            this.renderSpeedReading($this$render_u24lambda_u240, HudFrame.INSTANCE.getLeftF(), GuiGraphicsExtensionsKt.getCenterYF($this$render_u24lambda_u240));
        }
        if (FAConfig.INSTANCE.getDisplay().getShowSpeedScale()) {
            this.renderSpeedScale($this$render_u24lambda_u240, HudFrame.INSTANCE.getLeft(), GuiGraphicsExtensionsKt.getCenterY($this$render_u24lambda_u240));
        }
        if (FAConfig.INSTANCE.getDisplay().getShowAutomationModes()) {
            this.renderSpeedTarget($this$render_u24lambda_u240, HudFrame.INSTANCE.getLeft(), HudFrame.INSTANCE.getTop() - 9);
        }
    }

    private final void renderSpeedReading(GuiGraphics $this$renderSpeedReading, float x, float y) {
        PoseStack poseStack = $this$renderSpeedReading.pose();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"pose(...)");
        GuiGraphicsExtensionsKt.push(poseStack);
        GuiGraphicsExtensionsKt.fusedTranslateScale($this$renderSpeedReading, x * 1.005f, y, 1.5f);
        double speed = VectorExtensionsKt.perSecond(this.getComputers().getHudData().getLerpedForwardVelocity()).length();
        int color = speed <= 0.0 ? GuiGraphicsExtensionsKt.getWarningColor() : GuiGraphicsExtensionsKt.getPrimaryColor();
        String text = String.valueOf(MathKt.roundToInt((double)speed));
        int width = GuiGraphicsExtensionsKt.textWidth(text) + 5;
        int halfHeight = 6;
        int textY = -4;
        $this$renderSpeedReading.renderOutline(-width, -halfHeight, width, halfHeight * 2 - 1, color);
        GuiGraphicsExtensionsKt.drawRightAlignedString$default($this$renderSpeedReading, text, -2, textY, color, false, 16, null);
        PoseStack poseStack2 = $this$renderSpeedReading.pose();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack2, (String)"pose(...)");
        GuiGraphicsExtensionsKt.pop(poseStack2);
    }

    private final void renderSpeedScale(GuiGraphics $this$renderSpeedScale, int x, int y) {
        int i;
        double speed = VectorExtensionsKt.perSecond(this.getComputers().getHudData().getLerpedForwardVelocity()).length();
        int color = speed <= 0.0 ? GuiGraphicsExtensionsKt.getWarningColor() : GuiGraphicsExtensionsKt.getPrimaryColor();
        int minY = HudFrame.INSTANCE.getTop();
        int maxY = RangesKt.coerceIn((int)((int)((double)y + (double)GuiGraphicsExtensionsKt.getLineHeight() * (speed + 1.0))), (ClosedRange)((ClosedRange)new IntRange(minY - 1, HudFrame.INSTANCE.getBottom())));
        $this$renderSpeedScale.vLine(x, minY, maxY, color);
        $this$renderSpeedScale.enableScissor(0, minY, $this$renderSpeedScale.guiWidth(), maxY + 1);
        $this$renderSpeedScale.enableScissor(0, minY, $this$renderSpeedScale.guiWidth(), ((Number)(FAConfig.INSTANCE.getDisplay().getShowSpeedReading() ? (Number)Float.valueOf((float)y - 9.0f) : (Number)maxY)).intValue() + 1);
        $this$renderSpeedScale.hLine(x - 30, x, y, color);
        $this$renderSpeedScale.hLine(x - 35, x, minY, color);
        int n = MathKt.roundToInt((double)speed) + 100;
        if (i <= n) {
            for (i = MathKt.roundToInt((double)speed); this.drawSpeedLine($this$renderSpeedScale, x, y, i, speed, color) && i != n; ++i) {
            }
        }
        $this$renderSpeedScale.disableScissor();
        $this$renderSpeedScale.enableScissor(0, ((Number)(FAConfig.INSTANCE.getDisplay().getShowSpeedReading() ? (Number)Float.valueOf((float)y + 7.5f) : (Number)minY)).intValue(), $this$renderSpeedScale.guiWidth(), maxY + 1);
        $this$renderSpeedScale.hLine(x - 35, x, maxY, color);
        for (i = MathKt.roundToInt((double)speed); -1 < i && this.drawSpeedLine($this$renderSpeedScale, x, y, i, speed, color); --i) {
        }
        $this$renderSpeedScale.disableScissor();
        $this$renderSpeedScale.disableScissor();
    }

    private final boolean drawSpeedLine(GuiGraphics $this$drawSpeedLine, int x, int y, int speed, double currentSpeed, int color) {
        int textY = (int)((double)y + (double)GuiGraphicsExtensionsKt.getLineHeight() * (currentSpeed - (double)speed));
        if (textY < HudFrame.INSTANCE.getTop() - 100 || textY > HudFrame.INSTANCE.getBottom() + 100) {
            return false;
        }
        $this$drawSpeedLine.hLine(x - 5, x, textY, color);
        if (speed % 5 == 0) {
            GuiGraphicsExtensionsKt.drawRightAlignedString$default($this$drawSpeedLine, String.valueOf(speed), x - 6, textY - 3, color, false, 16, null);
        }
        return true;
    }

    private final void renderSpeedTarget(GuiGraphics $this$renderSpeedTarget, int x, int y) {
        int color = 0;
        AutoFlightComputer.ThrustMode active = this.getComputers().getAutoflight().getActiveThrustMode();
        if (this.getComputers().getAutoflight().getThrustInput() != null && active instanceof AutoFlightComputer.FollowsSpeedMode) {
            color = Intrinsics.areEqual((Object)active, (Object)this.getComputers().getAutoflight().getSelectedThrustMode()) ? GuiGraphicsExtensionsKt.getPrimaryAdvisoryColor() : GuiGraphicsExtensionsKt.getSecondaryAdvisoryColor();
            GuiGraphicsExtensionsKt.drawRightAlignedString$default($this$renderSpeedTarget, String.valueOf(((AutoFlightComputer.FollowsSpeedMode)((Object)active)).getTargetSpeed()), x, y, color, false, 16, null);
            return;
        }
        AutoFlightComputer.VerticalMode activeVertical = this.getComputers().getAutoflight().getActiveVerticalMode();
        if (this.getComputers().getAutoflight().getPitchInput() != null && activeVertical instanceof AutoFlightComputer.FollowsSpeedMode) {
            color = Intrinsics.areEqual((Object)activeVertical, (Object)this.getComputers().getAutoflight().getSelectedVerticalMode()) ? GuiGraphicsExtensionsKt.getPrimaryAdvisoryColor() : GuiGraphicsExtensionsKt.getSecondaryAdvisoryColor();
            GuiGraphicsExtensionsKt.drawRightAlignedString$default($this$renderSpeedTarget, String.valueOf(((AutoFlightComputer.FollowsSpeedMode)((Object)activeVertical)).getTargetSpeed()), x, y, color, false, 16, null);
        }
    }

    @Override
    public void renderFaulted(@NotNull GuiGraphics guiGraphics) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        GuiGraphics $this$renderFaulted_u24lambda_u241 = guiGraphics;
        boolean bl = false;
        MutableComponent mutableComponent = Component.translatable((String)"short.flightassistant.speed");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        GuiGraphicsExtensionsKt.drawRightAlignedString$default($this$renderFaulted_u24lambda_u241, (Component)mutableComponent, HudFrame.INSTANCE.getLeft(), GuiGraphicsExtensionsKt.getCenterY($this$renderFaulted_u24lambda_u241) - 5, GuiGraphicsExtensionsKt.getWarningColor(), false, 16, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00020\u00058\u0002X\u0083T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lru/octol1ttle/flightassistant/impl/display/SpeedDisplay$Companion;", "", "<init>", "()V", "READING_MATRIX_SCALE", "", "getREADING_MATRIX_SCALE$annotations", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="Increase GUI scale by 1 instead")
        private static /* synthetic */ void getREADING_MATRIX_SCALE$annotations() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

