/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.alert;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1102;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_1657;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.api.alert.AlertData;
import ru.octol1ttle.flightassistant.api.util.extensions.SoundManagerExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u0007\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0017\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0017\u0010\rR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\"\u0010\u001e\u001a\u00020\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0016\u0010%\u001a\u00020$8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0016\u0010'\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lru/octol1ttle/flightassistant/impl/alert/AlertSoundInstance;", "Lnet/minecraft/class_1102;", "Lnet/minecraft/class_1657;", "player", "Lru/octol1ttle/flightassistant/api/alert/AlertData;", "data", "<init>", "(Lnet/minecraft/class_1657;Lru/octol1ttle/flightassistant/api/alert/AlertData;)V", "", "shouldAlwaysPlay", "()Z", "", "tick", "()V", "repeat", "Lnet/minecraft/class_1144;", "soundManager", "setRepeat", "(ZLnet/minecraft/class_1144;)V", "", "ticksPassed", "fadeOut", "(I)Z", "silence", "Lnet/minecraft/class_1657;", "getPlayer", "()Lnet/minecraft/class_1657;", "Lru/octol1ttle/flightassistant/api/alert/AlertData;", "getData", "()Lru/octol1ttle/flightassistant/api/alert/AlertData;", "age", "I", "getAge", "()I", "setAge", "(I)V", "", "actualVolume", "F", "fadingOut", "Z", "flightassistant-fabric"})
public final class AlertSoundInstance
extends class_1102 {
    @NotNull
    private final class_1657 player;
    @NotNull
    private final AlertData data;
    private int age;
    private float actualVolume;
    private boolean fadingOut;

    public AlertSoundInstance(@NotNull class_1657 player, @NotNull AlertData data) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super(data.getSoundEvent(), class_3419.field_15250, class_1113.method_43221());
        this.player = player;
        this.data = data;
        this.actualVolume = 1.0f;
        this.field_18936 = true;
        this.field_5440 = class_1113.class_1114.field_5478;
        boolean bl = this.field_5446 = this.data.getRepeat() != AlertData.RepeatType.NO_REPEAT;
        if (this.data.getRepeat() == AlertData.RepeatType.REPEAT_FADE_IN_OUT) {
            this.actualVolume = 0.05f;
        }
        this.field_5442 = this.actualVolume * FAConfig.INSTANCE.getSafety().getAlertVolume();
    }

    @NotNull
    public final class_1657 getPlayer() {
        return this.player;
    }

    @NotNull
    public final AlertData getData() {
        return this.data;
    }

    public final int getAge() {
        return this.age;
    }

    public final void setAge(int n) {
        this.age = n;
    }

    public boolean method_4785() {
        return true;
    }

    public final void tick() {
        int n = this.age;
        this.age = n + 1;
        if (this.fadingOut) {
            return;
        }
        if (this.age > 100) {
            if (this.data.getRepeat().compareTo((Enum)AlertData.RepeatType.REPEAT_FADE_OUT) <= 0) {
                this.actualVolume = Math.max(0.3f, this.actualVolume - 0.007f);
            }
        } else if (this.data.getRepeat() == AlertData.RepeatType.REPEAT_FADE_IN_OUT) {
            this.actualVolume = Math.min(1.0f, this.actualVolume + 0.05f);
        }
        this.field_5442 = this.actualVolume * FAConfig.INSTANCE.getSafety().getAlertVolume();
    }

    public final void setRepeat(boolean repeat, @NotNull class_1144 soundManager) {
        Intrinsics.checkNotNullParameter((Object)soundManager, (String)"soundManager");
        this.field_5446 = repeat;
        SoundManagerExtensionsKt.setLooping(soundManager, (class_1113)this, this.field_5446);
    }

    public final boolean fadeOut(int ticksPassed) {
        this.fadingOut = true;
        this.field_5442 = Math.max(0.0f, this.field_5442 - 0.1f * (float)ticksPassed);
        return this.field_5442 <= 0.0f;
    }

    public final void silence() {
        this.field_5442 = 0.0f;
    }
}

