/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.computer;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_8103;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.computer.Computer;
import ru.octol1ttle.flightassistant.api.computer.ComputerView;
import ru.octol1ttle.flightassistant.api.util.FATickCounter;
import ru.octol1ttle.flightassistant.api.util.MathHelperKt;
import ru.octol1ttle.flightassistant.api.util.RenderMatrices;
import ru.octol1ttle.flightassistant.api.util.extensions.LivingEntityExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;
import ru.octol1ttle.flightassistant.mixin.EntityInvoker;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0019\u0018\u0000 N2\u00020\u0001:\u0001NB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0011\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0019\u0010\nR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001aR\u0011\u0010\u001e\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010!\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010%\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R$\u0010'\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u00168\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010\u0018R\u0011\u0010,\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0011\u00100\u001a\u00020-8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R.\u00101\u001a\u0004\u0018\u00010\u00132\b\u0010&\u001a\u0004\u0018\u00010\u00138\u0006@BX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b1\u00102\u001a\u0004\b3\u0010\u0015\"\u0004\b4\u00105R\u0014\u00109\u001a\u0002068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0011\u0010;\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b:\u0010 R$\u0010<\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u00168\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b<\u0010(\u001a\u0004\b=\u0010\u0018R$\u0010>\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u00168\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b>\u0010(\u001a\u0004\b?\u0010\u0018R\u0011\u0010A\u001a\u0002068F\u00a2\u0006\u0006\u001a\u0004\b@\u00108R\u0011\u0010C\u001a\u0002068F\u00a2\u0006\u0006\u001a\u0004\bB\u00108R\u0011\u0010E\u001a\u0002068F\u00a2\u0006\u0006\u001a\u0004\bD\u00108R*\u0010F\u001a\u0002062\u0006\u0010&\u001a\u0002068\u0006@BX\u0086\u000e\u00a2\u0006\u0012\n\u0004\bF\u0010G\u001a\u0004\bH\u00108\"\u0004\bI\u0010JR\u0011\u0010L\u001a\u0002068F\u00a2\u0006\u0006\u001a\u0004\bK\u00108R\u0011\u0010M\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\bM\u0010 \u00a8\u0006O"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/AirDataComputer;", "Lru/octol1ttle/flightassistant/api/computer/Computer;", "Lru/octol1ttle/flightassistant/api/computer/ComputerView;", "computers", "Lnet/minecraft/class_310;", "mc", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerView;Lnet/minecraft/class_310;)V", "", "tick", "()V", "", "checkFlying", "automationsAllowed", "(Z)Z", "Lnet/minecraft/class_1282;", "source", "isInvulnerableTo", "(Lnet/minecraft/class_1282;)Z", "", "computeGroundLevel", "()Ljava/lang/Double;", "Lnet/minecraft/class_243;", "computeForwardVelocity", "()Lnet/minecraft/class_243;", "reset", "Lnet/minecraft/class_310;", "Lnet/minecraft/class_746;", "getPlayer", "()Lnet/minecraft/class_746;", "player", "getFlying", "()Z", "flying", "Lnet/minecraft/class_638;", "getWorld", "()Lnet/minecraft/class_638;", "world", "value", "position", "Lnet/minecraft/class_243;", "getPosition", "getAltitude", "()D", "altitude", "", "getVoidLevel", "()I", "voidLevel", "groundLevel", "Ljava/lang/Double;", "getGroundLevel", "setGroundLevel", "(Ljava/lang/Double;)V", "", "getFallDistance", "()F", "fallDistance", "getFallDistanceSafe", "fallDistanceSafe", "velocity", "getVelocity", "forwardVelocity", "getForwardVelocity", "getPitch", "pitch", "getYaw", "yaw", "getHeading", "heading", "roll", "F", "getRoll", "setRoll", "(F)V", "getFlightPitch", "flightPitch", "isCurrentChunkLoaded", "Companion", "flightassistant-fabric"})
public final class AirDataComputer
extends Computer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final class_310 mc;
    @NotNull
    private class_243 position;
    @Nullable
    private Double groundLevel;
    @NotNull
    private class_243 velocity;
    @NotNull
    private class_243 forwardVelocity;
    private float roll;
    @NotNull
    private static final class_2960 ID = FlightAssistant.INSTANCE.id$flightassistant_fabric("air_data");

    public AirDataComputer(@NotNull ComputerView computers, @NotNull class_310 mc) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        super(computers);
        this.mc = mc;
        class_243 class_2432 = class_243.field_1353;
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"ZERO");
        this.position = class_2432;
        class_243 class_2433 = class_243.field_1353;
        Intrinsics.checkNotNullExpressionValue((Object)class_2433, (String)"ZERO");
        this.velocity = class_2433;
        class_243 class_2434 = class_243.field_1353;
        Intrinsics.checkNotNullExpressionValue((Object)class_2434, (String)"ZERO");
        this.forwardVelocity = class_2434;
    }

    @NotNull
    public final class_746 getPlayer() {
        class_746 class_7462 = this.mc.field_1724;
        if (class_7462 == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return class_7462;
    }

    public final boolean getFlying() {
        return LivingEntityExtensionsKt.getFallFlying((class_1309)this.getPlayer());
    }

    @NotNull
    public final class_638 getWorld() {
        class_638 class_6382 = this.mc.field_1687;
        if (class_6382 == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return class_6382;
    }

    @NotNull
    public final class_243 getPosition() {
        return this.position;
    }

    public final double getAltitude() {
        return this.position.field_1351;
    }

    public final int getVoidLevel() {
        return this.getWorld().method_31607() - 64;
    }

    @Nullable
    public final Double getGroundLevel() {
        return this.groundLevel;
    }

    private final void setGroundLevel(Double value) {
        Double d = value;
        this.groundLevel = d != null ? Double.valueOf(MathHelperKt.requireIn(d, (ClosedRange<Double>)((ClosedRange)RangesKt.rangeTo((double)this.getWorld().method_31607(), (double)Double.MAX_VALUE)))) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final float getFallDistance() {
        if (this.groundLevel == null) return Float.MAX_VALUE;
        Double d = this.groundLevel;
        Intrinsics.checkNotNull((Object)d);
        if (d == Double.MAX_VALUE) {
            return Float.MAX_VALUE;
        }
        boolean bl = false;
        if (bl) {
            return Float.MAX_VALUE;
        }
        float f = this.getPlayer().field_6017;
        double d2 = this.getAltitude();
        Double d3 = this.groundLevel;
        Intrinsics.checkNotNull((Object)d3);
        float f2 = Math.max(f, (float)(d2 - d3));
        return f2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getFallDistanceSafe() {
        if (this.getPlayer().method_5799()) return true;
        if (this.getFallDistance() <= (float)this.getPlayer().method_5850()) return true;
        class_1282 class_12822 = this.getPlayer().method_48923().method_48827();
        Intrinsics.checkNotNullExpressionValue((Object)class_12822, (String)"fall(...)");
        if (!this.isInvulnerableTo(class_12822)) return false;
        return true;
    }

    @NotNull
    public final class_243 getVelocity() {
        return this.velocity;
    }

    @NotNull
    public final class_243 getForwardVelocity() {
        return this.forwardVelocity;
    }

    public final float getPitch() {
        return -MathHelperKt.requireIn(this.getPlayer().method_36455(), (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)-90.0f, (float)90.0f));
    }

    public final float getYaw() {
        return MathHelperKt.requireIn(class_3532.method_15393((float)this.getPlayer().method_36454()), (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)-180.0f, (float)180.0f));
    }

    public final float getHeading() {
        return MathHelperKt.requireIn(this.getYaw() + 180.0f, (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)0.0f, (float)360.0f));
    }

    public final float getRoll() {
        return this.roll;
    }

    private final void setRoll(float value) {
        this.roll = MathHelperKt.requireIn(value, (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)-180.0f, (float)180.0f));
    }

    public final float getFlightPitch() {
        return MathHelperKt.degrees((float)Math.asin(this.velocity.method_1029().field_1351));
    }

    public final boolean isCurrentChunkLoaded() {
        return this.getWorld().method_2935().method_12123(this.getPlayer().method_31476().field_9181, this.getPlayer().method_31476().field_9180);
    }

    @Override
    public void tick() {
        this.position = this.getPlayer().method_30950(FATickCounter.INSTANCE.getTickProgress());
        this.setGroundLevel(this.computeGroundLevel());
        this.velocity = this.getPlayer().method_49339(FATickCounter.INSTANCE.getTickProgress());
        this.forwardVelocity = this.computeForwardVelocity();
        this.setRoll(MathHelperKt.degrees((float)Math.atan2(-RenderMatrices.INSTANCE.getWorldSpaceMatrix().m10(), RenderMatrices.INSTANCE.getWorldSpaceMatrix().m11())));
    }

    public final boolean automationsAllowed(boolean checkFlying) {
        return (!checkFlying || this.getFlying()) && (FAConfig.INSTANCE.getGlobal$flightassistant_fabric().getAutomationsAllowedInOverlays$flightassistant_fabric() || this.mc.field_1755 == null && this.mc.method_18506() == null);
    }

    public static /* synthetic */ boolean automationsAllowed$default(AirDataComputer airDataComputer, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return airDataComputer.automationsAllowed(bl);
    }

    public final boolean isInvulnerableTo(@NotNull class_1282 source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!FAConfig.INSTANCE.getSafety().getConsiderInvulnerability()) {
            return false;
        }
        class_746 class_7462 = this.getPlayer();
        Intrinsics.checkNotNull((Object)class_7462, (String)"null cannot be cast to non-null type ru.octol1ttle.flightassistant.mixin.EntityInvoker");
        return ((EntityInvoker)class_7462).invokeIsAlwaysInvulnerableTo(source) || this.getPlayer().method_31549().field_7480 && !source.method_48789(class_8103.field_42242) || this.getPlayer().method_31549().field_7478 && source.method_48789(class_8103.field_42250);
    }

    private final Double computeGroundLevel() {
        if (!this.isCurrentChunkLoaded()) {
            return this.groundLevel;
        }
        double minY = RangesKt.coerceAtLeast((double)this.getWorld().method_31607(), (double)(this.getAltitude() - (double)2500));
        class_3965 class_39652 = this.getWorld().method_17742(new class_3959(this.position, this.position.method_38499(class_2350.class_2351.field_11052, minY), class_3959.class_3960.field_17558, class_3959.class_242.field_1347, (class_1297)this.getPlayer()));
        Intrinsics.checkNotNullExpressionValue((Object)class_39652, (String)"raycast(...)");
        class_3965 result = class_39652;
        if (result.method_17783() == class_239.class_240.field_1333) {
            return result.method_17784().field_1351 > (double)this.getWorld().method_31607() ? Double.valueOf(Double.MAX_VALUE) : null;
        }
        return result.method_17784().field_1351;
    }

    private final class_243 computeForwardVelocity() {
        class_243 class_2432 = this.getPlayer().method_5720().method_1029();
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"normalize(...)");
        class_243 normalizedRotation = class_2432;
        class_243 class_2433 = this.velocity.method_1029();
        Intrinsics.checkNotNullExpressionValue((Object)class_2433, (String)"normalize(...)");
        class_243 normalizedVelocity = class_2433;
        class_243 class_2434 = this.velocity.method_1021(RangesKt.coerceAtLeast((double)normalizedRotation.method_1026(normalizedVelocity), (double)0.0));
        Intrinsics.checkNotNullExpressionValue((Object)class_2434, (String)"multiply(...)");
        return class_2434;
    }

    @Override
    public void reset() {
        this.position = class_243.field_1353;
        this.setGroundLevel(null);
        this.velocity = class_243.field_1353;
        this.forwardVelocity = class_243.field_1353;
        this.setRoll(0.0f);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/AirDataComputer$Companion;", "", "<init>", "()V", "Lnet/minecraft/class_2960;", "ID", "Lnet/minecraft/class_2960;", "getID", "()Lnet/minecraft/class_2960;", "flightassistant-fabric"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final class_2960 getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

