/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.computer.autoflight;

import dev.architectury.event.events.common.InteractionEvent;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1671;
import net.minecraft.class_1781;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_636;
import net.minecraft.class_746;
import net.minecraft.class_9284;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.autoflight.thrust.ThrustSource;
import ru.octol1ttle.flightassistant.api.autoflight.thrust.ThrustSourceRegistrationCallback;
import ru.octol1ttle.flightassistant.api.computer.Computer;
import ru.octol1ttle.flightassistant.api.computer.ComputerView;
import ru.octol1ttle.flightassistant.api.util.FATickCounter;
import ru.octol1ttle.flightassistant.api.util.LimitedFIFOQueue;
import ru.octol1ttle.flightassistant.api.util.event.FireworkBoostCallback;
import ru.octol1ttle.flightassistant.config.FAConfig;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 K2\u00020\u00012\u00020\u0002:\u0001KB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\u000bJ\u001d\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u0017\u0010\u0019\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001f\u0010\u001b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010!\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010$\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b$\u0010%J\u000f\u0010&\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b&\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010'R\u001a\u0010)\u001a\u00020(8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020\u00118\u0016X\u0096D\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b/\u0010\u001eR\u001a\u00100\u001a\u00020\u001f8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u00103R\u001a\u00104\u001a\u00020\u001f8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b4\u00101\u001a\u0004\b5\u00103R\u0016\u00107\u001a\u0002068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b7\u00108R\u0018\u00109\u001a\u0004\u0018\u0001068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b9\u0010:R\"\u0010;\u001a\u00020\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b;\u0010.\u001a\u0004\b<\u0010\u001e\"\u0004\b=\u0010>R\"\u0010?\u001a\u0002068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b?\u00108\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR(\u0010E\u001a\b\u0012\u0004\u0012\u0002060D8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bE\u0010F\u001a\u0004\bG\u0010H\"\u0004\bI\u0010J\u00a8\u0006L"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/FireworkComputer;", "Lru/octol1ttle/flightassistant/api/computer/Computer;", "Lru/octol1ttle/flightassistant/api/autoflight/thrust/ThrustSource;", "Lru/octol1ttle/flightassistant/api/computer/ComputerView;", "computers", "Lnet/minecraft/class_310;", "mc", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerView;Lnet/minecraft/class_310;)V", "", "subscribeToEvents", "()V", "tick", "Lnet/minecraft/class_1657;", "player", "Lnet/minecraft/class_1268;", "hand", "", "isEmptyOrSafe", "(Lnet/minecraft/class_1657;Lnet/minecraft/class_1268;)Z", "Lnet/minecraft/class_1799;", "stack", "isFireworkAndSafe", "(Lnet/minecraft/class_1799;)Z", "hasNoExplosions", "tryActivateFirework", "(Lnet/minecraft/class_1657;)V", "useFirework", "(Lnet/minecraft/class_1657;Lnet/minecraft/class_1268;)V", "isAvailable", "()Z", "", "currentThrust", "tickThrust", "(F)V", "targetSpeed", "calculateThrustForSpeed", "(F)F", "reset", "Lnet/minecraft/class_310;", "Lru/octol1ttle/flightassistant/api/autoflight/thrust/ThrustSource$Priority;", "priority", "Lru/octol1ttle/flightassistant/api/autoflight/thrust/ThrustSource$Priority;", "getPriority", "()Lru/octol1ttle/flightassistant/api/autoflight/thrust/ThrustSource$Priority;", "supportsReverse", "Z", "getSupportsReverse", "optimumClimbPitch", "F", "getOptimumClimbPitch", "()F", "altitudeHoldPitch", "getAltitudeHoldPitch", "", "safeFireworkCount", "I", "safeFireworkSlot", "Ljava/lang/Integer;", "waitingForResponse", "getWaitingForResponse", "setWaitingForResponse", "(Z)V", "lastActivationTime", "getLastActivationTime", "()I", "setLastActivationTime", "(I)V", "Lru/octol1ttle/flightassistant/api/util/LimitedFIFOQueue;", "responseTimes", "Lru/octol1ttle/flightassistant/api/util/LimitedFIFOQueue;", "getResponseTimes", "()Lru/octol1ttle/flightassistant/api/util/LimitedFIFOQueue;", "setResponseTimes", "(Lru/octol1ttle/flightassistant/api/util/LimitedFIFOQueue;)V", "Companion", "flightassistant-fabric"})
public final class FireworkComputer
extends Computer
implements ThrustSource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final class_310 mc;
    @NotNull
    private final ThrustSource.Priority priority;
    private final boolean supportsReverse;
    private final float optimumClimbPitch;
    private final float altitudeHoldPitch;
    private int safeFireworkCount;
    @Nullable
    private Integer safeFireworkSlot;
    private boolean waitingForResponse;
    private int lastActivationTime;
    @NotNull
    private LimitedFIFOQueue<Integer> responseTimes;
    @NotNull
    private static final class_2960 ID = FlightAssistant.INSTANCE.id$flightassistant_fabric("firework");

    public FireworkComputer(@NotNull ComputerView computers, @NotNull class_310 mc) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        super(computers);
        this.mc = mc;
        this.priority = ThrustSource.Priority.LOW;
        this.optimumClimbPitch = 55.0f;
        this.altitudeHoldPitch = 2.0f;
        this.responseTimes = new LimitedFIFOQueue(5);
    }

    @Override
    @NotNull
    public ThrustSource.Priority getPriority() {
        return this.priority;
    }

    @Override
    public boolean getSupportsReverse() {
        return this.supportsReverse;
    }

    @Override
    public float getOptimumClimbPitch() {
        return this.optimumClimbPitch;
    }

    @Override
    public float getAltitudeHoldPitch() {
        return this.altitudeHoldPitch;
    }

    public final boolean getWaitingForResponse() {
        return this.waitingForResponse;
    }

    public final void setWaitingForResponse(boolean bl) {
        this.waitingForResponse = bl;
    }

    public final int getLastActivationTime() {
        return this.lastActivationTime;
    }

    public final void setLastActivationTime(int n) {
        this.lastActivationTime = n;
    }

    @NotNull
    public final LimitedFIFOQueue<Integer> getResponseTimes() {
        return this.responseTimes;
    }

    public final void setResponseTimes(@NotNull LimitedFIFOQueue<Integer> limitedFIFOQueue) {
        Intrinsics.checkNotNullParameter(limitedFIFOQueue, (String)"<set-?>");
        this.responseTimes = limitedFIFOQueue;
    }

    @Override
    public void subscribeToEvents() {
        ThrustSourceRegistrationCallback.EVENT.register((Object)new ThrustSourceRegistrationCallback(this){
            final /* synthetic */ FireworkComputer this$0;
            {
                this.this$0 = $receiver;
            }

            public final void register(Consumer<ThrustSource> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                it.accept(this.this$0);
            }
        });
        InteractionEvent.RIGHT_CLICK_ITEM.register((arg_0, arg_1) -> FireworkComputer.subscribeToEvents$lambda$0(this, arg_0, arg_1));
        FireworkBoostCallback.EVENT.register((Object)new FireworkBoostCallback(this){
            final /* synthetic */ FireworkComputer this$0;
            {
                this.this$0 = $receiver;
            }

            public final void onFireworkBoost(class_1671 class_16712, class_746 class_7462) {
                Intrinsics.checkNotNullParameter((Object)class_7462, (String)"<unused var>");
                if (this.this$0.getWaitingForResponse()) {
                    this.this$0.setWaitingForResponse(false);
                    this.this$0.getResponseTimes().add(FATickCounter.INSTANCE.getTotalTicks() - this.this$0.getLastActivationTime());
                }
            }
        });
    }

    @Override
    public void tick() {
        if (!this.getComputers().getData().getFlying()) {
            this.waitingForResponse = false;
        }
        this.safeFireworkCount = 0;
        this.safeFireworkSlot = null;
        int lastSlotCount = 0;
        int n = class_1661.method_7368();
        for (int slot = 0; slot < n; ++slot) {
            class_1799 stack;
            Intrinsics.checkNotNullExpressionValue((Object)this.getComputers().getData().getPlayer().method_31548().method_5438(slot), (String)"getStack(...)");
            if (!this.isFireworkAndSafe(stack)) continue;
            this.safeFireworkCount += stack.method_7947();
            if (this.safeFireworkSlot != null && stack.method_7947() >= lastSlotCount) continue;
            this.safeFireworkSlot = slot;
            lastSlotCount = stack.method_7947();
        }
    }

    public final boolean isEmptyOrSafe(@NotNull class_1657 player, @NotNull class_1268 hand) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        class_1799 class_17992 = player.method_5998(hand);
        Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"getStackInHand(...)");
        return this.hasNoExplosions(class_17992);
    }

    private final boolean isFireworkAndSafe(class_1799 stack) {
        return stack.method_7909() instanceof class_1781 && this.hasNoExplosions(stack);
    }

    private final boolean hasNoExplosions(class_1799 stack) {
        Object object = (class_9284)stack.method_57824(class_9334.field_49616);
        return !(object != null && (object = object.comp_2392()) != null ? !object.isEmpty() : false);
    }

    private final void tryActivateFirework(class_1657 player) {
        if (FATickCounter.INSTANCE.getTotalTicks() < this.lastActivationTime + 10) {
            return;
        }
        class_1799 class_17992 = player.method_6079();
        Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"getOffHandStack(...)");
        if (this.isFireworkAndSafe(class_17992)) {
            this.useFirework(player, class_1268.field_5810);
        } else if (this.safeFireworkSlot != null) {
            class_1661 class_16612 = player.method_31548();
            Integer n = this.safeFireworkSlot;
            Intrinsics.checkNotNull((Object)n);
            class_16612.field_7545 = n;
            this.useFirework(player, class_1268.field_5808);
        }
    }

    private final void useFirework(class_1657 player, class_1268 hand) {
        class_636 class_6362 = this.mc.field_1761;
        Intrinsics.checkNotNull((Object)class_6362);
        class_6362.method_2919(player, hand);
        this.lastActivationTime = FATickCounter.INSTANCE.getTotalTicks();
        this.waitingForResponse = true;
    }

    @Override
    public boolean isAvailable() {
        return this.safeFireworkCount > 0;
    }

    @Override
    public void tickThrust(float currentThrust) {
        if ((double)currentThrust > this.getComputers().getData().getForwardVelocity().method_1033() * (double)20.0f / (double)30.0f) {
            this.tryActivateFirework((class_1657)this.getComputers().getData().getPlayer());
        }
    }

    @Override
    public float calculateThrustForSpeed(float targetSpeed) {
        return ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(targetSpeed / 30.0f), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)))).floatValue();
    }

    @Override
    public void reset() {
        this.safeFireworkCount = 0;
        this.safeFireworkSlot = null;
        this.waitingForResponse = false;
        this.lastActivationTime = 0;
        this.responseTimes.clear();
    }

    private static final class_1269 subscribeToEvents$lambda$0(FireworkComputer this$0, class_1657 player, class_1268 hand) {
        class_1799 class_17992 = player.method_5998(hand);
        Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"getStackInHand(...)");
        class_1799 stack = class_17992;
        if (!player.method_37908().method_8608()) {
            return (class_1269)class_1269.field_5811;
        }
        if (FAConfig.INSTANCE.getSafety().getFireworkLockExplosive()) {
            Intrinsics.checkNotNull((Object)player);
            Intrinsics.checkNotNull((Object)hand);
            if (!this$0.isEmptyOrSafe(player, hand)) {
                return (class_1269)class_1269.field_5814;
            }
        }
        if (!this$0.waitingForResponse && stack.method_7909() instanceof class_1781) {
            this$0.lastActivationTime = FATickCounter.INSTANCE.getTotalTicks();
            this$0.waitingForResponse = true;
        }
        return (class_1269)class_1269.field_5811;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/FireworkComputer$Companion;", "", "<init>", "()V", "Lnet/minecraft/class_2960;", "ID", "Lnet/minecraft/class_2960;", "getID", "()Lnet/minecraft/class_2960;", "flightassistant-fabric"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final class_2960 getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

