/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.computer.autoflight;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.autoflight.ControlInput;
import ru.octol1ttle.flightassistant.api.autoflight.FlightController;
import ru.octol1ttle.flightassistant.api.autoflight.pitch.PitchControllerRegistrationCallback;
import ru.octol1ttle.flightassistant.api.autoflight.pitch.PitchLimiter;
import ru.octol1ttle.flightassistant.api.autoflight.pitch.PitchLimiterRegistrationCallback;
import ru.octol1ttle.flightassistant.api.computer.Computer;
import ru.octol1ttle.flightassistant.api.computer.ComputerView;
import ru.octol1ttle.flightassistant.api.util.FATickCounter;
import ru.octol1ttle.flightassistant.api.util.MathHelperKt;
import ru.octol1ttle.flightassistant.api.util.event.ChangeLookDirectionEvents;
import ru.octol1ttle.flightassistant.api.util.extensions.CollectionExtensionsKt;
import ru.octol1ttle.flightassistant.impl.computer.AirDataComputer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u0000 .2\u00020\u00012\u00020\u0002:\u0001.B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\tJ\u000f\u0010\u000b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u000b\u0010\tJ\u000f\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u000f\u0010\tJ\u0011\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J/\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u001b\u0010\tR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010\u001fR\"\u0010!\u001a\u00020\f8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010\u000e\"\u0004\b$\u0010%R(\u0010'\u001a\u0004\u0018\u00010\u00102\b\u0010&\u001a\u0004\u0018\u00010\u00108\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010\u0012R(\u0010*\u001a\u0004\u0018\u00010\u00102\b\u0010&\u001a\u0004\u0018\u00010\u00108\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b*\u0010(\u001a\u0004\b+\u0010\u0012R(\u0010,\u001a\u0004\u0018\u00010\u00102\b\u0010&\u001a\u0004\u0018\u00010\u00108\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b,\u0010(\u001a\u0004\b-\u0010\u0012\u00a8\u0006/"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/PitchComputer;", "Lru/octol1ttle/flightassistant/api/computer/Computer;", "Lru/octol1ttle/flightassistant/api/autoflight/FlightController;", "Lru/octol1ttle/flightassistant/api/computer/ComputerView;", "computers", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerView;)V", "", "subscribeToEvents", "()V", "invokeEvents", "tick", "", "canMoveOrBlockPitch", "()Z", "updateSafePitches", "Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;", "getPitchInput", "()Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;", "Lnet/minecraft/class_1657;", "player", "", "current", "target", "deltaTimeMultiplier", "smoothSetPitch", "(Lnet/minecraft/class_1657;FFF)V", "reset", "", "Lru/octol1ttle/flightassistant/api/autoflight/pitch/PitchLimiter;", "limiters", "Ljava/util/List;", "controllers", "manualOverride", "Z", "getManualOverride$flightassistant_fabric", "setManualOverride$flightassistant_fabric", "(Z)V", "value", "minimumPitch", "Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;", "getMinimumPitch", "maximumPitch", "getMaximumPitch", "activeInput", "getActiveInput", "Companion", "flightassistant-fabric"})
@SourceDebugExtension(value={"SMAP\nPitchComputer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PitchComputer.kt\nru/octol1ttle/flightassistant/impl/computer/autoflight/PitchComputer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n1611#2,9:150\n1863#2:159\n1864#2:161\n1620#2:162\n1053#2:163\n1971#2,14:164\n1611#2,9:178\n1863#2:187\n1864#2:189\n1620#2:190\n1053#2:191\n2341#2,14:192\n1611#2,9:206\n1863#2:215\n1864#2:217\n1620#2:218\n1053#2:219\n1971#2,14:220\n1#3:160\n1#3:188\n1#3:216\n*S KotlinDebug\n*F\n+ 1 PitchComputer.kt\nru/octol1ttle/flightassistant/impl/computer/autoflight/PitchComputer\n*L\n60#1:150,9\n60#1:159\n60#1:161\n60#1:162\n60#1:163\n67#1:164,14\n91#1:178,9\n91#1:187\n91#1:189\n91#1:190\n91#1:191\n92#1:192,14\n99#1:206,9\n99#1:215\n99#1:217\n99#1:218\n99#1:219\n100#1:220,14\n60#1:160\n91#1:188\n99#1:216\n*E\n"})
public final class PitchComputer
extends Computer
implements FlightController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<PitchLimiter> limiters;
    @NotNull
    private final List<FlightController> controllers;
    private boolean manualOverride;
    @Nullable
    private ControlInput minimumPitch;
    @Nullable
    private ControlInput maximumPitch;
    @Nullable
    private ControlInput activeInput;
    @NotNull
    private static final class_2960 ID = FlightAssistant.INSTANCE.id$flightassistant_fabric("pitch");

    public PitchComputer(@NotNull ComputerView computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
        this.limiters = new ArrayList();
        this.controllers = new ArrayList();
    }

    public final boolean getManualOverride$flightassistant_fabric() {
        return this.manualOverride;
    }

    public final void setManualOverride$flightassistant_fabric(boolean bl) {
        this.manualOverride = bl;
    }

    @Nullable
    public final ControlInput getMinimumPitch() {
        return this.minimumPitch;
    }

    @Nullable
    public final ControlInput getMaximumPitch() {
        return this.maximumPitch;
    }

    @Nullable
    public final ControlInput getActiveInput() {
        return this.activeInput;
    }

    @Override
    public void subscribeToEvents() {
        PitchControllerRegistrationCallback.EVENT.register((Object)new PitchControllerRegistrationCallback(this){
            final /* synthetic */ PitchComputer this$0;
            {
                this.this$0 = $receiver;
            }

            public final void register(Consumer<FlightController> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                it.accept(this.this$0);
            }
        });
        ChangeLookDirectionEvents.PITCH.register((arg_0, arg_1) -> PitchComputer.subscribeToEvents$lambda$0(this, arg_0, arg_1));
    }

    @Override
    public void invokeEvents() {
        ((PitchLimiterRegistrationCallback)PitchLimiterRegistrationCallback.EVENT.invoker()).register(p0 -> this.limiters.add((PitchLimiter)p0));
        ((PitchControllerRegistrationCallback)PitchControllerRegistrationCallback.EVENT.invoker()).register(p0 -> this.controllers.add((FlightController)p0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void tick() {
        Object v0;
        void $this$mapNotNullTo$iv$iv;
        this.updateSafePitches();
        Iterable $this$mapNotNull$iv = CollectionExtensionsKt.filterNonFaulted(this.controllers);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ControlInput it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            FlightController it = (FlightController)element$iv$iv;
            boolean bl2 = false;
            if (it.getPitchInput() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List inputs = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ControlInput it = (ControlInput)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getPriority().getValue());
                it = (ControlInput)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority().getValue()));
            }
        });
        if (inputs.isEmpty()) {
            this.activeInput = null;
            return;
        }
        float pitch = this.getComputers().getData().getPitch();
        Iterable $this$maxByOrNull$iv = CollectionExtensionsKt.getActiveHighestPriority(inputs);
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                ControlInput it = (ControlInput)maxElem$iv;
                boolean bl = false;
                float maxValue$iv = it.getTarget();
                do {
                    Object e$iv = iterator$iv.next();
                    ControlInput it2 = (ControlInput)e$iv;
                    $i$a$-maxByOrNull-PitchComputer$tick$finalInput$1 = false;
                    float v$iv = it2.getTarget();
                    if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        ControlInput finalInput = v0;
        if (finalInput == null) {
            this.activeInput = null;
            return;
        }
        this.activeInput = finalInput;
        if (this.canMoveOrBlockPitch() && finalInput.getActive()) {
            float target = finalInput.getTarget();
            ControlInput controlInput = this.minimumPitch;
            if (!finalInput.getPriority().isHigherOrSame(controlInput != null ? controlInput.getPriority() : null)) {
                ControlInput controlInput2 = this.minimumPitch;
                Intrinsics.checkNotNull((Object)controlInput2);
                target = RangesKt.coerceAtLeast((float)target, (float)controlInput2.getTarget());
            }
            ControlInput controlInput3 = this.maximumPitch;
            if (!finalInput.getPriority().isHigherOrSame(controlInput3 != null ? controlInput3.getPriority() : null)) {
                ControlInput controlInput4 = this.maximumPitch;
                Intrinsics.checkNotNull((Object)controlInput4);
                target = RangesKt.coerceAtMost((float)target, (float)controlInput4.getTarget());
            }
            this.smoothSetPitch((class_1657)this.getComputers().getData().getPlayer(), pitch, MathHelperKt.requireIn(target, (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)-90.0f, (float)90.0f)), MathHelperKt.requireIn(finalInput.getDeltaTimeMultiplier(), (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)0.001f, (float)Float.MAX_VALUE)));
        }
    }

    private final boolean canMoveOrBlockPitch() {
        return !this.manualOverride && !this.getComputers().getProtections().getProtectionsLost() && AirDataComputer.automationsAllowed$default(this.getComputers().getData(), false, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateSafePitches() {
        Object v1;
        void $this$maxByOrNull$iv;
        Iterable $this$sortedBy$iv;
        void $this$mapNotNullTo$iv$iv;
        Object v0;
        void $this$minByOrNull$iv;
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        Iterable $this$mapNotNull$iv = CollectionExtensionsKt.filterNonFaulted(this.limiters);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
            ControlInput it$iv$iv;
            element$iv$iv = element$iv$iv$iv;
            boolean bl = false;
            PitchLimiter it = (PitchLimiter)element$iv$iv;
            boolean bl2 = false;
            if (it.getMaximumPitch() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$sortedBy$iv2 = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List maximums = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ControlInput it = (ControlInput)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getPriority().getValue());
                it = (ControlInput)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority().getValue()));
            }
        });
        $this$sortedBy$iv2 = CollectionExtensionsKt.getActiveHighestPriority(maximums);
        PitchComputer pitchComputer = this;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                ControlInput it = (ControlInput)minElem$iv;
                boolean bl = false;
                float minValue$iv = it.getTarget();
                do {
                    Object e$iv = iterator$iv.next();
                    ControlInput it2 = (ControlInput)e$iv;
                    $i$a$-minByOrNull-PitchComputer$updateSafePitches$1 = false;
                    float v$iv = it2.getTarget();
                    if (Float.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        pitchComputer.maximumPitch = v0;
        ControlInput max = this.maximumPitch;
        if (max != null) {
            MathHelperKt.requireIn(max.getTarget(), (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)-90.0f, (float)90.0f));
            MathHelperKt.requireIn(max.getDeltaTimeMultiplier(), (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)0.001f, (float)Float.MAX_VALUE));
        }
        Iterable $this$mapNotNull$iv2 = CollectionExtensionsKt.filterNonFaulted(this.limiters);
        boolean $i$f$mapNotNull2 = false;
        Iterable minValue$iv = $this$mapNotNull$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        element$iv$iv = $this$forEach$iv$iv$iv2.iterator();
        while (element$iv$iv.hasNext()) {
            ControlInput it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv2 = element$iv$iv$iv = element$iv$iv.next();
            boolean bl = false;
            PitchLimiter it = (PitchLimiter)element$iv$iv2;
            boolean bl4 = false;
            if (it.getMinimumPitch() == null) continue;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        $this$mapNotNull$iv2 = (List)destination$iv$iv2;
        boolean $i$f$sortedBy2 = false;
        List minimums = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ControlInput it = (ControlInput)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getPriority().getValue());
                it = (ControlInput)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority().getValue()));
            }
        });
        $this$sortedBy$iv = CollectionExtensionsKt.getActiveHighestPriority(minimums);
        pitchComputer = this;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv2 = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv2.hasNext()) {
            v1 = null;
        } else {
            Object maxElem$iv = iterator$iv2.next();
            if (!iterator$iv2.hasNext()) {
                v1 = maxElem$iv;
            } else {
                ControlInput it = (ControlInput)maxElem$iv;
                boolean bl = false;
                float maxValue$iv = it.getTarget();
                do {
                    Object e$iv = iterator$iv2.next();
                    ControlInput it3 = (ControlInput)e$iv;
                    $i$a$-maxByOrNull-PitchComputer$updateSafePitches$2 = false;
                    float v$iv = it3.getTarget();
                    if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv2.hasNext());
                v1 = maxElem$iv;
            }
        }
        pitchComputer.minimumPitch = v1;
        ControlInput min = this.minimumPitch;
        if (min != null) {
            MathHelperKt.requireIn(min.getTarget(), (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)-90.0f, (float)90.0f));
            MathHelperKt.requireIn(min.getDeltaTimeMultiplier(), (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)0.001f, (float)Float.MAX_VALUE));
        }
        if (max != null && min != null && max.getPriority().isHigherOrSame(min.getPriority())) {
            this.minimumPitch = ControlInput.copy$default(min, RangesKt.coerceAtMost((float)min.getTarget(), (float)max.getTarget()), null, null, 0.0f, false, null, 62, null);
        }
    }

    @Override
    @Nullable
    public ControlInput getPitchInput() {
        ControlInput max = this.maximumPitch;
        if (max != null && this.getComputers().getData().getPitch() > max.getTarget()) {
            return max;
        }
        ControlInput min = this.minimumPitch;
        if (min != null && this.getComputers().getData().getPitch() < min.getTarget()) {
            return min;
        }
        return null;
    }

    private final void smoothSetPitch(class_1657 player, float current, float target, float deltaTimeMultiplier) {
        float diff = target - current;
        float closeDistanceMultiplier = diff == 0.0f ? 1.0f : RangesKt.coerceAtLeast((float)(1.0f / Math.abs(diff)), (float)1.0f);
        float delta = diff * ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(FATickCounter.INSTANCE.getTimePassed() * deltaTimeMultiplier * closeDistanceMultiplier), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)))).floatValue();
        player.method_36457(player.method_36455() - delta);
        player.field_6004 -= delta;
    }

    @Override
    public void reset() {
        this.manualOverride = true;
        this.minimumPitch = null;
        this.maximumPitch = null;
        this.activeInput = null;
    }

    @Override
    @Nullable
    public ControlInput getThrustInput() {
        return FlightController.DefaultImpls.getThrustInput(this);
    }

    @Override
    @Nullable
    public ControlInput getHeadingInput() {
        return FlightController.DefaultImpls.getHeadingInput(this);
    }

    @Override
    @Nullable
    public ControlInput getRollInput() {
        return FlightController.DefaultImpls.getRollInput(this);
    }

    private static final void subscribeToEvents$lambda$0(PitchComputer this$0, float mcPitchDelta, List output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        if (this$0.canMoveOrBlockPitch()) {
            float pitchDelta = -mcPitchDelta;
            float oldPitch = this$0.getComputers().getData().getPitch();
            float newPitch = oldPitch + pitchDelta;
            ControlInput min = this$0.minimumPitch;
            ControlInput max = this$0.maximumPitch;
            if (max != null && max.getActive() && pitchDelta > 0.0f && newPitch > max.getTarget()) {
                output.add(new ControlInput(-RangesKt.coerceAtLeast((float)(max.getTarget() - oldPitch), (float)0.0f), max.getPriority(), null, 0.0f, false, null, 60, null));
            } else if (min != null && min.getActive() && pitchDelta < 0.0f && newPitch < min.getTarget()) {
                output.add(new ControlInput(-RangesKt.coerceAtMost((float)(min.getTarget() - oldPitch), (float)0.0f), min.getPriority(), null, 0.0f, false, null, 60, null));
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/PitchComputer$Companion;", "", "<init>", "()V", "Lnet/minecraft/class_2960;", "ID", "Lnet/minecraft/class_2960;", "getID", "()Lnet/minecraft/class_2960;", "flightassistant-fabric"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final class_2960 getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

