/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.computer.safety;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.alert.Alert;
import ru.octol1ttle.flightassistant.api.alert.AlertCategory;
import ru.octol1ttle.flightassistant.api.alert.AlertCategoryRegistrationCallback;
import ru.octol1ttle.flightassistant.api.alert.AlertData;
import ru.octol1ttle.flightassistant.api.computer.Computer;
import ru.octol1ttle.flightassistant.api.computer.ComputerView;
import ru.octol1ttle.flightassistant.api.util.ChangeTrackingArrayList;
import ru.octol1ttle.flightassistant.api.util.FATickCounter;
import ru.octol1ttle.flightassistant.api.util.extensions.CollectionExtensionsKt;
import ru.octol1ttle.flightassistant.api.util.extensions.SoundManagerExtensionsKt;
import ru.octol1ttle.flightassistant.impl.alert.AlertSoundInstance;
import ru.octol1ttle.flightassistant.impl.alert.autoflight.AutoThrustOffAlert;
import ru.octol1ttle.flightassistant.impl.alert.autoflight.AutopilotOffAlert;
import ru.octol1ttle.flightassistant.impl.alert.elytra.ElytraDurabilityCriticalAlert;
import ru.octol1ttle.flightassistant.impl.alert.elytra.ElytraDurabilityLowAlert;
import ru.octol1ttle.flightassistant.impl.alert.fault.DisplayFaultAlert;
import ru.octol1ttle.flightassistant.impl.alert.fault.computer.AlertComputerFaultAlert;
import ru.octol1ttle.flightassistant.impl.alert.fault.computer.ComputerFaultAlert;
import ru.octol1ttle.flightassistant.impl.alert.firework.FireworkExplosiveAlert;
import ru.octol1ttle.flightassistant.impl.alert.firework.FireworkNoResponseAlert;
import ru.octol1ttle.flightassistant.impl.alert.firework.FireworkSlowResponseAlert;
import ru.octol1ttle.flightassistant.impl.alert.flight_controls.ProtectionsLostAlert;
import ru.octol1ttle.flightassistant.impl.alert.gpws.PullUpAlert;
import ru.octol1ttle.flightassistant.impl.alert.gpws.SinkRateAlert;
import ru.octol1ttle.flightassistant.impl.alert.gpws.TerrainAheadAlert;
import ru.octol1ttle.flightassistant.impl.alert.navigation.ApproachingVoidDamageAltitudeAlert;
import ru.octol1ttle.flightassistant.impl.alert.navigation.NoChunksLoadedAlert;
import ru.octol1ttle.flightassistant.impl.alert.navigation.ReachedVoidDamageAltitudeAlert;
import ru.octol1ttle.flightassistant.impl.alert.navigation.SlowChunkLoadingAlert;
import ru.octol1ttle.flightassistant.impl.alert.stall.ApproachingStallAlert;
import ru.octol1ttle.flightassistant.impl.alert.stall.FullStallAlert;
import ru.octol1ttle.flightassistant.impl.alert.thrust.NoThrustSourceAlert;
import ru.octol1ttle.flightassistant.impl.alert.thrust.ReverseThrustNotSupportedAlert;
import ru.octol1ttle.flightassistant.impl.alert.thrust.ThrustLockedAlert;
import ru.octol1ttle.flightassistant.impl.computer.AirDataComputer;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.AutomationsComputer;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.FireworkComputer;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.HeadingComputer;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.PitchComputer;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.RollComputer;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.ThrustComputer;
import ru.octol1ttle.flightassistant.impl.computer.safety.ChunkStatusComputer;
import ru.octol1ttle.flightassistant.impl.computer.safety.ElytraStatusComputer;
import ru.octol1ttle.flightassistant.impl.computer.safety.GroundProximityComputer;
import ru.octol1ttle.flightassistant.impl.computer.safety.StallComputer;
import ru.octol1ttle.flightassistant.impl.computer.safety.VoidProximityComputer;
import ru.octol1ttle.flightassistant.impl.display.HudDisplayHost;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 /2\u00020\u0001:\u0001/B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0015\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0010\u001a\u00020\b\u00a2\u0006\u0004\b\u0010\u0010\nJ\r\u0010\u0011\u001a\u00020\b\u00a2\u0006\u0004\b\u0011\u0010\nJ\u000f\u0010\u0012\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0012\u0010\nJ\u000f\u0010\u0013\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0013\u0010\nJ\u0019\u0010\u0016\u001a\u00020\b2\b\b\u0002\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0018\u0010\nJ\u000f\u0010\u0019\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0019\u0010\nJ\u000f\u0010\u001a\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001a\u0010\nR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001bR\"\u0010\u001c\u001a\u00020\u00148\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010\u0017R\u001d\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0!8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R<\u0010+\u001a*\u0012\u0004\u0012\u00020'\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0(0&j\u0014\u0012\u0004\u0012\u00020'\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0(`*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R0\u0010.\u001a\u001e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020-0&j\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020-`*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010,\u00a8\u00060"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/safety/AlertComputer;", "Lru/octol1ttle/flightassistant/api/computer/Computer;", "Lru/octol1ttle/flightassistant/api/computer/ComputerView;", "computers", "Lnet/minecraft/class_1144;", "soundManager", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerView;Lnet/minecraft/class_1144;)V", "", "invokeEvents", "()V", "registerBuiltin", "Lru/octol1ttle/flightassistant/api/alert/AlertCategory;", "category", "register", "(Lru/octol1ttle/flightassistant/api/alert/AlertCategory;)V", "hideCurrentAlert", "showHiddenAlert", "tick", "updateAlerts", "", "force", "tickSoundsAndStopInactive", "(Z)V", "startNewSounds", "stopOutPrioritizedAlerts", "reset", "Lnet/minecraft/class_1144;", "alertsFaulted", "Z", "getAlertsFaulted$flightassistant_fabric", "()Z", "setAlertsFaulted$flightassistant_fabric", "", "categories", "Ljava/util/List;", "getCategories", "()Ljava/util/List;", "Ljava/util/HashMap;", "Lru/octol1ttle/flightassistant/api/alert/AlertData;", "Lru/octol1ttle/flightassistant/api/util/ChangeTrackingArrayList;", "Lru/octol1ttle/flightassistant/api/alert/Alert;", "Lkotlin/collections/HashMap;", "alertLists", "Ljava/util/HashMap;", "Lru/octol1ttle/flightassistant/impl/alert/AlertSoundInstance;", "sounds", "Companion", "flightassistant-fabric"})
@SourceDebugExtension(value={"SMAP\nAlertComputer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlertComputer.kt\nru/octol1ttle/flightassistant/impl/computer/safety/AlertComputer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,266:1\n1557#2:267\n1628#2,3:268\n1010#2,2:271\n1368#2:273\n1454#2,5:274\n1755#2,3:282\n1053#2:289\n2341#2,14:290\n1053#2:304\n1863#2,2:305\n1863#2,2:307\n1863#2,2:309\n503#3,3:279\n506#3,4:285\n*S KotlinDebug\n*F\n+ 1 AlertComputer.kt\nru/octol1ttle/flightassistant/impl/computer/safety/AlertComputer\n*L\n81#1:267\n81#1:268,3\n176#1:271,2\n182#1:273\n182#1:274,5\n207#1:282,3\n207#1:289\n209#1:290,14\n238#1:304\n256#1:305,2\n257#1:307,2\n258#1:309,2\n207#1:279,3\n207#1:285,4\n*E\n"})
public final class AlertComputer
extends Computer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final class_1144 soundManager;
    private boolean alertsFaulted;
    @NotNull
    private final List<AlertCategory> categories;
    @NotNull
    private final HashMap<AlertData, ChangeTrackingArrayList<Alert>> alertLists;
    @NotNull
    private final HashMap<AlertData, AlertSoundInstance> sounds;
    @NotNull
    private static final class_2960 ID = FlightAssistant.INSTANCE.id$flightassistant_fabric("alert");

    public AlertComputer(@NotNull ComputerView computers, @NotNull class_1144 soundManager) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        Intrinsics.checkNotNullParameter((Object)soundManager, (String)"soundManager");
        super(computers);
        this.soundManager = soundManager;
        this.categories = new ArrayList();
        this.alertLists = new HashMap();
        this.sounds = new HashMap();
    }

    public final boolean getAlertsFaulted$flightassistant_fabric() {
        return this.alertsFaulted;
    }

    public final void setAlertsFaulted$flightassistant_fabric(boolean bl) {
        this.alertsFaulted = bl;
    }

    @NotNull
    public final List<AlertCategory> getCategories() {
        return this.categories;
    }

    @Override
    public void invokeEvents() {
        this.registerBuiltin();
        ((AlertCategoryRegistrationCallback)AlertCategoryRegistrationCallback.EVENT.invoker()).register(this.getComputers(), this::register);
    }

    /*
     * WARNING - void declaration
     */
    private final void registerBuiltin() {
        Collection<DisplayFaultAlert> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        class_5250 class_52502 = class_2561.method_43471((String)"alert.flightassistant.alert");
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"translatable(...)");
        this.register(new AlertCategory((class_2561)class_52502).add(new AlertComputerFaultAlert(this.getComputers())));
        class_5250 class_52503 = class_2561.method_43471((String)"alert.flightassistant.autoflight");
        Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"translatable(...)");
        AlertCategory alertCategory = new AlertCategory((class_2561)class_52503);
        ComputerView computerView = this.getComputers();
        class_2960 class_29602 = AutomationsComputer.Companion.getID();
        class_5250 class_52504 = class_2561.method_43471((String)"alert.flightassistant.autoflight.fault");
        Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"translatable(...)");
        AlertCategory alertCategory2 = alertCategory.add(new ComputerFaultAlert(computerView, class_29602, (class_2561)class_52504, null, null, 24, null));
        ComputerView computerView2 = this.getComputers();
        class_2960 class_29603 = PitchComputer.Companion.getID();
        class_5250 class_52505 = class_2561.method_43471((String)"alert.flightassistant.autoflight.pitch_fault");
        Intrinsics.checkNotNullExpressionValue((Object)class_52505, (String)"translatable(...)");
        AlertCategory alertCategory3 = alertCategory2.add(new ComputerFaultAlert(computerView2, class_29603, (class_2561)class_52505, null, null, 24, null));
        ComputerView computerView3 = this.getComputers();
        class_2960 class_29604 = HeadingComputer.Companion.getID();
        class_5250 class_52506 = class_2561.method_43471((String)"alert.flightassistant.autoflight.heading_fault");
        Intrinsics.checkNotNullExpressionValue((Object)class_52506, (String)"translatable(...)");
        AlertCategory alertCategory4 = alertCategory3.add(new ComputerFaultAlert(computerView3, class_29604, (class_2561)class_52506, null, null, 24, null));
        ComputerView computerView4 = this.getComputers();
        class_2960 class_29605 = RollComputer.Companion.getID();
        class_5250 class_52507 = class_2561.method_43471((String)"alert.flightassistant.autoflight.roll_fault");
        Intrinsics.checkNotNullExpressionValue((Object)class_52507, (String)"translatable(...)");
        this.register(alertCategory4.add(new ComputerFaultAlert(computerView4, class_29605, (class_2561)class_52507, null, null, 24, null)).add(new AutopilotOffAlert(this.getComputers())).add(new AutoThrustOffAlert(this.getComputers())));
        class_5250 class_52508 = class_2561.method_43471((String)"alert.flightassistant.elytra");
        Intrinsics.checkNotNullExpressionValue((Object)class_52508, (String)"translatable(...)");
        AlertCategory alertCategory5 = new AlertCategory((class_2561)class_52508);
        ComputerView computerView5 = this.getComputers();
        class_2960 class_29606 = ElytraStatusComputer.Companion.getID();
        class_5250 class_52509 = class_2561.method_43471((String)"alert.flightassistant.elytra.fault");
        Intrinsics.checkNotNullExpressionValue((Object)class_52509, (String)"translatable(...)");
        this.register(alertCategory5.add(new ComputerFaultAlert(computerView5, class_29606, (class_2561)class_52509, null, null, 24, null)).add(new ElytraDurabilityCriticalAlert(this.getComputers())).add(new ElytraDurabilityLowAlert(this.getComputers())));
        class_5250 class_525010 = class_2561.method_43471((String)"alert.flightassistant.fault.hud");
        Intrinsics.checkNotNullExpressionValue((Object)class_525010, (String)"translatable(...)");
        Iterable iterable = HudDisplayHost.INSTANCE.identifiers();
        AlertCategory alertCategory6 = new AlertCategory((class_2561)class_525010);
        AlertComputer alertComputer = this;
        boolean $i$f$map = false;
        void var3_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            class_2960 class_29607 = (class_2960)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DisplayFaultAlert(this.getComputers(), (class_2960)it));
        }
        collection = (List)destination$iv$iv;
        alertComputer.register(alertCategory6.addAll((Collection<? extends Alert>)collection));
        class_5250 class_525011 = class_2561.method_43471((String)"alert.flightassistant.firework");
        Intrinsics.checkNotNullExpressionValue((Object)class_525011, (String)"translatable(...)");
        AlertCategory alertCategory7 = new AlertCategory((class_2561)class_525011);
        ComputerView computerView6 = this.getComputers();
        class_2960 class_29608 = FireworkComputer.Companion.getID();
        class_5250 class_525012 = class_2561.method_43471((String)"alert.flightassistant.firework.fault");
        Intrinsics.checkNotNullExpressionValue((Object)class_525012, (String)"translatable(...)");
        this.register(alertCategory7.add(new ComputerFaultAlert(computerView6, class_29608, (class_2561)class_525012, null, null, 24, null)).add(new FireworkExplosiveAlert(this.getComputers(), class_1268.field_5808)).add(new FireworkExplosiveAlert(this.getComputers(), class_1268.field_5810)).add(new FireworkNoResponseAlert(this.getComputers())).add(new FireworkSlowResponseAlert(this.getComputers())));
        class_5250 class_525013 = class_2561.method_43471((String)"alert.flightassistant.flight_controls");
        Intrinsics.checkNotNullExpressionValue((Object)class_525013, (String)"translatable(...)");
        AlertCategory alertCategory8 = new AlertCategory((class_2561)class_525013);
        ComputerView computerView7 = this.getComputers();
        class_2960 class_29609 = PitchComputer.Companion.getID();
        class_5250 class_525014 = class_2561.method_43471((String)"alert.flightassistant.flight_controls.pitch_fault");
        Intrinsics.checkNotNullExpressionValue((Object)class_525014, (String)"translatable(...)");
        this.register(alertCategory8.add(new ComputerFaultAlert(computerView7, class_29609, (class_2561)class_525014, CollectionsKt.listOf((Object)class_2561.method_43471((String)"alert.flightassistant.flight_controls.pitch_fault.use_manual_pitch")), null, 16, null)).add(new ProtectionsLostAlert(this.getComputers())));
        class_5250 class_525015 = class_2561.method_43471((String)"alert.flightassistant.gpws");
        Intrinsics.checkNotNullExpressionValue((Object)class_525015, (String)"translatable(...)");
        AlertCategory alertCategory9 = new AlertCategory((class_2561)class_525015);
        ComputerView computerView8 = this.getComputers();
        class_2960 class_296010 = GroundProximityComputer.Companion.getID();
        class_5250 class_525016 = class_2561.method_43471((String)"alert.flightassistant.gpws.fault");
        Intrinsics.checkNotNullExpressionValue((Object)class_525016, (String)"translatable(...)");
        this.register(alertCategory9.add(new ComputerFaultAlert(computerView8, class_296010, (class_2561)class_525016, null, null, 24, null)).add(new PullUpAlert(this.getComputers())).add(new SinkRateAlert(this.getComputers())).add(new TerrainAheadAlert(this.getComputers())));
        class_5250 class_525017 = class_2561.method_43471((String)"alert.flightassistant.navigation");
        Intrinsics.checkNotNullExpressionValue((Object)class_525017, (String)"translatable(...)");
        AlertCategory alertCategory10 = new AlertCategory((class_2561)class_525017);
        ComputerView computerView9 = this.getComputers();
        class_2960 class_296011 = AirDataComputer.Companion.getID();
        class_5250 class_525018 = class_2561.method_43471((String)"alert.flightassistant.navigation.air_data_fault");
        Intrinsics.checkNotNullExpressionValue((Object)class_525018, (String)"translatable(...)");
        AlertCategory alertCategory11 = alertCategory10.add(new ComputerFaultAlert(computerView9, class_296011, (class_2561)class_525018, null, AlertData.Companion.getMASTER_WARNING(), 8, null));
        ComputerView computerView10 = this.getComputers();
        class_2960 class_296012 = ChunkStatusComputer.Companion.getID();
        class_5250 class_525019 = class_2561.method_43471((String)"alert.flightassistant.navigation.chunk_status_fault");
        Intrinsics.checkNotNullExpressionValue((Object)class_525019, (String)"translatable(...)");
        AlertCategory alertCategory12 = alertCategory11.add(new ComputerFaultAlert(computerView10, class_296012, (class_2561)class_525019, null, null, 24, null));
        ComputerView computerView11 = this.getComputers();
        class_2960 class_296013 = VoidProximityComputer.Companion.getID();
        class_5250 class_525020 = class_2561.method_43471((String)"alert.flightassistant.navigation.void_proximity_fault");
        Intrinsics.checkNotNullExpressionValue((Object)class_525020, (String)"translatable(...)");
        this.register(alertCategory12.add(new ComputerFaultAlert(computerView11, class_296013, (class_2561)class_525020, null, null, 24, null)).add(new ReachedVoidDamageAltitudeAlert(this.getComputers())).add(new ApproachingVoidDamageAltitudeAlert(this.getComputers())).add(new NoChunksLoadedAlert(this.getComputers())).add(new SlowChunkLoadingAlert(this.getComputers())));
        class_5250 class_525021 = class_2561.method_43471((String)"alert.flightassistant.stall");
        Intrinsics.checkNotNullExpressionValue((Object)class_525021, (String)"translatable(...)");
        AlertCategory alertCategory13 = new AlertCategory((class_2561)class_525021);
        ComputerView computerView12 = this.getComputers();
        class_2960 class_296014 = StallComputer.Companion.getID();
        class_5250 class_525022 = class_2561.method_43471((String)"alert.flightassistant.stall.detection_fault");
        Intrinsics.checkNotNullExpressionValue((Object)class_525022, (String)"translatable(...)");
        this.register(alertCategory13.add(new ComputerFaultAlert(computerView12, class_296014, (class_2561)class_525022, null, null, 24, null)).add(new FullStallAlert(this.getComputers())).add(new ApproachingStallAlert(this.getComputers())));
        class_5250 class_525023 = class_2561.method_43471((String)"alert.flightassistant.thrust");
        Intrinsics.checkNotNullExpressionValue((Object)class_525023, (String)"translatable(...)");
        AlertCategory alertCategory14 = new AlertCategory((class_2561)class_525023);
        ComputerView computerView13 = this.getComputers();
        class_2960 class_296015 = ThrustComputer.Companion.getID();
        class_5250 class_525024 = class_2561.method_43471((String)"alert.flightassistant.thrust.fault");
        Intrinsics.checkNotNullExpressionValue((Object)class_525024, (String)"translatable(...)");
        this.register(alertCategory14.add(new ComputerFaultAlert(computerView13, class_296015, (class_2561)class_525024, null, null, 24, null)).add(new ThrustLockedAlert(this.getComputers())).add(new NoThrustSourceAlert(this.getComputers())).add(new ReverseThrustNotSupportedAlert(this.getComputers())));
    }

    public final void register(@NotNull AlertCategory category) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        if (this.categories.contains(category)) {
            throw new IllegalArgumentException("Already registered alert category: " + category.getCategoryText().getString());
        }
        this.categories.add(category);
    }

    public final void hideCurrentAlert() {
        for (AlertCategory category : this.categories) {
            if (category.getActiveAlerts().isEmpty()) continue;
            Alert alert = category.getActiveAlerts().remove(0);
            category.getIgnoredAlerts().add(alert);
            alert.onHide();
            break;
        }
    }

    public final void showHiddenAlert() {
        for (AlertCategory category : this.categories) {
            if (category.getIgnoredAlerts().isEmpty()) continue;
            category.getIgnoredAlerts().remove(0);
            break;
        }
    }

    @Override
    public void tick() {
        this.updateAlerts();
        if (this.getComputers().getData().getPlayer().method_29504() || !this.getComputers().getData().getFlying()) {
            this.tickSoundsAndStopInactive(true);
            return;
        }
        AlertComputer.tickSoundsAndStopInactive$default(this, false, 1, null);
        this.startNewSounds();
        this.stopOutPrioritizedAlerts();
    }

    /*
     * WARNING - void declaration
     */
    private final void updateAlerts() {
        void $this$flatMapTo$iv$iv;
        for (AlertCategory category : this.categories) {
            category.updateActiveAlerts(this.getComputers());
        }
        List<AlertCategory> $this$sortBy$iv = this.categories;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    AlertCategory it = (AlertCategory)a;
                    boolean bl = false;
                    Integer n = it.getHighestPriority();
                    it = (AlertCategory)b;
                    Comparable comparable = Integer.valueOf(n != null ? n : Integer.MAX_VALUE);
                    bl = false;
                    Integer n2 = it.getHighestPriority();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(n2 != null ? n2 : Integer.MAX_VALUE));
                }
            });
        }
        for (Object object : this.alertLists.values()) {
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"next(...)");
            ChangeTrackingArrayList list = (ChangeTrackingArrayList)object;
            list.startTracking();
        }
        Iterable $this$flatMap$iv = this.categories;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            AlertCategory it = (AlertCategory)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getActiveAlerts();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        for (Alert alert : (List)destination$iv$iv) {
            this.alertLists.computeIfAbsent(alert.getData(), arg_0 -> AlertComputer.updateAlerts$lambda$4(AlertComputer::updateAlerts$lambda$3, arg_0)).add(alert);
        }
    }

    private final void tickSoundsAndStopInactive(boolean force) {
        Iterator<Map.Entry<AlertData, AlertSoundInstance>> iterator = this.sounds.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<AlertData, AlertSoundInstance> entry;
            Intrinsics.checkNotNullExpressionValue(iterator.next(), (String)"next(...)");
            int i = 1;
            int n = FATickCounter.INSTANCE.getTicksPassed();
            if (i <= n) {
                while (true) {
                    entry.getValue().tick();
                    AlertSoundInstance alertSoundInstance = entry.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)alertSoundInstance), (String)"<get-value>(...)");
                    SoundManagerExtensionsKt.applyVolume(this.soundManager, (class_1113)alertSoundInstance);
                    if (i == n) break;
                    ++i;
                }
            }
            if (!force) {
                ChangeTrackingArrayList<Alert> changeTrackingArrayList = this.alertLists.get(entry.getKey());
                if (changeTrackingArrayList != null ? !changeTrackingArrayList.isEmpty() : false) continue;
            }
            entry.getValue().setRepeat(false, this.soundManager);
            if (entry.getValue().fadeOut(FATickCounter.INSTANCE.getTicksPassed())) {
                iterator.remove();
            }
            AlertSoundInstance alertSoundInstance = entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)alertSoundInstance), (String)"<get-value>(...)");
            SoundManagerExtensionsKt.applyVolume(this.soundManager, (class_1113)alertSoundInstance);
        }
    }

    static /* synthetic */ void tickSoundsAndStopInactive$default(AlertComputer alertComputer, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        alertComputer.tickSoundsAndStopInactive(bl);
    }

    /*
     * Unable to fully structure code
     */
    private final void startNewSounds() {
        $this$filterValues$iv = this.alertLists;
        $i$f$filterValues = false;
        result$iv = new LinkedHashMap<K, V>();
        for (Map.Entry<K, V> entry$iv : $this$filterValues$iv.entrySet()) {
            block15: {
                list = (ChangeTrackingArrayList)entry$iv.getValue();
                $i$a$-filterValues-AlertComputer$startNewSounds$newDatas$1 = false;
                if (list.hasNewElements((Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, startNewSounds$lambda$7$lambda$5(ru.octol1ttle.flightassistant.api.alert.Alert ), (Lru/octol1ttle/flightassistant/api/alert/Alert;)Ljava/lang/Boolean;)())) ** GOTO lbl-1000
                $this$any$iv = list;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (Alert)element$iv;
                        $i$a$-any-AlertComputer$startNewSounds$newDatas$1$2 = false;
                        if (!(this.sounds.containsKey(it.getData()) == false && it.getAlertMethod().audio() != false)) continue;
                        v0 = true;
                        break block15;
                    }
                    v0 = false;
                }
            }
            if (v0) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            if (!v1) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$sortedBy$iv = ((Map)result$iv).keySet();
        $i$f$sortedBy = false;
        newDatas = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                AlertData it = (AlertData)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getPriority());
                it = (AlertData)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority()));
            }
        });
        newHighestPriorityDatas = CollectionExtensionsKt.getHighestPriority(newDatas);
        v2 = this.sounds.keySet();
        Intrinsics.checkNotNullExpressionValue(v2, (String)"<get-keys>(...)");
        $this$minByOrNull$iv = v2;
        $i$f$minByOrNull = false;
        iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v3 = null;
        } else {
            minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v3 = minElem$iv;
            } else {
                it = (AlertData)minElem$iv;
                $i$a$-minByOrNull-AlertComputer$startNewSounds$activeHighestPriority$1 = false;
                minValue$iv = it.getPriority();
                do {
                    e$iv = iterator$iv.next();
                    it = (AlertData)e$iv;
                    $i$a$-minByOrNull-AlertComputer$startNewSounds$activeHighestPriority$1 = false;
                    v$iv = it.getPriority();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v3 = minElem$iv;
            }
        }
        v4 = v3;
        activeHighestPriority = v4 != null ? v4.getPriority() : 0x7FFFFFFF;
        anyStartedThisTick = false;
        var5_5 = newHighestPriorityDatas.iterator();
        while (var5_5.hasNext() && (data = (AlertData)var5_5.next()).getPriority() <= activeHighestPriority) {
            existing = this.sounds.get(data);
            if (existing != null && (existing.method_4786() || existing.getAge() <= 60)) continue;
            this.soundManager.method_4870((class_1113)existing);
            instance = new AlertSoundInstance((class_1657)this.getComputers().getData().getPlayer(), data);
            ((Map)this.sounds).put(data, instance);
            if (!anyStartedThisTick) {
                this.soundManager.method_4873((class_1113)instance);
            } else if (instance.method_4786()) {
                instance.silence();
                this.soundManager.method_4873((class_1113)instance);
                SoundManagerExtensionsKt.pause(this.soundManager, (class_1113)instance);
            }
            anyStartedThisTick = true;
        }
    }

    private final void stopOutPrioritizedAlerts() {
        boolean interrupt = false;
        Set<Map.Entry<AlertData, AlertSoundInstance>> set = this.sounds.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$sortedBy$iv = set;
        boolean $i$f$sortedBy = false;
        for (Object e : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((AlertData)it.getKey()).getPriority());
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((AlertData)it.getKey()).getPriority()));
            }
        })) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Map.Entry entry = (Map.Entry)e;
            if (!interrupt) {
                interrupt = true;
                if (!((AlertSoundInstance)((Object)entry.getValue())).method_4786()) continue;
                Object v = entry.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                SoundManagerExtensionsKt.resume(this.soundManager, (class_1113)v);
                continue;
            }
            if (((AlertSoundInstance)((Object)entry.getValue())).method_4786()) {
                Object v = entry.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                SoundManagerExtensionsKt.pause(this.soundManager, (class_1113)v);
                continue;
            }
            ((AlertSoundInstance)((Object)entry.getValue())).fadeOut(FATickCounter.INSTANCE.getTicksPassed());
        }
    }

    @Override
    public void reset() {
        Object it;
        Iterable $this$forEach$iv = this.categories;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (AlertCategory)element$iv;
            boolean bl = false;
            it.getActiveAlerts().clear();
        }
        $this$forEach$iv = this.categories;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (AlertCategory)element$iv;
            boolean bl = false;
            it.getIgnoredAlerts().clear();
        }
        Collection<AlertSoundInstance> collection = this.sounds.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        $this$forEach$iv = collection;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (AlertSoundInstance)((Object)element$iv);
            boolean bl = false;
            this.soundManager.method_4870((class_1113)it);
        }
        this.sounds.clear();
    }

    private static final ChangeTrackingArrayList updateAlerts$lambda$3(AlertData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ChangeTrackingArrayList();
    }

    private static final ChangeTrackingArrayList updateAlerts$lambda$4(Function1 $tmp0, Object p0) {
        return (ChangeTrackingArrayList)$tmp0.invoke(p0);
    }

    private static final boolean startNewSounds$lambda$7$lambda$5(Alert it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getAlertMethod().audio();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/safety/AlertComputer$Companion;", "", "<init>", "()V", "Lnet/minecraft/class_2960;", "ID", "Lnet/minecraft/class_2960;", "getID", "()Lnet/minecraft/class_2960;", "flightassistant-fabric"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final class_2960 getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

