/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.display;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.octol1ttle.flightassistant.FAKeyBindings;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.autoflight.ControlInput;
import ru.octol1ttle.flightassistant.api.computer.ComputerView;
import ru.octol1ttle.flightassistant.api.display.Display;
import ru.octol1ttle.flightassistant.api.display.HudFrame;
import ru.octol1ttle.flightassistant.api.util.FATickCounter;
import ru.octol1ttle.flightassistant.api.util.MathHelperKt;
import ru.octol1ttle.flightassistant.api.util.extensions.DrawContextExtensionsKt;
import ru.octol1ttle.flightassistant.api.util.extensions.TextExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.AutopilotLogicComputer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000e\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000f\u0010\rJ)\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0016\u0010\rJ\u0017\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0017\u0010\rR\u0014\u0010\u0018\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0019R\u0014\u0010\u001b\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u0019R\u0014\u0010\u001c\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u0019\u00a8\u0006\u001f"}, d2={"Lru/octol1ttle/flightassistant/impl/display/AutomationModesDisplay;", "Lru/octol1ttle/flightassistant/api/display/Display;", "Lru/octol1ttle/flightassistant/api/computer/ComputerView;", "computers", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerView;)V", "", "allowedByConfig", "()Z", "Lnet/minecraft/class_332;", "drawContext", "", "render", "(Lnet/minecraft/class_332;)V", "renderThrustMode", "renderPitchMode", "Lru/octol1ttle/flightassistant/impl/display/AutomationModesDisplay$ModeDisplay;", "display", "Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;", "input", "drawInput", "(Lnet/minecraft/class_332;Lru/octol1ttle/flightassistant/impl/display/AutomationModesDisplay$ModeDisplay;Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;)V", "renderAutomaticsMode", "renderFaulted", "thrustDisplay", "Lru/octol1ttle/flightassistant/impl/display/AutomationModesDisplay$ModeDisplay;", "pitchDisplay", "headingDisplay", "automationStatusDisplay", "Companion", "ModeDisplay", "flightassistant-fabric"})
public final class AutomationModesDisplay
extends Display {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModeDisplay thrustDisplay;
    @NotNull
    private final ModeDisplay pitchDisplay;
    @NotNull
    private final ModeDisplay headingDisplay;
    @NotNull
    private final ModeDisplay automationStatusDisplay;
    @NotNull
    private static final class_2960 ID = FlightAssistant.INSTANCE.id$flightassistant_fabric("automation_modes");
    private static final float TOTAL_MODES = 5.0f;

    public AutomationModesDisplay(@NotNull ComputerView computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
        this.thrustDisplay = new ModeDisplay(1);
        this.pitchDisplay = new ModeDisplay(2);
        this.headingDisplay = new ModeDisplay(3);
        this.automationStatusDisplay = new ModeDisplay(5);
    }

    @Override
    public boolean allowedByConfig() {
        return FAConfig.INSTANCE.getDisplay().getShowAutomationModes();
    }

    @Override
    public void render(@NotNull class_332 drawContext) {
        Intrinsics.checkNotNullParameter((Object)drawContext, (String)"drawContext");
        this.renderThrustMode(drawContext);
        this.renderPitchMode(drawContext);
        this.drawInput(drawContext, this.headingDisplay, this.getComputers().getHeading().getActiveInput());
        this.renderAutomaticsMode(drawContext);
    }

    private final void renderThrustMode(class_332 drawContext) {
        boolean thrustUnusable = this.getComputers().getThrust().getNoThrustSource() || this.getComputers().getThrust().getReverseUnsupported();
        ControlInput input = this.getComputers().getThrust().getActiveInput();
        if (input != null) {
            if (FAKeyBindings.INSTANCE.isHoldingThrust()) {
                class_5250 class_52502 = class_2561.method_43471((String)"mode.flightassistant.thrust.override");
                Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"translatable(...)");
                this.thrustDisplay.render(drawContext, (class_2561)TextExtensionsKt.setColor(class_52502, DrawContextExtensionsKt.getCautionColor()), false, DrawContextExtensionsKt.getCautionColor());
            } else {
                this.thrustDisplay.render(drawContext, input.getText(), input.getActive(), thrustUnusable || input.getActive() && input.getPriority().compareTo((Enum)ControlInput.Priority.NORMAL) < 0 ? Integer.valueOf(DrawContextExtensionsKt.getCautionColor()) : null);
            }
            return;
        }
        class_5250 class_52503 = class_2561.method_43470((String)(MathHelperKt.furtherFromZero(this.getComputers().getThrust().getCurrent() * (float)100) + "%"));
        Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"literal(...)");
        class_5250 thrustValueText = TextExtensionsKt.setColor(class_52503, DrawContextExtensionsKt.getPrimaryColor());
        if (this.getComputers().getThrust().getThrustLocked()) {
            class_5250 class_52504;
            if (this.getComputers().getThrust().getCurrent() > 0.99f) {
                class_5250 class_52505 = class_2561.method_43471((String)"mode.flightassistant.thrust.locked_toga");
                Intrinsics.checkNotNullExpressionValue((Object)class_52505, (String)"translatable(...)");
                class_52504 = TextExtensionsKt.setColor(class_52505, DrawContextExtensionsKt.getPrimaryColor());
            } else {
                Object[] objectArray = new Object[]{thrustValueText};
                class_5250 class_52506 = class_2561.method_43469((String)"mode.flightassistant.thrust.locked", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)class_52506, (String)"translatable(...)");
                class_52504 = TextExtensionsKt.setColor(class_52506, DrawContextExtensionsKt.getPrimaryColor());
            }
            this.thrustDisplay.render(drawContext, (class_2561)class_52504, false, FATickCounter.INSTANCE.getTotalTicks() % 20 >= 10 ? DrawContextExtensionsKt.getCautionColor() : 0);
            return;
        }
        if (!(this.getComputers().getThrust().getCurrent() == 0.0f)) {
            class_5250 class_52507;
            if (this.getComputers().getThrust().getCurrent() > 0.99f) {
                class_5250 class_52508 = class_2561.method_43471((String)"mode.flightassistant.thrust.manual_toga");
                Intrinsics.checkNotNullExpressionValue((Object)class_52508, (String)"translatable(...)");
                class_52507 = TextExtensionsKt.setColor(class_52508, DrawContextExtensionsKt.getSecondaryColor());
            } else {
                Object[] objectArray = new Object[]{thrustValueText};
                class_52507 = class_2561.method_43469((String)"mode.flightassistant.thrust.manual", (Object[])objectArray);
            }
            ModeDisplay.render$default(this.thrustDisplay, drawContext, (class_2561)class_52507, this.getComputers().getThrust().getCurrent() == 0.0f || this.getComputers().getThrust().getCurrent() > 0.99f, null, 8, null);
            return;
        }
        ModeDisplay.render$default(this.thrustDisplay, drawContext, null, true, null, 8, null);
    }

    private final void renderPitchMode(class_332 drawContext) {
        if (this.getComputers().getPitch().getManualOverride$flightassistant_fabric()) {
            class_5250 class_52502 = class_2561.method_43471((String)"mode.flightassistant.vertical.override");
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"translatable(...)");
            this.pitchDisplay.render(drawContext, (class_2561)TextExtensionsKt.setColor(class_52502, DrawContextExtensionsKt.getCautionColor()), false, DrawContextExtensionsKt.getCautionColor());
            return;
        }
        this.drawInput(drawContext, this.pitchDisplay, this.getComputers().getPitch().getActiveInput());
    }

    private final void drawInput(class_332 drawContext, ModeDisplay display, ControlInput input) {
        if (input != null) {
            display.render(drawContext, input.getText(), input.getActive(), input.getActive() && input.getPriority().compareTo((Enum)ControlInput.Priority.NORMAL) < 0 ? Integer.valueOf(DrawContextExtensionsKt.getCautionColor()) : null);
        } else {
            ModeDisplay.render$default(display, drawContext, null, true, null, 8, null);
        }
    }

    private final void renderAutomaticsMode(class_332 drawContext) {
        class_5250 class_52502 = class_2561.method_43473();
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"empty(...)");
        class_5250 text = class_52502;
        if (this.getComputers().getAutomations().getFlightDirectors()) {
            class_5250 class_52503 = class_2561.method_43471((String)"short.flightassistant.flight_directors");
            Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"translatable(...)");
            TextExtensionsKt.appendWithSeparation(text, (class_2561)class_52503);
        }
        if (this.getComputers().getAutomations().getAutoThrust()) {
            class_5250 class_52504 = class_2561.method_43471((String)"short.flightassistant.auto_thrust");
            Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"translatable(...)");
            class_5250 autoThrustText = class_52504;
            ControlInput controlInput = this.getComputers().getThrust().getActiveInput();
            TextExtensionsKt.appendWithSeparation(text, (class_2561)(Intrinsics.areEqual((Object)(controlInput != null ? controlInput.getIdentifier() : null), (Object)AutopilotLogicComputer.Companion.getID()) ? autoThrustText : TextExtensionsKt.setColor(autoThrustText, DrawContextExtensionsKt.getAdvisoryColor())));
        }
        if (this.getComputers().getAutomations().getAutopilot()) {
            class_5250 class_52505 = class_2561.method_43471((String)"short.flightassistant.autopilot");
            Intrinsics.checkNotNullExpressionValue((Object)class_52505, (String)"translatable(...)");
            TextExtensionsKt.appendWithSeparation(text, (class_2561)class_52505);
        }
        List list = text.method_10855();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSiblings(...)");
        this.automationStatusDisplay.render(drawContext, (class_2561)(!((Collection)list).isEmpty() ? text : null), true, this.getComputers().getAutomations().getAutopilotAlert() ? Integer.valueOf(DrawContextExtensionsKt.getWarningColor()) : (this.getComputers().getAutomations().getAutoThrustAlert() ? Integer.valueOf(DrawContextExtensionsKt.getCautionColor()) : null));
    }

    @Override
    public void renderFaulted(@NotNull class_332 drawContext) {
        Intrinsics.checkNotNullParameter((Object)drawContext, (String)"drawContext");
        class_332 $this$renderFaulted_u24lambda_u240 = drawContext;
        boolean bl = false;
        int x = DrawContextExtensionsKt.getCenterX($this$renderFaulted_u24lambda_u240);
        int y = HudFrame.INSTANCE.getTop() - 9;
        class_5250 class_52502 = class_2561.method_43471((String)"short.flightassistant.automation_modes");
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"translatable(...)");
        DrawContextExtensionsKt.drawMiddleAlignedText($this$renderFaulted_u24lambda_u240, (class_2561)class_52502, x, y, DrawContextExtensionsKt.getWarningColor());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lru/octol1ttle/flightassistant/impl/display/AutomationModesDisplay$Companion;", "", "<init>", "()V", "Lnet/minecraft/class_2960;", "ID", "Lnet/minecraft/class_2960;", "getID", "()Lnet/minecraft/class_2960;", "", "TOTAL_MODES", "F", "flightassistant-fabric"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final class_2960 getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J5\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0010R\u0018\u0010\u0011\u001a\u0004\u0018\u00010\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lru/octol1ttle/flightassistant/impl/display/AutomationModesDisplay$ModeDisplay;", "", "", "order", "<init>", "(I)V", "Lnet/minecraft/class_332;", "drawContext", "Lnet/minecraft/class_2561;", "text", "", "active", "borderColor", "", "render", "(Lnet/minecraft/class_332;Lnet/minecraft/class_2561;ZLjava/lang/Integer;)V", "I", "lastText", "Lnet/minecraft/class_2561;", "textChangedAt", "flightassistant-fabric"})
    public static final class ModeDisplay {
        private final int order;
        @Nullable
        private class_2561 lastText;
        private int textChangedAt;

        public ModeDisplay(int order) {
            this.order = order;
        }

        public final void render(@NotNull class_332 drawContext, @Nullable class_2561 text, boolean active, @Nullable Integer borderColor) {
            Intrinsics.checkNotNullParameter((Object)drawContext, (String)"drawContext");
            int farLeft = HudFrame.INSTANCE.getLeft() - 35;
            int farRight = HudFrame.INSTANCE.getRight() + 35;
            int farWidth = farRight - farLeft;
            int singleWidth = MathKt.roundToInt((float)(((float)farWidth - 4.0f) / 5.0f));
            int leftX = farLeft + (singleWidth + 1) * (this.order - 1);
            int rightX = this.order == 5 ? farRight + 1 : leftX + singleWidth;
            int y = HudFrame.INSTANCE.getTop() - 10;
            if (active && !Objects.equals(text, this.lastText)) {
                this.textChangedAt = FATickCounter.INSTANCE.getTotalTicks();
                this.lastText = text;
            }
            if (text != null) {
                DrawContextExtensionsKt.drawMiddleAlignedText(drawContext, text, (leftX + rightX) / 2, y, active ? DrawContextExtensionsKt.getPrimaryColor() : DrawContextExtensionsKt.getSecondaryColor());
            }
            if (borderColor != null || FATickCounter.INSTANCE.getTotalTicks() <= this.textChangedAt + (text == null ? 60 : 100)) {
                Integer n = borderColor;
                drawContext.method_49601(leftX, y - 2, rightX - leftX, 11, n != null ? n : DrawContextExtensionsKt.getSecondaryColor());
            }
        }

        public static /* synthetic */ void render$default(ModeDisplay modeDisplay, class_332 class_3322, class_2561 class_25612, boolean bl, Integer n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                bl = true;
            }
            if ((n2 & 8) != 0) {
                n = null;
            }
            modeDisplay.render(class_3322, class_25612, bl, n);
        }
    }
}

