/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.api.alert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.alert.Alert;
import ru.octol1ttle.flightassistant.api.alert.AlertData;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\b\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001b\u0010\f\u001a\u00020\u00002\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J'\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0016\b\u0002\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u001d\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00060\u001f8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010!\u001a\u0004\b#\u0010$R\u001d\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00060\u001f8\u0006\u00a2\u0006\f\n\u0004\b%\u0010!\u001a\u0004\b&\u0010$\u00a8\u0006'"}, d2={"Lru/octol1ttle/flightassistant/api/alert/AlertCategory;", "", "Lnet/minecraft/class_2561;", "categoryText", "<init>", "(Lnet/minecraft/class_2561;)V", "Lru/octol1ttle/flightassistant/api/alert/Alert;", "alert", "add", "(Lru/octol1ttle/flightassistant/api/alert/Alert;)Lru/octol1ttle/flightassistant/api/alert/AlertCategory;", "", "alerts", "addAll", "(Ljava/util/Collection;)Lru/octol1ttle/flightassistant/api/alert/AlertCategory;", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "computers", "", "updateActiveAlerts", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;)V", "", "getHighestPriority", "()Ljava/lang/Integer;", "Lkotlin/Function1;", "", "filter", "Lru/octol1ttle/flightassistant/api/alert/AlertData;", "getFirstData", "(Lkotlin/jvm/functions/Function1;)Lru/octol1ttle/flightassistant/api/alert/AlertData;", "Lnet/minecraft/class_2561;", "getCategoryText", "()Lnet/minecraft/class_2561;", "", "registeredAlerts", "Ljava/util/List;", "activeAlerts", "getActiveAlerts", "()Ljava/util/List;", "ignoredAlerts", "getIgnoredAlerts", "flightassistant-fabric"})
@SourceDebugExtension(value={"SMAP\nAlertCategory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlertCategory.kt\nru/octol1ttle/flightassistant/api/alert/AlertCategory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n1011#2,2:60\n295#2,2:62\n*S KotlinDebug\n*F\n+ 1 AlertCategory.kt\nru/octol1ttle/flightassistant/api/alert/AlertCategory\n*L\n48#1:60,2\n56#1:62,2\n*E\n"})
public final class AlertCategory {
    @NotNull
    private final class_2561 categoryText;
    @NotNull
    private final List<Alert> registeredAlerts;
    @NotNull
    private final List<Alert> activeAlerts;
    @NotNull
    private final List<Alert> ignoredAlerts;

    public AlertCategory(@NotNull class_2561 categoryText) {
        Intrinsics.checkNotNullParameter((Object)categoryText, (String)"categoryText");
        this.categoryText = categoryText;
        this.registeredAlerts = new ArrayList();
        this.activeAlerts = new ArrayList();
        this.ignoredAlerts = new ArrayList();
    }

    @NotNull
    public final class_2561 getCategoryText() {
        return this.categoryText;
    }

    @NotNull
    public final List<Alert> getActiveAlerts() {
        return this.activeAlerts;
    }

    @NotNull
    public final List<Alert> getIgnoredAlerts() {
        return this.ignoredAlerts;
    }

    @NotNull
    public final AlertCategory add(@NotNull Alert alert) {
        Intrinsics.checkNotNullParameter((Object)alert, (String)"alert");
        if (this.registeredAlerts.contains(alert)) {
            throw new IllegalArgumentException("Already registered alert: " + alert.getClass().getName());
        }
        this.registeredAlerts.add(alert);
        return this;
    }

    @NotNull
    public final AlertCategory addAll(@NotNull Collection<? extends Alert> alerts) {
        Intrinsics.checkNotNullParameter(alerts, (String)"alerts");
        for (Alert alert : alerts) {
            this.add(alert);
        }
        return this;
    }

    public final void updateActiveAlerts(@NotNull ComputerBus computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        for (Alert alert : this.registeredAlerts) {
            try {
                if (alert.shouldActivate()) {
                    if (this.activeAlerts.contains(alert) || this.ignoredAlerts.contains(alert)) continue;
                    this.activeAlerts.add(alert);
                    continue;
                }
                this.activeAlerts.remove(alert);
                this.ignoredAlerts.remove(alert);
            }
            catch (Throwable t) {
                computers.getAlert().setAlertsFaulted$flightassistant_fabric(true);
                FlightAssistant.INSTANCE.getLogger$flightassistant_fabric().error("Exception ticking alert of type: " + alert.getClass().getName(), t);
            }
        }
        List<Alert> $this$sortBy$iv = this.activeAlerts;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Alert it = (Alert)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getData().getPriority() + it.getPriorityOffset());
                    it = (Alert)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getData().getPriority() + it.getPriorityOffset()));
                }
            });
        }
    }

    @Nullable
    public final Integer getHighestPriority() {
        return this.activeAlerts.isEmpty() ? null : Integer.valueOf(this.activeAlerts.get(0).getPriority());
    }

    @Nullable
    public final AlertData getFirstData(@Nullable Function1<? super Alert, Boolean> filter) {
        AlertData alertData;
        if (filter != null) {
            Object v0;
            block3: {
                Iterable $this$firstOrNull$iv = this.activeAlerts;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    if (!((Boolean)filter.invoke(element$iv)).booleanValue()) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            Alert alert = v0;
            alertData = alert != null ? alert.getData() : null;
        } else {
            Alert alert = (Alert)CollectionsKt.firstOrNull(this.activeAlerts);
            alertData = alert != null ? alert.getData() : null;
        }
        return alertData;
    }

    public static /* synthetic */ AlertData getFirstData$default(AlertCategory alertCategory, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        return alertCategory.getFirstData((Function1<? super Alert, Boolean>)function1);
    }
}

