/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.computer.data;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1282;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.minecraft.class_8103;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.FAKeyMappings;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.computer.Computer;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.util.MathHelperKt;
import ru.octol1ttle.flightassistant.api.util.extensions.ClientPlayerExtensionsKt;
import ru.octol1ttle.flightassistant.api.util.extensions.LevelExtensionsKt;
import ru.octol1ttle.flightassistant.api.util.extensions.VectorExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;
import ru.octol1ttle.flightassistant.mixin.EntityInvoker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0010\u0007\n\u0002\b\r\u0018\u0000 P2\u00020\u0001:\u0001PB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0017\u0010\nR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0018R\u0011\u0010\u001c\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001f\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010#\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010&\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0011\u0010*\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0011\u0010,\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010)R\u0011\u0010.\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010)R\u0011\u00102\u001a\u00020/8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0014\u00104\u001a\u00020'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010)R\u0011\u00106\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u001eR\u0011\u00108\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b7\u0010%R\u0011\u0010:\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b9\u0010%R$\u0010<\u001a\u00020\u00132\u0006\u0010;\u001a\u00020\u00138\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b<\u0010=\u001a\u0004\b>\u0010%R$\u0010?\u001a\u00020\u00132\u0006\u0010;\u001a\u00020\u00138\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b?\u0010=\u001a\u0004\b@\u0010%R$\u0010A\u001a\u00020'2\u0006\u0010;\u001a\u00020'8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bA\u0010B\u001a\u0004\bC\u0010)R\u0011\u0010G\u001a\u00020D8F\u00a2\u0006\u0006\u001a\u0004\bE\u0010FR\u0011\u0010I\u001a\u00020D8F\u00a2\u0006\u0006\u001a\u0004\bH\u0010FR\u0011\u0010K\u001a\u00020D8F\u00a2\u0006\u0006\u001a\u0004\bJ\u0010FR\u0011\u0010M\u001a\u00020D8F\u00a2\u0006\u0006\u001a\u0004\bL\u0010FR\u0011\u0010O\u001a\u00020D8F\u00a2\u0006\u0006\u001a\u0004\bN\u0010F\u00a8\u0006Q"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/data/AirDataComputer;", "Lru/octol1ttle/flightassistant/api/computer/Computer;", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "computers", "Lnet/minecraft/class_310;", "mc", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;Lnet/minecraft/class_310;)V", "", "tick", "()V", "", "checkFlying", "automationsAllowed", "(Z)Z", "Lnet/minecraft/class_1282;", "source", "isInvulnerableTo", "(Lnet/minecraft/class_1282;)Z", "Lnet/minecraft/class_243;", "vector", "computeForwardVector", "(Lnet/minecraft/class_243;)Lnet/minecraft/class_243;", "reset", "Lnet/minecraft/class_310;", "Lnet/minecraft/class_746;", "getPlayer", "()Lnet/minecraft/class_746;", "player", "getFlying", "()Z", "flying", "Lnet/minecraft/class_638;", "getLevel", "()Lnet/minecraft/class_638;", "level", "getPosition", "()Lnet/minecraft/class_243;", "position", "", "getX", "()D", "x", "getZ", "z", "getAltitude", "altitude", "", "getVoidY", "()I", "voidY", "getFallDistance", "fallDistance", "getFallDistanceSafe", "fallDistanceSafe", "getVelocity", "velocity", "getVelocityPerSecond", "velocityPerSecond", "value", "forwardVelocity", "Lnet/minecraft/class_243;", "getForwardVelocity", "forwardVelocityPerSecond", "getForwardVelocityPerSecond", "forwardAcceleration", "D", "getForwardAcceleration", "", "getPitch", "()F", "pitch", "getYaw", "yaw", "getHeading", "heading", "getFlightPitch", "flightPitch", "getFlightYaw", "flightYaw", "Companion", "flightassistant-fabric"})
public final class AirDataComputer
extends Computer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final class_310 mc;
    @NotNull
    private class_243 forwardVelocity;
    @NotNull
    private class_243 forwardVelocityPerSecond;
    private double forwardAcceleration;
    @NotNull
    private static final class_2960 ID = FlightAssistant.INSTANCE.id$flightassistant_fabric("air_data");

    public AirDataComputer(@NotNull ComputerBus computers, @NotNull class_310 mc) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        super(computers);
        this.mc = mc;
        class_243 class_2432 = class_243.field_1353;
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"ZERO");
        this.forwardVelocity = class_2432;
        class_243 class_2433 = class_243.field_1353;
        Intrinsics.checkNotNullExpressionValue((Object)class_2433, (String)"ZERO");
        this.forwardVelocityPerSecond = class_2433;
    }

    @NotNull
    public final class_746 getPlayer() {
        class_746 class_7462 = this.mc.field_1724;
        if (class_7462 == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return class_7462;
    }

    public final boolean getFlying() {
        return this.getPlayer().method_6128();
    }

    @NotNull
    public final class_638 getLevel() {
        class_638 class_6382 = this.mc.field_1687;
        if (class_6382 == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return class_6382;
    }

    @NotNull
    public final class_243 getPosition() {
        class_243 class_2432 = this.getPlayer().method_73189();
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"position(...)");
        return class_2432;
    }

    public final double getX() {
        return this.getPosition().field_1352;
    }

    public final double getZ() {
        return this.getPosition().field_1350;
    }

    public final double getAltitude() {
        return this.getPosition().field_1351;
    }

    public final int getVoidY() {
        return LevelExtensionsKt.getBottomY((class_1937)this.getLevel()) - 64;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final double getFallDistance() {
        if (this.getComputers().getGpws().getGroundY() == null) return Double.MAX_VALUE;
        Double d = this.getComputers().getGpws().getGroundY();
        Intrinsics.checkNotNull((Object)d);
        if (d == Double.MAX_VALUE) {
            return Double.MAX_VALUE;
        }
        boolean bl = false;
        if (bl) {
            return Double.MAX_VALUE;
        }
        double d2 = this.getPlayer().field_6017;
        double d3 = this.getAltitude();
        Double d4 = this.getComputers().getGpws().getGroundY();
        Intrinsics.checkNotNull((Object)d4);
        double d5 = Math.max(d2, d3 - d4);
        return d5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getFallDistanceSafe() {
        if (this.getPlayer().method_5799()) return true;
        if (this.getFallDistance() <= (double)this.getPlayer().method_5850()) return true;
        class_1282 class_12822 = this.getPlayer().method_48923().method_48827();
        Intrinsics.checkNotNullExpressionValue((Object)class_12822, (String)"fall(...)");
        if (!this.isInvulnerableTo(class_12822)) return false;
        return true;
    }

    @NotNull
    public final class_243 getVelocity() {
        class_243 class_2432 = this.getPlayer().method_18798();
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"getDeltaMovement(...)");
        return class_2432;
    }

    @NotNull
    public final class_243 getVelocityPerSecond() {
        return VectorExtensionsKt.perSecond(this.getVelocity());
    }

    @NotNull
    public final class_243 getForwardVelocity() {
        return this.forwardVelocity;
    }

    @NotNull
    public final class_243 getForwardVelocityPerSecond() {
        return this.forwardVelocityPerSecond;
    }

    public final double getForwardAcceleration() {
        return this.forwardAcceleration;
    }

    public final float getPitch() {
        return -MathHelperKt.throwIfNotInRange(this.getPlayer().method_36455(), (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)-90.0f, (float)90.0f));
    }

    public final float getYaw() {
        return MathHelperKt.throwIfNotInRange(class_3532.method_15393((float)this.getPlayer().method_36454()), (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)-180.0f, (float)180.0f));
    }

    public final float getHeading() {
        return MathHelperKt.throwIfNotInRange(this.getYaw() + 180.0f, (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)0.0f, (float)360.0f));
    }

    public final float getFlightPitch() {
        return MathHelperKt.degrees((float)Math.asin(this.getVelocity().method_1029().field_1351));
    }

    public final float getFlightYaw() {
        return MathHelperKt.degrees((float)Math.atan2(-this.getVelocity().field_1352, this.getVelocity().field_1350));
    }

    @Override
    public void tick() {
        this.forwardVelocity = this.computeForwardVector(this.getVelocity());
        this.forwardVelocityPerSecond = VectorExtensionsKt.perSecond(this.forwardVelocity);
        this.forwardAcceleration = this.forwardVelocity.method_1033() - this.computeForwardVector(ClientPlayerExtensionsKt.getLerpedDeltaMovement((class_742)this.getPlayer(), 0.0f)).method_1033();
    }

    public final boolean automationsAllowed(boolean checkFlying) {
        if (FAKeyMappings.INSTANCE.getGlobalAutomationOverride().method_1434()) {
            return false;
        }
        return (!checkFlying || this.getFlying()) && (FAConfig.INSTANCE.getGlobal$flightassistant_fabric().getAutomationsAllowedInOverlays$flightassistant_fabric() || this.mc.field_1755 == null && this.mc.method_18506() == null);
    }

    public static /* synthetic */ boolean automationsAllowed$default(AirDataComputer airDataComputer, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return airDataComputer.automationsAllowed(bl);
    }

    public final boolean isInvulnerableTo(@NotNull class_1282 source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!FAConfig.INSTANCE.getSafety().getConsiderInvulnerability()) {
            return false;
        }
        class_746 class_7462 = this.getPlayer();
        Intrinsics.checkNotNull((Object)class_7462, (String)"null cannot be cast to non-null type ru.octol1ttle.flightassistant.mixin.EntityInvoker");
        return ((EntityInvoker)class_7462).invokeIsInvulnerableToBase(source) || this.getPlayer().method_31549().field_7480 && !source.method_48789(class_8103.field_42242) || this.getPlayer().method_31549().field_7478 && source.method_48789(class_8103.field_42250);
    }

    @NotNull
    public final class_243 computeForwardVector(@NotNull class_243 vector) {
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        class_243 class_2432 = this.getPlayer().method_5720().method_1029();
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"normalize(...)");
        class_243 normalizedLookAngle = class_2432;
        class_243 class_2433 = vector.method_1029();
        Intrinsics.checkNotNullExpressionValue((Object)class_2433, (String)"normalize(...)");
        class_243 normalizedVector = class_2433;
        class_243 class_2434 = vector.method_1021(RangesKt.coerceAtLeast((double)normalizedLookAngle.method_1026(normalizedVector), (double)0.0));
        Intrinsics.checkNotNullExpressionValue((Object)class_2434, (String)"scale(...)");
        return class_2434;
    }

    @Override
    public void reset() {
        class_243 class_2432 = class_243.field_1353;
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"ZERO");
        this.forwardVelocity = class_2432;
        class_243 class_2433 = class_243.field_1353;
        Intrinsics.checkNotNullExpressionValue((Object)class_2433, (String)"ZERO");
        this.forwardVelocityPerSecond = class_2433;
        this.forwardAcceleration = 0.0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/data/AirDataComputer$Companion;", "", "<init>", "()V", "Lnet/minecraft/class_2960;", "ID", "Lnet/minecraft/class_2960;", "getID", "()Lnet/minecraft/class_2960;", "flightassistant-fabric"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final class_2960 getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

