/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.display;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.octol1ttle.flightassistant.FAKeyMappings;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.autoflight.ControlInput;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.display.Display;
import ru.octol1ttle.flightassistant.api.display.HudFrame;
import ru.octol1ttle.flightassistant.api.util.FATickCounter;
import ru.octol1ttle.flightassistant.api.util.extensions.GuiGraphicsExtensionsKt;
import ru.octol1ttle.flightassistant.api.util.extensions.MutableComponentExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000e\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000f\u0010\rJ)\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0016\u0010\rJ\u0017\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0017\u0010\rR\u0014\u0010\u0018\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0019R\u0014\u0010\u001b\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u0019R\u0014\u0010\u001c\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u0019\u00a8\u0006\u001f"}, d2={"Lru/octol1ttle/flightassistant/impl/display/AutomationModesDisplay;", "Lru/octol1ttle/flightassistant/api/display/Display;", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "computers", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;)V", "", "allowedByConfig", "()Z", "Lnet/minecraft/class_332;", "guiGraphics", "", "render", "(Lnet/minecraft/class_332;)V", "renderThrustMode", "renderPitchMode", "Lru/octol1ttle/flightassistant/impl/display/AutomationModesDisplay$ModeDisplay;", "display", "Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;", "input", "renderInput", "(Lnet/minecraft/class_332;Lru/octol1ttle/flightassistant/impl/display/AutomationModesDisplay$ModeDisplay;Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;)V", "renderAutomaticsMode", "renderFaulted", "thrustDisplay", "Lru/octol1ttle/flightassistant/impl/display/AutomationModesDisplay$ModeDisplay;", "pitchDisplay", "headingDisplay", "automationStatusDisplay", "Companion", "ModeDisplay", "flightassistant-fabric"})
public final class AutomationModesDisplay
extends Display {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModeDisplay thrustDisplay;
    @NotNull
    private final ModeDisplay pitchDisplay;
    @NotNull
    private final ModeDisplay headingDisplay;
    @NotNull
    private final ModeDisplay automationStatusDisplay;
    @NotNull
    private static final class_2960 ID = FlightAssistant.INSTANCE.id$flightassistant_fabric("automation_modes");
    private static final float TOTAL_MODES = 4.0f;

    public AutomationModesDisplay(@NotNull ComputerBus computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
        this.thrustDisplay = new ModeDisplay(1);
        this.pitchDisplay = new ModeDisplay(2);
        this.headingDisplay = new ModeDisplay(3);
        this.automationStatusDisplay = new ModeDisplay(4);
    }

    @Override
    public boolean allowedByConfig() {
        return FAConfig.INSTANCE.getDisplay().getShowAutomationModes();
    }

    @Override
    public void render(@NotNull class_332 guiGraphics) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        this.renderThrustMode(guiGraphics);
        this.renderPitchMode(guiGraphics);
        this.renderInput(guiGraphics, this.headingDisplay, this.getComputers().getHeading().getActiveInput());
        this.renderAutomaticsMode(guiGraphics);
    }

    private final void renderThrustMode(class_332 guiGraphics) {
        boolean thrustUnusable = this.getComputers().getThrust().getNoThrustSource() || this.getComputers().getThrust().getReverseUnsupported();
        ControlInput input = this.getComputers().getThrust().getActiveInput();
        if (input != null && FAKeyMappings.INSTANCE.isHoldingThrust() || FAKeyMappings.INSTANCE.getGlobalAutomationOverride().method_1434()) {
            class_5250 class_52502 = class_2561.method_43471((String)"mode.flightassistant.thrust.override");
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"translatable(...)");
            this.thrustDisplay.render(guiGraphics, (class_2561)MutableComponentExtensionsKt.setColor(class_52502, GuiGraphicsExtensionsKt.getCautionColor()), ControlInput.Status.ACTIVE, GuiGraphicsExtensionsKt.getCautionColor());
            return;
        }
        if (input != null) {
            this.thrustDisplay.render(guiGraphics, input.getText(), input.getStatus(), thrustUnusable || input.getStatus() == ControlInput.Status.ACTIVE && input.getPriority().compareTo((Enum)ControlInput.Priority.NORMAL) < 0 ? Integer.valueOf(GuiGraphicsExtensionsKt.getCautionColor()) : null);
            return;
        }
        if (this.getComputers().getThrust().getThrustLocked()) {
            class_5250 class_52503;
            if (this.getComputers().getThrust().getCurrent() == 1.0f) {
                class_5250 class_52504 = class_2561.method_43471((String)"mode.flightassistant.thrust.locked_toga");
                Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"translatable(...)");
                class_52503 = MutableComponentExtensionsKt.setColor(class_52504, GuiGraphicsExtensionsKt.getPrimaryColor());
            } else {
                class_5250 class_52505 = class_2561.method_43471((String)"mode.flightassistant.thrust.locked");
                Intrinsics.checkNotNullExpressionValue((Object)class_52505, (String)"translatable(...)");
                class_52503 = MutableComponentExtensionsKt.setColor(class_52505, GuiGraphicsExtensionsKt.getPrimaryColor());
            }
            this.thrustDisplay.render(guiGraphics, (class_2561)class_52503, ControlInput.Status.ACTIVE, FATickCounter.INSTANCE.getTotalTicks() % 20 >= 10 ? GuiGraphicsExtensionsKt.getCautionColor() : 0);
            return;
        }
        if (!(this.getComputers().getThrust().getCurrent() == 0.0f)) {
            class_5250 class_52506;
            if (this.getComputers().getThrust().getCurrent() == 1.0f) {
                class_5250 class_52507 = class_2561.method_43471((String)"mode.flightassistant.thrust.manual.toga");
                Intrinsics.checkNotNullExpressionValue((Object)class_52507, (String)"translatable(...)");
                class_52506 = MutableComponentExtensionsKt.setColor(class_52507, GuiGraphicsExtensionsKt.getSecondaryColor());
            } else {
                class_52506 = this.getComputers().getThrust().getCurrent() < 0.0f ? class_2561.method_43471((String)"mode.flightassistant.thrust.manual.reverse") : class_2561.method_43471((String)"mode.flightassistant.thrust.manual");
            }
            this.thrustDisplay.render(guiGraphics, (class_2561)class_52506, ControlInput.Status.ACTIVE, thrustUnusable ? Integer.valueOf(GuiGraphicsExtensionsKt.getCautionColor()) : null);
            return;
        }
        ModeDisplay.render$default(this.thrustDisplay, guiGraphics, null, ControlInput.Status.ACTIVE, null, 8, null);
    }

    private final void renderPitchMode(class_332 guiGraphics) {
        if (FAKeyMappings.INSTANCE.getGlobalAutomationOverride().method_1434()) {
            class_5250 class_52502 = class_2561.method_43471((String)"mode.flightassistant.vertical.override");
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"translatable(...)");
            this.pitchDisplay.render(guiGraphics, (class_2561)MutableComponentExtensionsKt.setColor(class_52502, GuiGraphicsExtensionsKt.getCautionColor()), ControlInput.Status.ACTIVE, GuiGraphicsExtensionsKt.getCautionColor());
            return;
        }
        this.renderInput(guiGraphics, this.pitchDisplay, this.getComputers().getPitch().getActiveInput());
    }

    private final void renderInput(class_332 guiGraphics, ModeDisplay display, ControlInput input) {
        if (input != null) {
            display.render(guiGraphics, input.getText(), input.getStatus(), input.getStatus() == ControlInput.Status.ACTIVE && input.getPriority().compareTo((Enum)ControlInput.Priority.NORMAL) < 0 ? Integer.valueOf(GuiGraphicsExtensionsKt.getCautionColor()) : null);
        } else {
            ModeDisplay.render$default(display, guiGraphics, null, ControlInput.Status.ACTIVE, null, 8, null);
        }
    }

    private final void renderAutomaticsMode(class_332 guiGraphics) {
        class_5250 class_52502 = class_2561.method_43473();
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"empty(...)");
        class_5250 text = class_52502;
        if (this.getComputers().getAutoflight().getFlightDirectors()) {
            class_5250 class_52503 = class_2561.method_43471((String)"short.flightassistant.flight_directors_alt");
            Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"translatable(...)");
            MutableComponentExtensionsKt.appendWithSeparation$default(text, (class_2561)class_52503, null, 2, null);
        }
        if (this.getComputers().getAutoflight().getAutoThrust()) {
            class_5250 class_52504 = class_2561.method_43471((String)"short.flightassistant.auto_thrust");
            Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"translatable(...)");
            MutableComponentExtensionsKt.appendWithSeparation$default(text, (class_2561)class_52504, null, 2, null);
        }
        if (this.getComputers().getAutoflight().getAutopilot()) {
            class_5250 class_52505 = class_2561.method_43471((String)"short.flightassistant.autopilot");
            Intrinsics.checkNotNullExpressionValue((Object)class_52505, (String)"translatable(...)");
            MutableComponentExtensionsKt.appendWithSeparation$default(text, (class_2561)class_52505, null, 2, null);
        }
        Integer color = this.getComputers().getAutoflight().getAutopilotAlert() ? Integer.valueOf(GuiGraphicsExtensionsKt.getWarningColor()) : (this.getComputers().getAutoflight().getAutoThrustAlert() ? Integer.valueOf(GuiGraphicsExtensionsKt.getCautionColor()) : null);
        List list = text.method_10855();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSiblings(...)");
        this.automationStatusDisplay.render(guiGraphics, (class_2561)(!((Collection)list).isEmpty() || color != null ? text : null), ControlInput.Status.ACTIVE, FATickCounter.INSTANCE.getTotalTicks() % 20 >= 10 || color == null ? color : Integer.valueOf(0));
    }

    @Override
    public void renderFaulted(@NotNull class_332 guiGraphics) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        class_332 $this$renderFaulted_u24lambda_u240 = guiGraphics;
        boolean bl = false;
        int x = GuiGraphicsExtensionsKt.getCenterX($this$renderFaulted_u24lambda_u240);
        int y = HudFrame.INSTANCE.getTop() - 9;
        class_5250 class_52502 = class_2561.method_43471((String)"short.flightassistant.automation_modes");
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"translatable(...)");
        GuiGraphicsExtensionsKt.drawMiddleAlignedString$default($this$renderFaulted_u24lambda_u240, (class_2561)class_52502, x, y, GuiGraphicsExtensionsKt.getWarningColor(), false, 16, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lru/octol1ttle/flightassistant/impl/display/AutomationModesDisplay$Companion;", "", "<init>", "()V", "Lnet/minecraft/class_2960;", "ID", "Lnet/minecraft/class_2960;", "getID", "()Lnet/minecraft/class_2960;", "", "TOTAL_MODES", "F", "flightassistant-fabric"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final class_2960 getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J5\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0010R\u0018\u0010\u0011\u001a\u0004\u0018\u00010\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lru/octol1ttle/flightassistant/impl/display/AutomationModesDisplay$ModeDisplay;", "", "", "order", "<init>", "(I)V", "Lnet/minecraft/class_332;", "guiGraphics", "Lnet/minecraft/class_2561;", "text", "Lru/octol1ttle/flightassistant/api/autoflight/ControlInput$Status;", "status", "borderColor", "", "render", "(Lnet/minecraft/class_332;Lnet/minecraft/class_2561;Lru/octol1ttle/flightassistant/api/autoflight/ControlInput$Status;Ljava/lang/Integer;)V", "I", "lastText", "Lnet/minecraft/class_2561;", "textChangedAt", "flightassistant-fabric"})
    public static final class ModeDisplay {
        private final int order;
        @Nullable
        private class_2561 lastText;
        private int textChangedAt;

        public ModeDisplay(int order) {
            this.order = order;
        }

        public final void render(@NotNull class_332 guiGraphics, @Nullable class_2561 text, @NotNull ControlInput.Status status, @Nullable Integer borderColor) {
            Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            int farLeft = HudFrame.INSTANCE.getLeft() + 1;
            int farRight = HudFrame.INSTANCE.getRight() - 1;
            int farWidth = farRight - farLeft;
            int singleWidth = MathKt.roundToInt((float)(((float)farWidth - 3.0f) / 4.0f));
            int leftX = farLeft + (singleWidth + 1) * (this.order - 1);
            int rightX = this.order == 4 ? farRight + 1 : leftX + singleWidth;
            int y = HudFrame.INSTANCE.getTop() - 9;
            if (status == ControlInput.Status.ACTIVE && !Objects.equals(text, this.lastText)) {
                this.textChangedAt = FATickCounter.INSTANCE.getTotalTicks();
                this.lastText = text;
            }
            if (text != null) {
                int n;
                switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                    case 1: {
                        n = GuiGraphicsExtensionsKt.getPrimaryColor();
                        break;
                    }
                    case 2: {
                        n = GuiGraphicsExtensionsKt.getPrimaryAdvisoryColor();
                        break;
                    }
                    case 3: {
                        n = GuiGraphicsExtensionsKt.getCautionColor();
                        break;
                    }
                    case 4: {
                        return;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                int color = n;
                GuiGraphicsExtensionsKt.drawMiddleAlignedString$default(guiGraphics, text, (leftX + rightX) / 2, y, color, false, 16, null);
                if (borderColor != null || FATickCounter.INSTANCE.getTotalTicks() <= this.textChangedAt + 100) {
                    Integer n2 = borderColor;
                    GuiGraphicsExtensionsKt.renderOutline(guiGraphics, leftX, y - 2, rightX - leftX, 11, n2 != null ? n2 : GuiGraphicsExtensionsKt.getSecondaryColor());
                }
            }
        }

        public static /* synthetic */ void render$default(ModeDisplay modeDisplay, class_332 class_3322, class_2561 class_25612, ControlInput.Status status, Integer n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                status = ControlInput.Status.ACTIVE;
            }
            if ((n2 & 8) != 0) {
                n = null;
            }
            modeDisplay.render(class_3322, class_25612, status, n);
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ControlInput.Status.values().length];
                try {
                    nArray[ControlInput.Status.ACTIVE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ControlInput.Status.ARMED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ControlInput.Status.UNAVAILABLE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ControlInput.Status.DISABLED.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

