/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.display;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.display.Display;
import ru.octol1ttle.flightassistant.api.display.HudFrame;
import ru.octol1ttle.flightassistant.api.util.extensions.GuiGraphicsExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;
import ru.octol1ttle.flightassistant.impl.computer.safety.VoidProximityComputer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000e\u0010\r\u00a8\u0006\u0010"}, d2={"Lru/octol1ttle/flightassistant/impl/display/RadarAltitudeDisplay;", "Lru/octol1ttle/flightassistant/api/display/Display;", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "computers", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;)V", "", "allowedByConfig", "()Z", "Lnet/minecraft/class_332;", "guiGraphics", "", "render", "(Lnet/minecraft/class_332;)V", "renderFaulted", "Companion", "flightassistant-fabric"})
public final class RadarAltitudeDisplay
extends Display {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final class_2960 ID = FlightAssistant.INSTANCE.id$flightassistant_fabric("radar_altitude");

    public RadarAltitudeDisplay(@NotNull ComputerBus computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
    }

    @Override
    public boolean allowedByConfig() {
        return FAConfig.INSTANCE.getDisplay().getShowRadarAltitude();
    }

    @Override
    public void render(@NotNull class_332 guiGraphics) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        Double groundLevel = this.getComputers().getGpws().getGroundY();
        if (!this.getComputers().getChunk().isCurrentLoaded() || groundLevel != null && groundLevel > this.getComputers().getHudData().getLerpedAltitude()) {
            this.renderFaulted(guiGraphics);
            return;
        }
        class_332 $this$render_u24lambda_u240 = guiGraphics;
        boolean bl = false;
        int x = HudFrame.INSTANCE.getRight();
        int y = HudFrame.INSTANCE.getBottom() + 2;
        class_5250 altType = null;
        String altString = null;
        int color = 0;
        if (groundLevel != null) {
            class_5250 class_52502 = class_2561.method_43471((String)"short.flightassistant.ground");
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"translatable(...)");
            altType = class_52502;
            altString = String.valueOf(MathKt.roundToInt((double)(this.getComputers().getHudData().getLerpedAltitude() - groundLevel)));
            color = GuiGraphicsExtensionsKt.getPrimaryColor();
        } else {
            class_5250 class_52503 = class_2561.method_43471((String)"short.flightassistant.void");
            Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"translatable(...)");
            altType = class_52503;
            altString = String.valueOf(MathKt.roundToInt((double)(this.getComputers().getHudData().getLerpedAltitude() - (double)this.getComputers().getData().getVoidY())));
            color = switch (WhenMappings.$EnumSwitchMapping$0[this.getComputers().getVoidProximity().getStatus().ordinal()]) {
                case 1 -> GuiGraphicsExtensionsKt.getWarningColor();
                case 2 -> GuiGraphicsExtensionsKt.getCautionColor();
                default -> GuiGraphicsExtensionsKt.getPrimaryColor();
            };
        }
        int xOffset = GuiGraphicsExtensionsKt.textWidth((class_5348)altType) + 1;
        GuiGraphicsExtensionsKt.drawString$default($this$render_u24lambda_u240, (class_2561)altType, x - xOffset, y + 2, color, false, 16, null);
        GuiGraphicsExtensionsKt.renderOutline($this$render_u24lambda_u240, x, y, GuiGraphicsExtensionsKt.textWidth(altString) + 5, 11, color);
        GuiGraphicsExtensionsKt.drawString$default($this$render_u24lambda_u240, altString, x + 3, y + 2, color, false, 16, null);
    }

    @Override
    public void renderFaulted(@NotNull class_332 guiGraphics) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        class_332 $this$renderFaulted_u24lambda_u241 = guiGraphics;
        boolean bl = false;
        class_5250 class_52502 = class_2561.method_43471((String)"short.flightassistant.radar_altitude");
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"translatable(...)");
        GuiGraphicsExtensionsKt.drawString$default($this$renderFaulted_u24lambda_u241, (class_2561)class_52502, HudFrame.INSTANCE.getRight(), HudFrame.INSTANCE.getBottom() + 4, GuiGraphicsExtensionsKt.getWarningColor(), false, 16, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lru/octol1ttle/flightassistant/impl/display/RadarAltitudeDisplay$Companion;", "", "<init>", "()V", "Lnet/minecraft/class_2960;", "ID", "Lnet/minecraft/class_2960;", "getID", "()Lnet/minecraft/class_2960;", "flightassistant-fabric"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final class_2960 getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VoidProximityComputer.Status.values().length];
            try {
                nArray[VoidProximityComputer.Status.REACHED_DAMAGE_ALTITUDE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VoidProximityComputer.Status.APPROACHING_DAMAGE_ALTITUDE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

