/*
 * Decompiled with CFR 0.152.
 */
package com.aurora.command;

import com.aurora.AuroraMod;
import com.aurora.features.Feature;
import com.aurora.features.FeatureManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;

public class AuroraCommands {
    public static void register() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> AuroraCommands.registerCommands((CommandDispatcher<FabricClientCommandSource>)dispatcher));
    }

    private static void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"aurora").then(ClientCommandManager.literal((String)"toggle").then(ClientCommandManager.argument((String)"feature", (ArgumentType)StringArgumentType.string()).executes(AuroraCommands::toggleFeature)))).then(ClientCommandManager.literal((String)"enable").then(ClientCommandManager.argument((String)"feature", (ArgumentType)StringArgumentType.string()).executes(AuroraCommands::enableFeature)))).then(ClientCommandManager.literal((String)"disable").then(ClientCommandManager.argument((String)"feature", (ArgumentType)StringArgumentType.string()).executes(AuroraCommands::disableFeature)))).then(ClientCommandManager.literal((String)"list").executes(AuroraCommands::listFeatures))).then(ClientCommandManager.literal((String)"status").executes(AuroraCommands::showStatus))).executes(AuroraCommands::showHelp));
    }

    private static int toggleFeature(CommandContext<FabricClientCommandSource> context) {
        String featureName = StringArgumentType.getString(context, (String)"feature");
        FeatureManager manager = AuroraMod.getInstance().getFeatureManager();
        manager.toggleFeature(featureName);
        return 1;
    }

    private static int enableFeature(CommandContext<FabricClientCommandSource> context) {
        String featureName = StringArgumentType.getString(context, (String)"feature");
        FeatureManager manager = AuroraMod.getInstance().getFeatureManager();
        manager.enableFeature(featureName);
        return 1;
    }

    private static int disableFeature(CommandContext<FabricClientCommandSource> context) {
        String featureName = StringArgumentType.getString(context, (String)"feature");
        FeatureManager manager = AuroraMod.getInstance().getFeatureManager();
        manager.disableFeature(featureName);
        return 1;
    }

    private static int listFeatures(CommandContext<FabricClientCommandSource> context) {
        FeatureManager manager = AuroraMod.getInstance().getFeatureManager();
        FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
        source.sendFeedback((class_2561)class_2561.method_43470((String)"\u00a76[Aurora] Available Features:"));
        for (Feature feature : manager.getAllFeatures().values()) {
            String status = feature.isEnabled() ? "\u00a7aEnabled" : "\u00a7cDisabled";
            source.sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7f- " + feature.getName() + " " + status + " \u00a77- " + feature.getDescription())));
        }
        return 1;
    }

    private static int showStatus(CommandContext<FabricClientCommandSource> context) {
        FeatureManager manager = AuroraMod.getInstance().getFeatureManager();
        FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
        source.sendFeedback((class_2561)class_2561.method_43470((String)"\u00a76[Aurora] Current Status:"));
        int enabledCount = 0;
        for (Feature feature : manager.getAllFeatures().values()) {
            if (!feature.isEnabled()) continue;
            ++enabledCount;
            source.sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7a\u2713 " + feature.getName())));
        }
        source.sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7f" + enabledCount + " features enabled")));
        return 1;
    }

    private static int showHelp(CommandContext<FabricClientCommandSource> context) {
        FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
        source.sendFeedback((class_2561)class_2561.method_43470((String)"\u00a76[Aurora] Builder Mode Commands:"));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7f/aurora list \u00a77- Show all features"));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7f/aurora status \u00a77- Show enabled features"));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7f/aurora toggle <feature> \u00a77- Toggle a feature"));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7f/aurora enable <feature> \u00a77- Enable a feature"));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7f/aurora disable <feature> \u00a77- Disable a feature"));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"\u00a77Features: noclip, fastplace, fastbreak, forceplace, replace, tinker, freezeupdates"));
        return 1;
    }
}

