/*
 * Decompiled with CFR 0.152.
 */
package com.aurora.features;

import com.aurora.features.Feature;

public abstract class AbstractFeature
implements Feature {
    protected final String name;
    protected final String description;
    protected boolean enabled = false;

    protected AbstractFeature(String name, String description) {
        this.name = name;
        this.description = description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean wasEnabled = this.enabled;
        this.enabled = enabled;
        if (!wasEnabled && enabled) {
            this.onEnable();
        } else if (wasEnabled && !enabled) {
            this.onDisable();
        }
    }

    @Override
    public void toggle() {
        this.setEnabled(!this.enabled);
    }

    @Override
    public void tick() {
        if (this.enabled) {
            this.onTick();
        }
    }

    protected void onTick() {
    }
}

