/*
 * Decompiled with CFR 0.152.
 */
package com.aurora.features;

import com.aurora.AuroraMod;
import com.aurora.features.FastBreakFeature;
import com.aurora.features.FastPlaceFeature;
import com.aurora.features.Feature;
import com.aurora.features.ForcePlaceFeature;
import com.aurora.features.FreezeUpdatesFeature;
import com.aurora.features.NoClipFeature;
import com.aurora.features.ReplaceFeature;
import com.aurora.features.TinkerFeature;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class FeatureManager {
    private final Map<String, Feature> features = new HashMap<String, Feature>();
    private final class_310 client = class_310.method_1551();

    public FeatureManager() {
        this.registerFeatures();
    }

    private void registerFeatures() {
        this.registerFeature(new NoClipFeature());
        this.registerFeature(new FastPlaceFeature());
        this.registerFeature(new FastBreakFeature());
        this.registerFeature(new ForcePlaceFeature());
        this.registerFeature(new ReplaceFeature());
        this.registerFeature(new TinkerFeature());
        this.registerFeature(new FreezeUpdatesFeature());
    }

    private void registerFeature(Feature feature) {
        this.features.put(feature.getName().toLowerCase(), feature);
        AuroraMod.LOGGER.info("Registered feature: {}", (Object)feature.getName());
    }

    public void tick() {
        this.features.values().forEach(Feature::tick);
    }

    public Feature getFeature(String name) {
        return this.features.get(name.toLowerCase());
    }

    public <T extends Feature> T getFeature(Class<T> featureClass) {
        return (T)((Feature)this.features.values().stream().filter(feature -> featureClass.isInstance(feature)).findFirst().orElse(null));
    }

    public Map<String, Feature> getAllFeatures() {
        return new HashMap<String, Feature>(this.features);
    }

    public void toggleFeature(String name) {
        Feature feature = this.getFeature(name);
        if (feature != null) {
            feature.toggle();
            if (this.client.field_1724 != null) {
                this.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a76[Aurora] \u00a7f" + feature.getName() + " is now " + (feature.isEnabled() ? "\u00a7aEnabled" : "\u00a7cDisabled"))), false);
            }
        }
    }

    public void enableFeature(String name) {
        Feature feature = this.getFeature(name);
        if (feature != null) {
            feature.setEnabled(true);
            if (this.client.field_1724 != null) {
                this.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a76[Aurora] \u00a7a" + feature.getName() + " enabled")), false);
            }
        }
    }

    public void disableFeature(String name) {
        Feature feature = this.getFeature(name);
        if (feature != null) {
            feature.setEnabled(false);
            if (this.client.field_1724 != null) {
                this.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a76[Aurora] \u00a7c" + feature.getName() + " disabled")), false);
            }
        }
    }
}

