/*
 * Decompiled with CFR 0.152.
 */
package com.aurora.gui;

import com.aurora.AuroraMod;
import com.aurora.features.Feature;
import com.aurora.features.FeatureManager;
import java.util.ArrayList;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class AuroraGui {
    private final class_310 client = class_310.method_1551();
    private boolean menuVisible = false;

    public AuroraGui() {
        this.registerHudRenderer();
    }

    private void registerHudRenderer() {
        HudRenderCallback.EVENT.register((context, tickCounter) -> this.renderHud(context, 1.0f));
    }

    private void renderHud(class_332 context, float tickDelta) {
        try {
            if (context == null || this.client == null) {
                return;
            }
            this.renderActiveFeatures(context);
            if (this.menuVisible) {
                this.renderMenu(context);
            }
        }
        catch (Exception e) {
            System.err.println("Error rendering Aurora HUD: " + e.getMessage());
        }
    }

    private void renderActiveFeatures(class_332 context) {
        try {
            FeatureManager manager = AuroraMod.getInstance().getFeatureManager();
            if (manager == null) {
                return;
            }
            ArrayList<Feature> activeFeatures = new ArrayList<Feature>();
            for (Feature feature : manager.getAllFeatures().values()) {
                if (feature == null || !feature.isEnabled()) continue;
                activeFeatures.add(feature);
            }
            if (activeFeatures.isEmpty()) {
                return;
            }
            int y = 10;
            for (Feature feature : activeFeatures) {
                if (feature == null || feature.getName() == null) continue;
                context.method_51439(this.client.field_1772, (class_2561)class_2561.method_43470((String)("\u00a7a[" + feature.getName() + "]")), 10, y, 65280, true);
                y += 12;
            }
        }
        catch (Exception e) {
            System.err.println("Error rendering active features: " + e.getMessage());
        }
    }

    private void renderMenu(class_332 context) {
        int centerX = context.method_51421() / 2;
        int centerY = context.method_51443() / 2;
        context.method_25294(centerX - 150, centerY - 100, centerX + 150, centerY + 100, Integer.MIN_VALUE);
        context.method_27534(this.client.field_1772, (class_2561)class_2561.method_43470((String)"\u00a76Aurora Builder Mode"), centerX, centerY - 80, 0xFFFFFF);
        FeatureManager manager = AuroraMod.getInstance().getFeatureManager();
        int y = centerY - 50;
        int index = 1;
        for (Feature feature : manager.getAllFeatures().values()) {
            String status = feature.isEnabled() ? "\u00a7aON" : "\u00a7cOFF";
            context.method_27534(this.client.field_1772, (class_2561)class_2561.method_43470((String)("\u00a7f[" + index + "] " + feature.getName() + " " + status)), centerX, y, 0xFFFFFF);
            y += 15;
            ++index;
        }
        context.method_27534(this.client.field_1772, (class_2561)class_2561.method_43470((String)"\u00a77Use /aurora commands to control features"), centerX, centerY + 70, 0xAAAAAA);
    }

    public void toggleMenu() {
        try {
            this.menuVisible = !this.menuVisible;
            System.out.println("Aurora menu toggled: " + (this.menuVisible ? "ON" : "OFF"));
        }
        catch (Exception e) {
            System.err.println("Error toggling Aurora menu: " + e.getMessage());
            e.printStackTrace();
            this.menuVisible = false;
        }
    }

    public boolean isMenuVisible() {
        return this.menuVisible;
    }
}

