/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.dragonitegear.entity.custom;

import net.micaxs.dragonitegear.entity.ModEntities;
import net.micaxs.dragonitegear.item.ModItems;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class DragontiteProjectileEntity
extends ThrowableItemProjectile {
    public DragontiteProjectileEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public DragontiteProjectileEntity(Level level, LivingEntity livingEntity) {
        super(ModEntities.DRAGONITE_PROJECTILE.get(), livingEntity, level);
    }

    @NotNull
    protected Item getDefaultItem() {
        return (Item)ModItems.DRAGONITE_PROJECTILE.get();
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 4.0f);
        if (entity.getType() == this.getType()) {
            return;
        }
        if (!this.level().isClientSide) {
            this.level().explode((Entity)this, entity.getX(), entity.getY(), entity.getZ(), 4.0f, Level.ExplosionInteraction.NONE);
            this.discard();
        }
    }

    protected boolean canHitEntity(Entity target) {
        return true;
    }

    protected void onHitBlock(BlockHitResult result) {
        if (!this.level().isClientSide) {
            this.level().explode((Entity)this, (double)this.blockPosition().getX(), (double)this.blockPosition().getY(), (double)this.blockPosition().getZ(), 4.0f, Level.ExplosionInteraction.NONE);
            this.discard();
        }
        super.onHitBlock(result);
    }
}

