/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.dragonitegear.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.micaxs.dragonitegear.recipe.DragoniteForgeRecipeInput;
import net.micaxs.dragonitegear.recipe.ModRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record DragoniteForgeRecipe(List<Ingredient> inputs, ItemStack output) implements Recipe<DragoniteForgeRecipeInput>
{
    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.addAll(this.inputs);
        return list;
    }

    public boolean matches(DragoniteForgeRecipeInput dragoniteForgeRecipeInput, Level level) {
        if (level.isClientSide()) {
            return false;
        }
        if (dragoniteForgeRecipeInput.size() < 2) {
            return false;
        }
        boolean matchesFirst = this.inputs.get(0).test(dragoniteForgeRecipeInput.getItem(0));
        boolean matchesSecond = this.inputs.get(1).test(dragoniteForgeRecipeInput.getItem(1));
        return matchesFirst && matchesSecond;
    }

    public ItemStack assemble(DragoniteForgeRecipeInput dragoniteForgeRecipeInput, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.DRAGONITE_FORGING_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.DRAGONITE_FORGING_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<DragoniteForgeRecipe> {
        public static final MapCodec<DragoniteForgeRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").forGetter(DragoniteForgeRecipe::inputs), (App)ItemStack.CODEC.fieldOf("result").forGetter(DragoniteForgeRecipe::output)).apply((Applicative)inst, DragoniteForgeRecipe::new));

        public MapCodec<DragoniteForgeRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, DragoniteForgeRecipe> streamCodec() {
            return StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), DragoniteForgeRecipe::inputs, (StreamCodec)ItemStack.STREAM_CODEC, DragoniteForgeRecipe::output, DragoniteForgeRecipe::new);
        }
    }
}

