/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.client.screen.ex.widget.color;

import com.mr_toad.lib.core.ToadLib;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntConsumer;
import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5244;
import net.minecraft.class_5253;
import net.minecraft.class_6382;

public class ColorCellsWidget
extends class_339 {
    private final IntList colorsList = new IntArrayList();
    private int titleY = this.method_46427() - 15;
    private int selectedColor;
    private final IntList colors;
    private final IntConsumer change;
    private final int cellsPerRow;
    private final int cellSize;

    public static Builder of(IntList colors, IntConsumer change) {
        return new Builder(colors, change);
    }

    public ColorCellsWidget(int x, int y, int w, int h, int cellSize, int defaultValue, class_2561 hoverMsg, IntList colors, IntConsumer change) {
        super(x, y, w, h, hoverMsg);
        this.colors = colors;
        this.change = change;
        this.cellSize = cellSize;
        int nextX = this.method_46426();
        int i = 0;
        if (!colors.isEmpty()) {
            int nextY = y;
            boolean flag = true;
            for (int j = 0; j < colors.size(); ++j) {
                int color = colors.getInt(j);
                if (!this.colorsList.add(color)) {
                    ToadLib.LOGGER.error("Found duplicate entry: '{}'. Removing...", (Object)color);
                    colors.removeInt(colors.indexOf(color));
                }
                if (flag) {
                    ++i;
                }
                if ((nextX += cellSize + 5) <= w) continue;
                nextX = x;
                flag = false;
                if ((nextY += cellSize + 5) <= this.method_25364()) continue;
                ToadLib.LOGGER.warn("Color cells list(Cell size: '{}', Cells: '{}') overflow! Re-size...", (Object)cellSize, (Object)this.size());
                this.field_22759 = h + nextY * 2;
            }
        }
        this.cellsPerRow = i;
        this.selectedColor = defaultValue;
    }

    protected void method_48579(class_332 graphics, int mx, int my, float pt) {
        int nextX = this.method_46426();
        int nextY = this.method_46427();
        for (int i = 0; i < this.colorsList.size(); ++i) {
            int color = this.colorsList.getInt(i);
            int borderColor = this.isSelected(color) ? class_5253.class_5254.method_27764((int)255, (int)167, (int)160, (int)168) : class_5253.class_5254.method_27764((int)255, (int)128, (int)120, (int)120);
            graphics.method_25294(nextX, nextY, nextX + this.cellSize, nextY + this.cellSize, borderColor);
            graphics.method_25294(nextX + 2, nextY + 2, nextX + this.cellSize - 2, nextY + this.cellSize - 2, color);
            if ((nextX += this.cellSize + 5) <= this.method_25368()) continue;
            nextX = this.method_46426();
            nextY += this.cellSize + 5;
        }
        if (this.method_25369() != class_5244.field_39003) {
            graphics.method_27534(class_310.method_1551().field_1772, this.method_25369(), this.method_46426() * (this.getCellsPerRow() / 2), this.titleY, 0xE0E0E0);
        }
    }

    public boolean method_25402(double mx, double my, int button) {
        if (this.colors.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.colorsList.size(); ++i) {
            int color = this.colorsList.getInt(i);
            int nextX = this.method_46426() + i % this.cellsPerRow * (this.cellSize + 5);
            int nextY = this.method_46427() + i / this.cellsPerRow * (this.cellSize + 5);
            if (!(mx >= (double)nextX) || !(my >= (double)nextY) || !(mx < (double)(nextX + this.cellSize)) || !(my < (double)(nextY + this.cellSize))) continue;
            this.onChange(color);
            return true;
        }
        return false;
    }

    public void method_46421(int x) {
        super.method_46421(x);
    }

    public void method_46419(int y) {
        super.method_46419(y);
    }

    protected void method_47399(class_6382 builder) {
    }

    public void onChange(int color) {
        this.change.accept(color);
        this.setSelected(color);
    }

    public void setSelected(int color) {
        this.selectedColor = color;
    }

    public void mapTitleY(Int2IntFunction mapper) {
        this.titleY = (Integer)mapper.apply((Object)this.method_46427());
    }

    public boolean isSelected(int color) {
        return this.selectedColor == color;
    }

    public int getValue() {
        return this.selectedColor;
    }

    public int getCellsPerRow() {
        return this.cellsPerRow;
    }

    public int size() {
        return this.colorsList.size();
    }

    public static class Builder {
        private int defaultValue;
        private class_2561 title = class_5244.field_39003;
        private int x = 5;
        private int y = 5;
        private int w = 5;
        private int h = 5;
        private int cellSize = 15;
        private final IntList colors;
        private final IntConsumer change;

        public Builder(IntList colors, IntConsumer change) {
            this.colors = colors;
            this.change = change;
            this.defaultValue = colors.getInt(0);
        }

        public Builder size(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            return this;
        }

        public Builder addTitle(class_2561 title) {
            this.title = title;
            return this;
        }

        public Builder setCellSize(int cellSize) {
            this.cellSize = cellSize;
            return this;
        }

        public Builder setDefaultValue(int defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public ColorCellsWidget build() {
            return new ColorCellsWidget(this.x, this.y, this.w, this.h, this.cellSize, this.defaultValue, this.title, this.colors, this.change);
        }
    }
}

