/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.client.screen.interpolation;

import com.google.common.collect.ImmutableList;
import com.mr_toad.lib.api.client.init.EaseWidgetSettingsRegistry;
import com.mr_toad.lib.api.client.screen.ex.ParentableToadLibScreen;
import com.mr_toad.lib.api.client.screen.ex.widget.ExSlider;
import com.mr_toad.lib.api.client.screen.ex.widget.SpriteButton;
import com.mr_toad.lib.api.client.screen.interpolation.widget.InterpolationTypeWidget;
import com.mr_toad.lib.api.client.utils.ToadClientUtils;
import com.mr_toad.lib.mtjava.MtJava;
import com.mr_toad.lib.mtjava.collections.UniqueList;
import com.mr_toad.lib.mtjava.ints.IntPair;
import com.mr_toad.lib.mtjava.math.interpolation.HermiteInterpolation;
import com.mr_toad.lib.mtjava.math.interpolation.Interpolation;
import com.mr_toad.lib.mtjava.math.interpolation.Interpolations;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5676;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

public abstract class InterpolationSelectionScreen<P extends class_437>
extends ParentableToadLibScreen<P> {
    public static final ImmutableList<Interpolation> ALL_REGISTERED_INTERPOLATIONS = ImmutableList.copyOf(Interpolations.INTERPOLATIONS.sortByID().iterator());
    private static final class_2561 INTERPS = class_2561.method_43471((String)"toadlib.screen.interp.interpolations");
    private static final class_2561 FROM_INFO = class_2561.method_43471((String)"toadlib.screen.interp.info").method_27692(class_124.field_1073).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11749, "https://easings.net")));
    private static final class_2561 COMMON_INFO = class_2561.method_43471((String)"toadlib.screen.interp.info1");
    private static final class_2561 ADDITIONAL_INFO = class_2561.method_43471((String)"toadlib.screen.interp.info2");
    protected final List<Interpolation> interpolations = new UniqueList<Interpolation>();
    protected final List<InterpolationTypeWidget> widgets = new UniqueList<InterpolationTypeWidget>();
    private float a = 1.0f;
    private float b = 1.0f;
    private float c = 1.0f;
    private float d = 1.0f;
    private float bias = 0.0f;
    private HermiteInterpolation.Tension tension = HermiteInterpolation.Tension.DEFAULT;
    protected ExSlider aSlider;
    protected ExSlider bSlider;
    protected ExSlider cSlider;
    protected ExSlider dSlider;
    protected ExSlider biasSlider;
    protected class_5676<HermiteInterpolation.Tension> tensionCycle;
    protected SpriteButton info;
    protected Interpolation selected;

    public InterpolationSelectionScreen(List<Interpolation> interpolations, @Nullable P parent) {
        super(INTERPS, true, parent, IntPair.of(10, 10));
        this.interpolations.addAll(interpolations);
        this.selected = interpolations.get(0);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.aSlider = (ExSlider)this.method_37063((class_364)this.createSlider("A", this.a, 0, s -> {
            this.a = (float)s.getValue();
        }));
        this.bSlider = (ExSlider)this.method_37063((class_364)this.createSlider("B", this.b, 20, s -> {
            this.b = (float)s.getValue();
        }));
        this.cSlider = (ExSlider)this.method_37063((class_364)this.createSlider("C", this.c, 40, s -> {
            this.c = (float)s.getValue();
        }));
        this.dSlider = (ExSlider)this.method_37063((class_364)this.createSlider("D", this.d, 60, s -> {
            this.d = (float)s.getValue();
        }));
        this.biasSlider = (ExSlider)this.method_37063((class_364)new ExSlider(this.field_22789 / 2 + 60, this.field_22790 / 2 + 25, 140, 20, (class_2561)class_2561.method_43471((String)"toadlib.screen.hermite.bias"), class_5244.field_39003, -1.0, 1.0, this.bias, 0.1, true, b -> {
            double v = b.getValue();
            if ((double)this.bias != v) {
                this.bias = (float)v;
            }
        }));
        this.tensionCycle = (class_5676)this.method_37063((class_364)class_5676.method_32606(HermiteInterpolation.Tension::symbol).method_32619((Object)this.tension).method_32624((Object[])HermiteInterpolation.Tension.values()).method_32617(this.field_22789 / 2 + 60, this.field_22790 / 2 + 45, 75, 20, (class_2561)class_2561.method_43471((String)"toadlib.screen.hermite.tension"), (b, v) -> {
            if (this.tension != v) {
                this.tension = v;
            }
        }));
        this.info = (SpriteButton)this.method_37063((class_364)ToadClientUtils.createInfoButton(35, 10, b -> {}));
        this.info.method_47400(class_7919.method_47407((class_2561)class_5244.method_37110((class_2561[])new class_2561[]{COMMON_INFO, ADDITIONAL_INFO})));
        Interpolation interpolation = this.selected;
        if (interpolation instanceof HermiteInterpolation) {
            HermiteInterpolation hermiteInterpolation = (HermiteInterpolation)interpolation;
            hermiteInterpolation.setBias(this.bias);
            hermiteInterpolation.setTension(this.tension);
        }
        this.fillWidgets();
        this.updateWidgetAccess();
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        graphics.method_27534(this.field_22793, FROM_INFO, this.field_22789 / 2 + 60, this.field_22790 - 10, MtJava.rgb2Argb(0x404040));
    }

    @Override
    protected boolean clickAtText(double mx, double my, int button) {
        return ToadClientUtils.getCentredStyleOf(this.field_22793, FROM_INFO, mx, my, this.field_22789 / 2 + 80, this.field_22790 - 15).map(arg_0 -> ((InterpolationSelectionScreen)this).method_25430(arg_0)).orElse(false);
    }

    protected void fillWidgets() {
        if (this.interpolations.isEmpty()) {
            return;
        }
        int x = 10;
        int y = 35;
        for (Interpolation value : this.interpolations) {
            if (y > 230) {
                y = 35;
                x += 20;
            }
            InterpolationTypeWidget widget = new InterpolationTypeWidget(x, y, this.selected == value, b -> {
                this.widgets.stream().filter(w -> !w.isSame(value)).forEach(w -> {
                    w.selected = false;
                });
                this.selected = value;
                this.onSelect(value);
                this.updateWidgetAccess();
            }, value);
            this.widgets.add(widget);
            this.method_37063((class_364)widget);
            y += 20;
        }
    }

    protected void updateWidgetAccess() {
        this.aSlider.field_22763 = false;
        this.bSlider.field_22763 = false;
        this.cSlider.field_22763 = false;
        this.dSlider.field_22763 = false;
        this.biasSlider.field_22764 = false;
        this.tensionCycle.field_22764 = false;
        if (this.selected != null) {
            EaseWidgetSettingsRegistry.resolve(this.aSlider, this.bSlider, this.cSlider, this.dSlider, this.selected);
            if (this.selected instanceof HermiteInterpolation) {
                this.biasSlider.field_22764 = true;
                this.tensionCycle.field_22764 = true;
            }
        }
    }

    public abstract void onSelect(Interpolation var1);

    protected ExSlider createSlider(String s, double target, int yOffset, ExSlider.OnValueChange onApply) {
        return new ExSlider(this.field_22789 / 2 + 75, this.field_22790 / 2 - 60 + yOffset, 140, 20, (class_2561)class_2561.method_43470((String)(s + ":")), class_5244.field_39003, 0.0, 10.0, target, 0.1, true, onApply);
    }
}

