/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.config.entry;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mr_toad.lib.api.config.entry.type.ConfigEntryType;
import com.mr_toad.lib.api.config.util.DeprecationRule;
import com.mr_toad.lib.api.config.util.HighlightWarning;
import com.mr_toad.lib.api.config.util.PerformanceImpact;
import com.mr_toad.lib.core.ToadLib;
import com.mr_toad.lib.core.ToadLibClient;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class ConfigEntry<T, E extends ConfigEntry<T, E>> {
    private final ObjectList<Callback<ConfigEntry<T, E>, T>> changeCallbacks = new ObjectArrayList();
    private final ObjectList<Callback<ConfigEntry<T, E>, T>> resetCallbacks = new ObjectArrayList();
    private final ObjectList<DeprecationRule> deprecations = new ObjectArrayList();
    protected class_2561 title = class_2561.method_43473();
    protected class_2561 description = class_2561.method_43473();
    @Nullable
    private HighlightWarning highlightWarning = null;
    @Nullable
    private PerformanceImpact performanceImpact = null;
    private boolean drawInScreen = true;
    private boolean resourceReload = false;
    public T value;
    protected final T defaultValue;
    protected final String name;
    private final ConfigEntryType type;
    private final Codec<T> codec;

    public ConfigEntry(String name, T defaultValue, Codec<T> codec, ConfigEntryType type) {
        this.defaultValue = defaultValue;
        this.name = name;
        this.type = type;
        this.codec = codec;
        this.value = this.defaultValue;
    }

    public E dontDrawInScreen() {
        this.drawInScreen = false;
        return (E)this;
    }

    public E reloadResource() {
        this.resourceReload = true;
        return (E)this;
    }

    public E addTitle(class_2561 component) {
        this.title = component;
        return (E)this;
    }

    public E addDescription(class_2561 component) {
        this.description = component;
        return (E)this;
    }

    public E withWarning(HighlightWarning warning) {
        this.highlightWarning = warning;
        return (E)this;
    }

    public E withPerformanceImpact(PerformanceImpact impact) {
        this.performanceImpact = impact;
        return (E)this;
    }

    public E addDeprecationRule(DeprecationRule rule) {
        this.deprecations.add((Object)rule);
        return (E)this;
    }

    public E addDeprecationRule(DeprecationRule ... rules) {
        Collections.addAll(this.deprecations, rules);
        return (E)this;
    }

    public void save(JsonObject object) {
        DataResult result = this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, this.get());
        result.error().ifPresent(r -> ToadLib.LOGGER.error(ToadLib.CONFIG, "Failed to save '{}':{}", (Object)this.name, (Object)r.message()));
        result.result().ifPresent(r -> {
            object.add(this.name, r);
            if (ToadLibClient.printDebug()) {
                ToadLib.LOGGER.debug(ToadLib.CONFIG, "Saved '{}', '{}'", (Object)this, this.get());
            }
        });
    }

    public void load(JsonElement element) {
        DataResult result = this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
        result.error().ifPresent(r -> ToadLib.LOGGER.error(ToadLib.CONFIG, "Error parsing '{}':{}", (Object)this.name, (Object)r.message()));
        result.result().ifPresent(v -> {
            this.value = v;
        });
    }

    public T get() {
        return this.value;
    }

    public void setValue(T value) {
        for (Callback callback : this.changeCallbacks) {
            callback.call(this, this.value, value);
        }
        this.value = value;
    }

    public void resetValue() {
        for (Callback callback : this.resetCallbacks) {
            callback.call(this, this.value, this.defaultValue);
        }
        this.setValue(this.defaultValue);
    }

    public ConfigEntryType getType() {
        return this.type;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public boolean drawInScreen() {
        return this.drawInScreen;
    }

    public boolean isDefault() {
        return this.get().equals(this.getDefaultValue());
    }

    public boolean isDeprecated() {
        return !this.deprecations.isEmpty() && this.deprecations.stream().anyMatch(DeprecationRule::isActive);
    }

    public class_2561 getTitle() {
        if (Objects.equals(this.title, class_2561.method_43473())) {
            return class_2561.method_43470((String)this.name);
        }
        return this.title;
    }

    public class_2561 getDescription() {
        Optional<class_2561> text = this.deprecations.stream().filter(DeprecationRule::isActive).map(DeprecationRule::getTooltip).filter(t -> t != class_5244.field_39003).findFirst();
        if (text.isPresent()) {
            return text.get();
        }
        class_5250 c = this.description.method_27661();
        if (this.getPerformanceImpact() == null && this.getHighlightWarning() == null && !this.resourceReload) {
            return c;
        }
        c = class_5244.method_37110((class_2561[])new class_2561[]{c, class_5244.field_33849});
        if (this.getHighlightWarning() != null) {
            c = class_5244.method_37110((class_2561[])new class_2561[]{c, this.getHighlightWarning().getTooltip()});
        }
        if (this.getPerformanceImpact() != null) {
            c = class_5244.method_37110((class_2561[])new class_2561[]{c, this.getPerformanceImpact().getTooltip()});
        }
        if (this.resourceReload) {
            c = class_5244.method_37110((class_2561[])new class_2561[]{c, class_2561.method_43471((String)"toadconfig.auto_resource_reload")});
        }
        return c;
    }

    public boolean mustReloadResource() {
        return this.resourceReload;
    }

    @Nullable
    public HighlightWarning getHighlightWarning() {
        return this.highlightWarning;
    }

    @Nullable
    public PerformanceImpact getPerformanceImpact() {
        return this.performanceImpact;
    }

    public boolean equals(Object obj) {
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ConfigEntry other = (ConfigEntry)obj;
        return Objects.equals(this.name, other.name);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.name;
    }

    @FunctionalInterface
    public static interface Callback<E, T> {
        public void call(E var1, T var2, T var3);
    }
}

