/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.config.entry;

import com.mojang.serialization.Codec;
import com.mr_toad.lib.api.config.entry.ConfigEntry;
import com.mr_toad.lib.api.config.entry.type.ConfigEntryTypes;
import com.mr_toad.lib.api.config.error.ConfigException;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_3542;
import org.apache.commons.lang3.ArrayUtils;

@Environment(value=EnvType.CLIENT)
public class EnumEntry<C extends Enum<C>>
extends ConfigEntry<C, EnumEntry<C>> {
    private final C[] values;
    private final Function<C, class_2561> naming;
    private int current;

    public EnumEntry(String name, C defaultValue, C[] values, Codec<C> codec, Function<C, class_2561> naming) {
        super(name, defaultValue, codec, ConfigEntryTypes.ENUM);
        this.values = values;
        this.naming = naming;
        if (!(defaultValue instanceof class_3542)) {
            throw new ConfigException("'" + name + "' is not enum or not implements 'StringRepresentable' interface!");
        }
        if (values.length <= 1) {
            throw new ConfigException("Length of '" + name + "' must be greater than 1!");
        }
        this.current = ArrayUtils.indexOf((Object[])this.values, defaultValue);
    }

    @Override
    public C get() {
        return this.values[this.current];
    }

    @Override
    public void setValue(C value) {
        this.current = ArrayUtils.indexOf((Object[])this.values, value);
    }

    public C[] getValues() {
        return this.values;
    }

    public Function<C, class_2561> getNaming() {
        return this.naming;
    }
}

