/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.helper.registry;

import com.mr_toad.lib.api.helper.registry.common.RegistryMemberException;
import com.mr_toad.lib.api.helper.registry.common.ToadRegistry;
import com.mr_toad.lib.api.helper.registry.common.ValueHolder;
import com.mr_toad.lib.core.ToadLib;
import com.mr_toad.lib.mtjava.strings.OptionalString;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class NameableRegistry<O>
implements ToadRegistry<String, O, Object2ObjectMap<String, ValueHolder<O>>> {
    private final Object2ObjectMap<String, ValueHolder<O>> registry = new Object2ObjectOpenHashMap();
    private String defaultValue = "";
    private final String regName;

    public NameableRegistry(String regName) {
        Validate.notEmpty((CharSequence)regName, (String)"RegName cannot be empty!", (Object[])new Object[0]);
        this.regName = regName;
    }

    @Override
    public Object2ObjectMap<String, ValueHolder<O>> registry() {
        return this.registry;
    }

    @Override
    public void destroyRegistry() {
        ToadRegistry.super.destroyRegistry();
        this.defaultValue = "";
    }

    public NameableRegistry<O> declareDefault(String name) {
        Validate.notEmpty((CharSequence)name, (String)("Default of '" + this.regName + "' cannot be empty!"), (Object[])new Object[0]);
        this.defaultValue = name;
        return this;
    }

    public ValueHolder<O> register(String name, O obj) {
        Validate.notEmpty((CharSequence)name, (String)("Name of '" + String.valueOf(obj) + "' cannot be empty!"), (Object[])new Object[0]);
        ValueHolder<O> holder = new ValueHolder<O>(obj);
        if (this.registry.containsKey((Object)name)) {
            throw new RegistryMemberException("'" + this.regName + "' already have object with name: '" + name + "'");
        }
        this.registry.put((Object)name, holder);
        return holder;
    }

    public ValueHolder<O> getOrDefault(String name) {
        Validate.notEmpty((CharSequence)name, (String)"Name cannot be empty!", (Object[])new Object[0]);
        ValueHolder holder = (ValueHolder)this.registry.get((Object)name);
        if (holder == null) {
            if (this.getDefault().isPresent()) {
                ToadLib.LOGGER.error("Member with name: '{}' not found in '{}'! Received as default.", (Object)name, (Object)this.regName);
                return this.getDefault().get();
            }
            throw new RegistryMemberException("Default target not declared!");
        }
        return holder;
    }

    public ValueHolder<O> getOrThrow(String name) {
        Validate.notEmpty((CharSequence)name, (String)"Name cannot be empty!", (Object[])new Object[0]);
        if (!this.registry.containsKey((Object)name)) {
            throw new RegistryMemberException("Member of '" + this.regName + "' with name:" + name + "doesn't exists!");
        }
        return (ValueHolder)this.registry.get((Object)name);
    }

    public String getName(O obj) {
        if (!this.values().contains(obj)) {
            throw new RegistryMemberException("Name of '" + String.valueOf(obj) + "' in '" + this.regName + "' not found!");
        }
        return (String)this.inverseValues().get(obj);
    }

    public String getName(ValueHolder<O> obj) {
        if (!this.registry.containsValue(obj)) {
            throw new RegistryMemberException("Name of '" + String.valueOf(obj) + "' in '" + this.regName + "' not found!");
        }
        return (String)this.inverse().get(obj);
    }

    public ObjectSet<String> keys() {
        return this.registry.keySet();
    }

    public boolean replace(String name, O newValue) {
        return this.replace(name, new ValueHolder<O>(newValue));
    }

    public boolean replace(String name, ValueHolder<O> newValue) {
        Validate.notEmpty((CharSequence)name, (String)("Name of '" + String.valueOf(newValue) + "' cannot be empty!"), (Object[])new Object[0]);
        return this.registry.replace((Object)name, this.getOrThrow(name), newValue);
    }

    public OptionalString getDefaultName() {
        return StringUtils.isEmpty((CharSequence)this.defaultValue) ? OptionalString.empty() : OptionalString.of(this.defaultValue);
    }

    public Optional<ValueHolder<O>> getDefault() {
        if (StringUtils.isEmpty((CharSequence)this.defaultValue)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.getOrThrow(this.defaultValue));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NameableRegistry) {
            NameableRegistry other = (NameableRegistry)obj;
            if (!this.regName.equals(other.regName)) {
                return false;
            }
            if (this.size() == other.size()) {
                return this.values().equals(other.values());
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.registry.values().stream().mapToInt(ValueHolder::hashCode).sum() * 31;
    }

    public String toString() {
        return this.regName;
    }
}

