/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.item;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1799;

public interface ToadlyArmorItem {
    public static final HashMap<class_1741, class_1293> MATERIAL_TO_EFFECT_MAP = Maps.newHashMap();

    default public void put(class_1741 material, class_1293 effectInstance) {
        Preconditions.checkNotNull((Object)material);
        Preconditions.checkNotNull((Object)effectInstance);
        MATERIAL_TO_EFFECT_MAP.put(material, effectInstance);
    }

    default public void evaluateArmorEffects(class_1657 player) {
        if (!MATERIAL_TO_EFFECT_MAP.isEmpty()) {
            for (Map.Entry<class_1741, class_1293> entry : MATERIAL_TO_EFFECT_MAP.entrySet()) {
                class_1741 mapArmorMaterial = entry.getKey();
                class_1293 mapStatusEffect = entry.getValue();
                if (!this.hasCorrectArmorOn(mapArmorMaterial, player)) continue;
                this.addStatusEffectForMaterial(player, mapArmorMaterial, mapStatusEffect);
            }
        }
    }

    default public boolean hasCorrectArmorOn(class_1741 material, class_1657 player) {
        for (class_1799 armorStack : player.method_31548().field_7548) {
            if (armorStack.method_7909() instanceof class_1738) continue;
            return false;
        }
        class_1738 boots = (class_1738)player.method_31548().method_7372(0).method_7909();
        class_1738 leggings = (class_1738)player.method_31548().method_7372(1).method_7909();
        class_1738 chestplate = (class_1738)player.method_31548().method_7372(2).method_7909();
        class_1738 helmet = (class_1738)player.method_31548().method_7372(3).method_7909();
        return helmet.method_7686().comp_349() == material && chestplate.method_7686().comp_349() == material && leggings.method_7686().comp_349() == material && boots.method_7686().comp_349() == material;
    }

    default public void addStatusEffectForMaterial(class_1657 player, class_1741 mapArmorMaterial, class_1293 mapStatusEffect) {
        boolean hasPlayerEffect = player.method_6059(mapStatusEffect.method_5579());
        if (this.hasCorrectArmorOn(mapArmorMaterial, player) && !hasPlayerEffect) {
            player.method_6092(new class_1293(mapStatusEffect.method_5579(), mapStatusEffect.method_5584(), mapStatusEffect.method_5578()));
        }
    }
}

