/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.mtjava.math.geo;

import com.google.common.collect.ImmutableList;
import com.mr_toad.lib.mtjava.math.MtMath;
import com.mr_toad.lib.mtjava.math.vec.Vec3f;
import com.mr_toad.lib.mtjava.math.vec.Vec4f;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.class_238;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;

public class OBB {
    public static final Vec3f[] AABB_AXES = new Vec3f[]{new Vec3f(0.0f, 0.0f, 1.0f), new Vec3f(0.0f, 1.0f, 0.0f), new Vec3f(1.0f, 0.0f, 0.0f)};
    private final Vec3f center;
    private final Vec3f halfSizes;
    private final Vec3f[] axes;

    public OBB(OBB obb) {
        this(obb.center, obb.halfSizes, obb.axes);
    }

    public OBB(Vec3f center, Vec3f size, Quaternionf quaternionf) {
        Vec3f[] axes = AABB_AXES;
        for (int i = 0; i < axes.length; ++i) {
            axes[i] = axes[i].mul(quaternionf);
        }
        this.center = center;
        this.halfSizes = size.scale(0.5f);
        this.axes = axes;
    }

    public OBB(Vec3f center, Vec3f size, Vec3f rot) {
        this(center, size, rot, new Matrix4f());
    }

    public OBB(Vec3f center, Vec3f size, Vec3f rot, Matrix4f pose) {
        float rx = rot.x() * 57.295776f;
        float ry = rot.y() * 57.295776f;
        float rz = rot.z() * 57.295776f;
        pose.rotateXYZ(rx, ry, rz);
        Vec3f[] axes = AABB_AXES;
        for (int i = 0; i < axes.length; ++i) {
            axes[i] = new Vec3f(new Vec4f(axes[i]).mul((Matrix4fc)pose));
        }
        this.center = center;
        this.halfSizes = new Vec3f(size).scale(0.5f);
        this.axes = axes;
    }

    public OBB(Vec3f center, Vec3f size) {
        this(center, size, AABB_AXES);
    }

    public OBB(Vec3f center, Vec3f size, Vec3f[] axes) {
        if (axes.length <= 1) {
            throw new IllegalArgumentException("Axes for OBB must have exactly 2 or greater elements.");
        }
        this.center = new Vec3f(center);
        this.halfSizes = new Vec3f(size).scale(0.5f);
        this.axes = new Vec3f[3];
        for (int i = 0; i < 3; ++i) {
            this.axes[i] = this.normalizeOrThrow(axes[i]);
        }
    }

    public OBB moveCenter(float x, float y, float z) {
        return this.moveCenter(new Vec3f(x, y, z));
    }

    public OBB moveCenter(Vec3f delta) {
        this.center.add(delta);
        return this;
    }

    public OBB deflate(float x, float y, float z) {
        return this.inflate(-x, -y, -z);
    }

    public OBB deflate(Vec3f vec) {
        return this.inflate((Vec3f)vec.inverse());
    }

    public OBB inflate(float x, float y, float z) {
        return this.inflate(new Vec3f(x, y, z));
    }

    public OBB inflate(Vec3f vec) {
        this.halfSizes.add(vec);
        if (this.halfSizes.x() < 0.0f || this.halfSizes.y() < 0.0f || this.halfSizes.z() < 0.0f) {
            throw new IllegalArgumentException("Half sizes must remain non-negative.");
        }
        return this;
    }

    public OBB scale(float scalar) {
        if (scalar < 0.0f) {
            throw new IllegalArgumentException("Scale factor must be non-negative.");
        }
        this.halfSizes.scale(scalar);
        return this;
    }

    public boolean intersects(OBB other) {
        ImmutableList.Builder testAxes = ImmutableList.builder();
        testAxes.add((Object[])this.axes);
        testAxes.add((Object[])other.axes);
        Arrays.stream(this.axes).forEach(axisA -> Arrays.stream(other.axes).forEach(axisB -> {
            Vec3f cross = axisA.cross((Vec3f)axisB);
            Vec3f norm = this.normalizeIfNotZero(cross);
            if (norm != null) {
                testAxes.add((Object)norm);
            }
        }));
        for (Vec3f axis : testAxes.build()) {
            Vec3f normAxis = this.normalizeIfNotZero(axis);
            if (normAxis == null || this.overlapOnAxis(other, normAxis)) continue;
            return false;
        }
        return true;
    }

    public boolean intersects(class_238 aabb) {
        ImmutableList.Builder testAxes = ImmutableList.builder();
        testAxes.add((Object[])AABB_AXES);
        testAxes.add((Object[])this.axes);
        Arrays.stream(AABB_AXES).forEach(axisAABB -> Arrays.stream(this.axes).forEach(axisOBB -> {
            Vec3f cross = axisAABB.cross((Vec3f)axisOBB);
            Vec3f norm = this.normalizeIfNotZero(cross);
            if (norm != null) {
                testAxes.add((Object)norm);
            }
        }));
        for (Vec3f axis : testAxes.build()) {
            Vec3f normAxis = this.normalizeIfNotZero(axis);
            if (normAxis == null || this.overlapOnAxis(aabb, normAxis)) continue;
            return false;
        }
        return true;
    }

    public boolean overlapOnAxis(OBB other, Vec3f axis) {
        float thisRadius = this.getProjectedRadius(axis);
        float otherRadius = other.getProjectedRadius(axis);
        float distance = Math.abs(this.center.dot(axis) - other.center.dot(axis));
        return distance <= thisRadius + otherRadius;
    }

    public boolean overlapOnAxis(class_238 aabb, Vec3f axis) {
        float aabbRadius = this.getProjectedRadius(aabb, axis);
        float obbRadius = this.getProjectedRadius(axis);
        Vec3f aabbCenter = new Vec3f((float)aabb.method_1005().method_10216(), (float)aabb.method_1005().method_10214(), (float)aabb.method_1005().method_10215());
        float distance = class_3532.method_15379((float)(this.center.dot(axis) - aabbCenter.dot(axis)));
        return distance <= aabbRadius + obbRadius;
    }

    public float getProjectedRadius(class_238 aabb, Vec3f axis) {
        float maxDot = Float.NEGATIVE_INFINITY;
        float minDot = Float.POSITIVE_INFINITY;
        for (Vec3f vertex : OBB.getVertices(aabb)) {
            float dot = vertex.dot(axis);
            maxDot = Math.max(maxDot, dot);
            minDot = Math.min(minDot, dot);
        }
        return (maxDot - minDot) / 2.0f;
    }

    public float getProjectedRadius(Vec3f axis) {
        return this.halfSizes.x() * class_3532.method_15379((float)axis.dot(this.axes[0])) + this.halfSizes.y() * class_3532.method_15379((float)axis.dot(this.axes[1])) + this.halfSizes.z() * class_3532.method_15379((float)axis.dot(this.axes[2]));
    }

    public static Vec3f[] getVertices(class_238 aabb) {
        float minX = (float)aabb.field_1323;
        float minY = (float)aabb.field_1322;
        float minZ = (float)aabb.field_1321;
        float maxX = (float)aabb.field_1320;
        float maxY = (float)aabb.field_1325;
        float maxZ = (float)aabb.field_1324;
        return new Vec3f[]{new Vec3f(minX, minY, minZ), new Vec3f(minX, minY, maxZ), new Vec3f(minX, maxY, minZ), new Vec3f(minX, maxY, maxZ), new Vec3f(maxX, minY, minZ), new Vec3f(maxX, minY, maxZ), new Vec3f(maxX, maxY, minZ), new Vec3f(maxX, maxY, maxZ)};
    }

    public Vec3f[] getVertices() {
        Vec3f[] vertices = new Vec3f[8];
        int i = 0;
        for (int j = 0; j < 2; ++j) {
            for (int k = 0; k < 2; ++k) {
                for (int l = 0; l < 2; ++l) {
                    Vec3f vertex = new Vec3f(this.center);
                    vertex.add(this.axes[0].scale((float)MtMath.sign(j) * this.halfSizes.x()));
                    vertex.add(this.axes[1].scale((float)MtMath.sign(k) * this.halfSizes.y()));
                    vertex.add(this.axes[2].scale((float)MtMath.sign(l) * this.halfSizes.z()));
                    vertices[i++] = vertex;
                }
            }
        }
        return vertices;
    }

    private Vec3f normalizeOrThrow(Vec3f vec) {
        float length = vec.length();
        if (length < 1.0E-6f) {
            throw new IllegalArgumentException("Axis vector is too small to normalize: " + String.valueOf(vec));
        }
        return vec.scale(1.0f / length);
    }

    @Nullable
    private Vec3f normalizeIfNotZero(Vec3f axis) {
        float length = axis.length();
        if (length > 1.0E-6f) {
            return axis.scale(1.0f / length);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OBB)) {
            return false;
        }
        OBB other = (OBB)obj;
        return Objects.equals(this.center, other.center) && Objects.equals(this.halfSizes, other.halfSizes) && Arrays.equals(this.axes, other.axes);
    }

    public int hashCode() {
        return Objects.hash(this.center, this.halfSizes, Arrays.hashCode(this.axes));
    }

    public String toString() {
        return "OBB[center=" + String.valueOf(this.center) + ", halfSizes=" + String.valueOf(this.halfSizes) + ", axes=" + Arrays.toString(this.axes) + "]";
    }
}

