/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.config;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.mr_toad.lib.api.config.entry.ConfigEntry;
import com.mr_toad.lib.core.ToadLib;
import com.mr_toad.lib.mtjava.io.MTIO;
import com.mr_toad.lib.mtjava.strings.OptionalString;
import com.mr_toad.lib.mtjava.strings.func.StringFunction;
import com.mr_toad.lib.mtjava.strings.func.StringSupplier;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2487;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public class ToadConfig {
    protected static final Splitter OPTION_SPLITTER = Splitter.on((char)':').limit(2);
    protected final List<ConfigEntry<?, ?>> entries = Lists.newArrayList();
    protected final String path;

    protected ToadConfig(StringSupplier path) {
        this.path = path.getAsString();
    }

    public void load() {
        if (Files.notExists(this.getConfig(), new LinkOption[0])) {
            this.save();
            return;
        }
        class_2487 nbt = new class_2487();
        try {
            MTIO.readLines(this.getConfig()).forEach(line -> {
                Iterator iterator = OPTION_SPLITTER.split((CharSequence)line).iterator();
                nbt.method_10582((String)iterator.next(), (String)iterator.next());
            });
        }
        catch (IOException e) {
            ToadLib.LOGGER.error(ToadLib.CONFIG, "Failed to load '{}'", (Object)this.path, (Object)e);
        }
        StringFunction<OptionalString> value = s -> nbt.method_10545(s) ? OptionalString.of(nbt.method_68564(s, "")) : OptionalString.empty();
        this.entries.forEach(configEntry -> ((OptionalString)value.apply(configEntry.toString())).ifPresent(s -> {
            JsonReader reader = new JsonReader((Reader)new StringReader(s.isEmpty() ? "\"\"" : s));
            JsonElement element = JsonParser.parseReader((JsonReader)reader);
            configEntry.load(element);
        }));
    }

    public void save() {
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.getConfig().toFile()), StandardCharsets.UTF_8));){
            this.entries.forEach(configEntry -> {
                ToadLib.LOGGER.debug(ToadLib.CONFIG, "Saved '{}', '{}'", configEntry, configEntry.get());
                configEntry.save(writer);
            });
        }
        catch (IOException e) {
            ToadLib.LOGGER.error(ToadLib.CONFIG, "Failed to save '{}'", (Object)this.path);
        }
    }

    public <T, E extends ConfigEntry<T, E>> E register(E instance) {
        this.entries.add(instance);
        return instance;
    }

    public ImmutableList<ConfigEntry<?, ?>> getEntries() {
        return ImmutableList.copyOf(this.entries);
    }

    public class_2561 title() {
        return class_2561.method_43473();
    }

    public Path getConfig() {
        return FabricLoader.getInstance().getConfigDir().resolve(this.path + ".txt");
    }

    public boolean shouldCreateScreen() {
        return true;
    }
}

