/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.config;

import com.mr_toad.lib.api.config.ToadConfig;
import com.mr_toad.lib.api.integration.BuiltInIntegrations;
import com.mr_toad.lib.core.ToadLib;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public class ToadConfigs {
    private static final Object2ObjectMap<String, ToadConfig> CONFIGS = new Object2ObjectOpenHashMap();

    public static <C extends ToadConfig> void create(String id, C config) {
        CONFIGS.put((Object)id, config);
        ToadLib.LOGGER.info(ToadLib.CONFIG, "Registered new config: '{}' for '{}'", (Object)config.path, (Object)id);
        BuiltInIntegrations.setupConfig(id, config);
        config.load();
    }

    @Deprecated
    public static void load() {
        CONFIGS.values().forEach(ToadConfig::load);
    }

    public static Optional<ToadConfig> byId(String id) {
        return Optional.ofNullable((ToadConfig)CONFIGS.get((Object)id));
    }

    public static class_2561 getConfigTitle(ToadConfig config) {
        if (!Objects.equals(config.title(), class_2561.method_43473())) {
            return config.title();
        }
        return class_2561.method_43470((String)config.getConfig().toString());
    }

    public static Object2ObjectMap<String, ToadConfig> getConfigs() {
        return CONFIGS;
    }
}

