/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.config.entry;

import com.mojang.serialization.Codec;
import com.mr_toad.lib.api.config.entry.ConfigEntry;
import com.mr_toad.lib.api.config.entry.type.ConfigEntryTypes;
import com.mr_toad.lib.api.config.error.ConfigException;
import com.mr_toad.lib.core.ToadLib;
import com.mr_toad.lib.mtjava.MtJava;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_9848;

@Environment(value=EnvType.CLIENT)
public class ColorEntry
extends ConfigEntry<Integer, ColorEntry> {
    private final Mode mode;
    private IntList cells = IntLists.emptyList();
    private boolean allowAlpha = true;
    private int cellSize = 10;

    @Deprecated
    public ColorEntry(String name, int defaultColor, IntList list) {
        this(name, defaultColor, Mode.CELLS);
        this.cells = list;
    }

    public ColorEntry(String name, int defaultColor) {
        this(name, defaultColor, Mode.PALETTE);
    }

    private ColorEntry(String name, int defaultColor, Mode mode) {
        super(name, defaultColor, Codec.INT, ConfigEntryTypes.COLOR);
        this.mode = mode;
        try {
            this.validate(defaultColor);
        }
        catch (ConfigException e) {
            ToadLib.LOGGER.error(ToadLib.CONFIG, "Default value: '{}' of '{}' is invalid!", new Object[]{defaultColor, this, e});
            this.setValue(0xFFFFFF);
        }
    }

    @Override
    public Integer get() {
        if (this.allowAlpha) {
            return (Integer)super.get();
        }
        return class_9848.method_61324((int)255, (int)this.invokeRed(), (int)this.invokeGreen(), (int)this.invokeGreen());
    }

    @Override
    public void setValue(Integer value) {
        try {
            this.validate(value);
            super.setValue(value);
        }
        catch (ConfigException e) {
            ToadLib.LOGGER.error(ToadLib.CONFIG, "Error parse color for '{}' to '{}'", new Object[]{this, value, e});
        }
    }

    @Override
    public class_2561 getDescription() {
        class_2561 original = super.getDescription();
        class_5250 hex = class_2561.method_43470((String)MtJava.rgb2Hex(this.get(), this.allowAlpha));
        if (Objects.equals(original, class_2561.method_43473())) {
            return hex;
        }
        return original.method_27661().method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)hex);
    }

    public ColorEntry setAllowAlpha(boolean allowAlpha) {
        if (this.getMode() == Mode.PALETTE) {
            ToadLib.LOGGER.error(ToadLib.CONFIG, "'{}' is cells, alpha in cells doesn't exists!", (Object)this);
            return this;
        }
        this.allowAlpha = allowAlpha;
        return this;
    }

    public ColorEntry setCellSize(int cellSize) {
        if (this.getMode() == Mode.CELLS) {
            ToadLib.LOGGER.error(ToadLib.CONFIG, "'{}' is palette, cells in palette doesn't exists!", (Object)this);
            return this;
        }
        this.cellSize = cellSize;
        return this;
    }

    public void validate(int color) throws ConfigException {
        if (this.allowAlpha && (this.invokeAlpha() < 0 || this.invokeAlpha() > 255)) {
            throw new ConfigException("Alpha in '" + color + "' is invalid!");
        }
        if (this.invokeRed() < 0 || this.invokeRed() > 255) {
            throw new ConfigException("Red in '" + color + "' is invalid!");
        }
        if (this.invokeGreen() < 0 || this.invokeGreen() > 255) {
            throw new ConfigException("Green in '" + color + "' is invalid!");
        }
        if (this.invokeBlue() < 0 || this.invokeBlue() > 255) {
            throw new ConfigException("Blue in '" + color + "' is invalid!");
        }
    }

    public int invokeAlpha() {
        if (!this.allowAlpha) {
            throw new ConfigException("Alpha is not allowed in '" + String.valueOf(this) + "'");
        }
        return class_9848.method_61320((int)this.get());
    }

    public int invokeRed() {
        return class_9848.method_61327((int)this.get());
    }

    public int invokeGreen() {
        return class_9848.method_61329((int)this.get());
    }

    public int invokeBlue() {
        return class_9848.method_61331((int)this.get());
    }

    public IntList getCells() {
        return this.cells;
    }

    public int getCellSize() {
        return this.cellSize;
    }

    public boolean isAllowAlpha() {
        return this.allowAlpha;
    }

    public Mode getMode() {
        return this.mode;
    }

    public static enum Mode {
        PALETTE,
        CELLS;

    }
}

