/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.config.entry;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mr_toad.lib.api.config.entry.type.ConfigEntryType;
import com.mr_toad.lib.api.config.util.DeprecationRule;
import com.mr_toad.lib.api.config.util.HighlightWarning;
import com.mr_toad.lib.api.config.util.PerformanceImpact;
import com.mr_toad.lib.core.ToadLib;
import java.io.PrintWriter;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class ConfigEntry<T, E extends ConfigEntry<T, E>> {
    protected class_2561 title = class_2561.method_43473();
    protected class_2561 description = class_2561.method_43473();
    @Nullable
    private HighlightWarning highlightWarning = null;
    @Nullable
    private PerformanceImpact performanceImpact = null;
    @Nullable
    private DeprecationRule deprecationRule = null;
    private boolean drawInScreen = true;
    public T value;
    protected final T defaultValue;
    protected final String name;
    private final ConfigEntryType type;
    private final Codec<T> codec;

    public ConfigEntry(String name, T defaultValue, Codec<T> codec, ConfigEntryType type) {
        this.defaultValue = defaultValue;
        this.name = name;
        this.type = type;
        this.codec = codec;
        this.value = this.defaultValue;
    }

    public E dontDrawInScreen() {
        this.drawInScreen = false;
        return (E)this;
    }

    public E addTitle(class_2561 component) {
        this.title = component;
        return (E)this;
    }

    public E addDescription(class_2561 component) {
        this.description = component;
        return (E)this;
    }

    public E withWarning(HighlightWarning warning) {
        this.highlightWarning = warning;
        return (E)this;
    }

    public E withPerformanceImpact(PerformanceImpact impact) {
        this.performanceImpact = impact;
        return (E)this;
    }

    public E addDeprecationRule(DeprecationRule rule) {
        this.deprecationRule = rule;
        return (E)this;
    }

    public void save(PrintWriter writer) {
        DataResult result = this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, this.get());
        result.error().ifPresent(r -> ToadLib.LOGGER.error(ToadLib.CONFIG, "Failed to save '{}':{}", (Object)this.name, (Object)r.message()));
        result.result().ifPresent(r -> {
            writer.print(this.name);
            writer.print(":");
            writer.println(r);
        });
    }

    public void load(JsonElement element) {
        DataResult result = this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
        result.error().ifPresent(r -> ToadLib.LOGGER.error(ToadLib.CONFIG, "Error parsing '{}':{}", (Object)this.name, (Object)r.message()));
        result.result().ifPresent(this::setValue);
    }

    public T get() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public void resetValue() {
        this.setValue(this.defaultValue);
    }

    public ConfigEntryType getType() {
        return this.type;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public boolean drawInScreen() {
        return this.drawInScreen;
    }

    public boolean isDefault() {
        return this.get().equals(this.getDefaultValue());
    }

    public boolean isDeprecated() {
        if (this.deprecationRule == null) {
            return false;
        }
        return this.deprecationRule.isActive();
    }

    @Nullable
    public class_2561 getDeprecationMsg() {
        if (this.deprecationRule == null) {
            return null;
        }
        return this.deprecationRule.getTooltip();
    }

    public class_2561 getTitle() {
        if (Objects.equals(this.title, class_2561.method_43473())) {
            return class_2561.method_43470((String)this.name);
        }
        return this.title;
    }

    public class_2561 getDescription() {
        class_5250 c = this.description.method_27661();
        if (this.getHighlightWarning() != null) {
            c = Objects.equals(c, class_2561.method_43473()) ? this.getHighlightWarning().getTooltip() : class_5244.method_37110((class_2561[])new class_2561[]{this.description, class_5244.field_33849, this.getHighlightWarning().getTooltip()});
        }
        if (this.getPerformanceImpact() != null) {
            c = Objects.equals(c, class_2561.method_43473()) ? this.getPerformanceImpact().getTooltip() : class_5244.method_37110((class_2561[])new class_2561[]{c, this.getPerformanceImpact().getTooltip()});
        }
        return c;
    }

    @Nullable
    public HighlightWarning getHighlightWarning() {
        return this.highlightWarning;
    }

    @Nullable
    public PerformanceImpact getPerformanceImpact() {
        return this.performanceImpact;
    }

    public boolean equals(Object obj) {
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ConfigEntry other = (ConfigEntry)obj;
        return Objects.equals(this.name, other.name);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

