/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.db.storage;

import com.google.common.base.Objects;
import com.mr_toad.lib.core.ToadLib;
import com.mr_toad.lib.mtjava.collections.UniqueList;
import com.mr_toad.lib.mtjava.io.MTIO;
import com.mr_toad.lib.mtjava.strings.func.ToStringFunction;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2512;
import net.minecraft.class_3218;

public abstract class AbstractGameDataNbtStorage<L> {
    public static final String ERROR_CODE = "errorcode1";
    protected final UniqueList<L> values = new UniqueList();
    private final File dir;
    private final ToStringFunction<L> flow;

    public AbstractGameDataNbtStorage(String child, ToStringFunction<L> flow) {
        this.dir = new File(FabricLoader.getInstance().getGameDir().resolve("toadlib/database").toFile(), child);
        this.flow = flow;
    }

    protected abstract Optional<L> load(class_3218 var1, class_2487 var2);

    protected abstract void save(class_2487 var1, L var2);

    public void load(class_3218 serverLevel) {
        File[] files = this.getDir().listFiles();
        if (files == null || files.length == 0) {
            ToadLib.LOGGER.warn("Nothing to read from '{}'", (Object)this.getDir());
        } else {
            MTIO.IO.execute(() -> Arrays.stream(files).map(File::getPath).forEach(s -> {
                if (!s.endsWith(".nbt")) {
                    ToadLib.LOGGER.error("Unknown object: '{}' in '{}'", s, (Object)this.getDir());
                } else if (s.contains(ERROR_CODE)) {
                    ToadLib.LOGGER.error("Illegal name of object in {}", (Object)this.getDir());
                } else {
                    try {
                        class_2487 nbt = class_2507.method_30613((Path)new File(this.getDir(), "/" + s + ".mmnbt").toPath(), (class_2505)class_2505.method_53898());
                        this.load(serverLevel, nbt).ifPresentOrElse(this.values::add, () -> ToadLib.LOGGER.error("Loaded value is null!"));
                    }
                    catch (IOException e) {
                        ToadLib.LOGGER.error("Cannot load '{}' from '{}'", s, (Object)this.getDir());
                    }
                }
            }));
        }
    }

    public final void save() {
        MTIO.IO.execute(() -> this.values.forEach(v -> {
            class_2487 nbt = class_2512.method_48310((class_2487)new class_2487());
            this.save(nbt, v);
            File file = this.getAbsolutePath(v);
            try {
                class_2507.method_30614((class_2487)nbt, (Path)file.toPath());
            }
            catch (IOException e) {
                ToadLib.LOGGER.error("Cannot parse '{}' to '{}'", (Object)file, (Object)this.getDir());
            }
        }));
    }

    public File getDir() {
        return this.dir;
    }

    public File getAbsolutePath(L v) {
        return new File(this.getDir(), "/" + this.getFlow(v) + ".nbt");
    }

    protected String getFlow(L value) {
        return this.flow.applyAsString(value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbstractGameDataNbtStorage) {
            AbstractGameDataNbtStorage storage = (AbstractGameDataNbtStorage)obj;
            return Objects.equal((Object)this.getDir(), (Object)storage.getDir());
        }
        return false;
    }

    public int hashCode() {
        return this.getDir().hashCode() - 3;
    }

    public String toString() {
        return "MMNGD(" + String.valueOf(this.getDir()) + ")";
    }
}

