/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.helper.registry.common;

import com.mr_toad.lib.api.helper.registry.common.RegistryMemberException;
import com.mr_toad.lib.api.helper.registry.common.ToadRegistry;
import com.mr_toad.lib.api.helper.registry.common.ValueHolder;
import com.mr_toad.lib.core.ToadLib;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public interface IdRegistry<N extends Number, O, M extends Map<N, ValueHolder<O>>>
extends ToadRegistry<N, O, M> {
    public String regName();

    @Nullable
    public ValueHolder<O> defaultValue();

    default public ValueHolder<O> getOrDefault(N id) {
        ValueHolder holder = (ValueHolder)this.registry().get(id);
        if (holder == null) {
            if (this.defaultValue() != null) {
                ToadLib.LOGGER.error("Member with id: '{}' not found in '{}'! Received as default.", id, (Object)this.regName());
                return this.defaultValue();
            }
            throw new RegistryMemberException("Member of '" + this.regName() + "' with id:" + String.valueOf(id) + "doesn't exists! Default target not declared.");
        }
        return holder;
    }

    default public ValueHolder<O> getOrThrow(N id) {
        if (!this.registry().containsKey(id)) {
            throw new RegistryMemberException("Member of '" + this.regName() + "' with id:" + String.valueOf(id) + "doesn't exists!");
        }
        return (ValueHolder)this.registry().get(id);
    }

    default public Optional<N> getId(O obj) {
        if (!this.values().contains(obj)) {
            return Optional.empty();
        }
        return Optional.ofNullable((Number)this.inverseValues().get(obj));
    }

    default public N getIdOrThrow(O obj) {
        if (!this.values().contains(obj)) {
            throw new RegistryMemberException("ID of '" + String.valueOf(obj) + "' in '" + this.regName() + "' not found!");
        }
        return (N)((Number)this.inverseValues().get(obj));
    }

    default public N getIdOrThrow(ValueHolder<O> obj) {
        if (!this.registry().containsValue(obj)) {
            throw new RegistryMemberException("ID of '" + String.valueOf(obj) + "' in '" + this.regName() + "' not found!");
        }
        return (N)((Number)this.inverse().get(obj));
    }

    default public boolean replace(N id, O newValue) {
        return this.replace(id, new ValueHolder<O>(newValue));
    }

    default public boolean replace(N id, ValueHolder<O> newValue) {
        return this.registry().replace(id, this.getOrThrow(id), newValue);
    }

    default public Stream<O> sortByID() {
        return this.values().stream().sorted((o, o2) -> {
            Number id1 = this.getId(o).orElse(null);
            Number id2 = this.getId(o2).orElse(null);
            if (id1 == null || id2 == null) {
                return 0;
            }
            return Integer.compare(id1.intValue(), id2.intValue());
        });
    }
}

