/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.helper.registry.common;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mr_toad.lib.api.helper.registry.common.ValueHolder;
import com.mr_toad.lib.mtjava.MtJava;
import java.util.Map;

public interface ToadRegistry<N, O, M extends Map<N, ValueHolder<O>>> {
    public M registry();

    default public ImmutableSet<O> values() {
        return ImmutableSet.copyOf(this.registry().values().stream().map(ValueHolder::get).iterator());
    }

    default public ImmutableSet<ValueHolder<O>> valueHolders() {
        return ImmutableSet.copyOf(this.registry().values());
    }

    default public ImmutableMap<O, N> inverseValues() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.inverse().forEach((holder, id) -> builder.put(holder.get(), id));
        return builder.build();
    }

    default public void destroyRegistry() {
        this.registry().clear();
    }

    default public ImmutableMap<ValueHolder<O>, N> inverse() {
        return MtJava.inverseMap(this.registry());
    }

    default public boolean hasId(N id) {
        return this.registry().containsKey(id);
    }

    default public boolean has(O obj) {
        return this.values().contains(obj);
    }

    default public boolean has(ValueHolder<O> obj) {
        return this.registry().containsValue(obj);
    }

    default public int size() {
        return this.values().size();
    }
}

