/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.util.time;

import com.mr_toad.lib.core.ToadLib;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class UniformIntegerCooldown {
    private int minInclusive;
    private int maxInclusive;
    public final String name;
    public final class_5819 RANDOM = class_5819.method_43053();
    public boolean immutable;
    public int sample;

    public UniformIntegerCooldown(int minInclusive, int maxInclusive, @Nullable String name) {
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
        this.sample = this.getSample();
        if (name == null || name.isEmpty()) {
            name = this.toString();
        }
        this.name = name;
    }

    public static UniformIntegerCooldown createNoName(int min, int max) {
        return new UniformIntegerCooldown(min, max, null);
    }

    private int getSample() {
        return class_3532.method_32751((class_5819)this.RANDOM, (int)this.minInclusive, (int)this.maxInclusive);
    }

    public void reset() {
        this.setCooldown(this.getMin(), this.getMax());
    }

    public void tickUp() {
        ++this.sample;
    }

    public void tickDown() {
        --this.sample;
    }

    public UniformIntegerCooldown minus(int i) {
        this.check();
        this.sample -= i;
        return this;
    }

    public UniformIntegerCooldown sum(int i) {
        this.check();
        this.sample += i;
        return this;
    }

    public UniformIntegerCooldown setImmutable() {
        this.immutable = true;
        return this;
    }

    public void check() {
        if (this.immutable) {
            throw new IllegalArgumentException("Cannot modify cooldown value with name:" + this.getName() + "because cooldown field is immutable");
        }
        if (this.getSample() < 0) {
            this.setCooldown(0, 0);
            ToadLib.LOGGER.error("Cooldown value with name: {} cannot be negative", (Object)this.getName());
        }
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public int getMin() {
        return this.minInclusive;
    }

    public int getMax() {
        return this.maxInclusive;
    }

    public void setCooldown(int min, int max) {
        this.minInclusive = min;
        this.maxInclusive = max;
    }

    public String toString() {
        return "<uniform int cooldown value: name = " + this.getName() + ", cooldown = " + this.getSample() + ">";
    }
}

