/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.mtjava.chars;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.mr_toad.lib.mtjava.chars.func.Char2CharFunction;
import com.mr_toad.lib.mtjava.chars.func.Char2StringFunction;
import com.mr_toad.lib.mtjava.chars.func.CharSupplier;
import com.mr_toad.lib.mtjava.strings.OptionalString;
import it.unimi.dsi.fastutil.chars.CharConsumer;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class OptionalChar {
    private static final OptionalChar EMPTY = new OptionalChar();
    private final boolean isPresent;
    private final char value;

    private OptionalChar() {
        this.isPresent = false;
        this.value = '\u0000';
    }

    public static OptionalChar empty() {
        return EMPTY;
    }

    private OptionalChar(char value) {
        this.isPresent = true;
        this.value = value;
    }

    public static OptionalChar of(char value) {
        return new OptionalChar(value);
    }

    public char getAsChar() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No target present");
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public boolean isEmpty() {
        return !this.isPresent;
    }

    public void ifPresent(CharConsumer action) {
        if (this.isPresent) {
            action.accept(this.value);
        }
    }

    public void ifPresentOrElse(CharConsumer action, Runnable emptyAction) {
        if (this.isPresent) {
            action.accept(this.value);
        } else {
            emptyAction.run();
        }
    }

    public char orElse(char other) {
        return this.isPresent ? this.value : other;
    }

    public char orElseGet(CharSupplier supplier) {
        return this.isPresent ? this.value : supplier.getAsChar();
    }

    public char orElseThrow() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No target present");
        }
        return this.value;
    }

    public <X extends Throwable> char orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public Stream<Character> stream() {
        if (this.isPresent()) {
            return Stream.of(Character.valueOf(this.value));
        }
        return Stream.empty();
    }

    public Stream<String> mapToString(Char2StringFunction mapper) {
        Preconditions.checkNotNull((Object)mapper);
        String s = this.map(mapper).orElse(null);
        return Stream.ofNullable(s);
    }

    public OptionalChar map(Char2CharFunction mapper) {
        Preconditions.checkNotNull((Object)mapper);
        if (!this.isPresent()) {
            return OptionalChar.empty();
        }
        return OptionalChar.of(mapper.apply(this.value));
    }

    public OptionalString map(Char2StringFunction mapper) {
        Preconditions.checkNotNull((Object)mapper);
        if (!this.isPresent()) {
            return OptionalString.empty();
        }
        return OptionalString.of((String)mapper.apply(this.value));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OptionalChar)) return false;
        OptionalChar other = (OptionalChar)obj;
        if (this.isPresent && other.isPresent) {
            if (!Objects.equal((Object)Character.valueOf(this.value), (Object)Character.valueOf(other.value))) return false;
            return true;
        } else if (this.isPresent != other.isPresent) return false;
        return true;
    }

    public int hashCode() {
        return this.isPresent ? Character.hashCode(this.value) : 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add(this.isPresent ? String.format("OptionalChar[%s]", Character.valueOf(this.value)) : "Empty", this.value).toString();
    }
}

