/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.mtjava.io;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mr_toad.lib.mtjava.concurrent.Concurrents;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.class_156;

public class MTIO {
    public static final ExecutorService IO = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("MTIO-Worker-%s").setUncaughtExceptionHandler(Concurrents::uncaught).build());

    public static void shutdownIO() {
        Concurrents.shutdownService(class_156.method_27958().comp_3205());
        Concurrents.shutdownService(IO);
    }

    public static ImmutableList<String> readLines(File file) throws IOException {
        return MTIO.readLines(file.toPath());
    }

    public static ImmutableList<String> readLines(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            ImmutableList<String> immutableList = MTIO.readLines(reader);
            return immutableList;
        }
    }

    public static ImmutableList<String> readLines(InputStream stream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            ImmutableList<String> immutableList = MTIO.readLines(reader);
            return immutableList;
        }
    }

    public static ImmutableList<String> readLines(BufferedReader reader) {
        return ImmutableList.copyOf(reader.lines().iterator());
    }
}

