/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.mtjava.math.vec;

import com.mr_toad.lib.mtjava.math.MtMath;
import com.mr_toad.lib.mtjava.math.vec.base.IntVec;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import net.minecraft.class_241;
import net.minecraft.class_3532;
import org.joml.Vector2i;

public class Vec2i
implements IntVec<Vec2i> {
    public static final Vec2i ZERO = new Vec2i();
    private int x;
    private int y;

    public Vec2i() {
        this(0);
    }

    public Vec2i(List<Integer> v) {
        this.x = v.get(0);
        this.y = v.get(1);
    }

    public Vec2i(IntVec<?> v) {
        this.x = v.get(0);
        this.y = v.get(1);
    }

    public Vec2i(int[] a) {
        this(a[0], a[1]);
    }

    public Vec2i(int v) {
        this(v, v);
    }

    public Vec2i(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public Vec2i set(int x, int y) {
        this.setX(x);
        this.setY(y);
        return this;
    }

    @Override
    public Vec2i set(Vec2i other) {
        this.setX(other.x());
        this.setY(other.y());
        return this;
    }

    @Override
    public Vec2i add(Vec2i other) {
        this.setX(this.x() + other.x());
        this.setY(this.y() + other.y());
        return this;
    }

    @Override
    public Vec2i sub(Vec2i other) {
        this.setX(this.x() - other.x());
        this.setY(this.y() - other.y());
        return this;
    }

    @Override
    public Vec2i mul(Vec2i other) {
        this.setX(this.x() * other.x());
        this.setY(this.y() * other.y());
        return this;
    }

    @Override
    public Vec2i scale(int scalar) {
        this.setX(this.x() * scalar);
        this.setY(this.y() * scalar);
        return this;
    }

    @Override
    public Vec2i min(Vec2i other) {
        this.setX(Math.min(this.x(), other.x()));
        this.setY(Math.min(this.y(), other.y()));
        return this;
    }

    @Override
    public Vec2i max(Vec2i other) {
        this.setX(Math.max(this.x(), other.x()));
        this.setY(Math.max(this.y(), other.y()));
        return this;
    }

    @Override
    public Vec2i abs() {
        this.setX(class_3532.method_15382((int)this.x()));
        this.setY(class_3532.method_15382((int)this.y()));
        return this;
    }

    @Override
    public Vec2i cross(Vec2i other) {
        return new Vec2i(this.x() * other.y() - this.y() * other.x());
    }

    @Override
    public IntList values() {
        return IntList.of((int)this.x(), (int)this.y());
    }

    @Override
    public int length() {
        return MtMath.length(this.x, this.y);
    }

    @Override
    public int lengthSqr() {
        return MtMath.lengthSquared(this.x, this.y);
    }

    @Override
    public int dist(Vec2i other) {
        int x = this.x() - other.x();
        int y = this.y() - other.y();
        return MtMath.length(x, y);
    }

    @Override
    public int distSqr(Vec2i other) {
        int x = this.x() - other.x();
        int y = this.y() - other.y();
        return MtMath.lengthSquared(x, y);
    }

    @Override
    public int dot(Vec2i other) {
        return this.x() * other.x() + this.y() * other.y();
    }

    @Override
    public Vec2i zero() {
        return ZERO;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Vec2i) {
            Vec2i other = (Vec2i)obj;
            return this.x() == other.x() && this.y() == other.y();
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.x();
        result = prime * result + this.y();
        return result;
    }

    public String toString() {
        return this.name();
    }

    public Vector2i joml() {
        return new Vector2i(this.x(), this.y());
    }

    public class_241 minecraft() {
        return new class_241((float)this.x(), (float)this.y());
    }
}

