/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.mtjava.math.vec;

import com.mr_toad.lib.mtjava.math.vec.base.DoubleVec;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.List;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.joml.Matrix3dc;
import org.joml.Quaternionf;
import org.joml.Vector3d;

public class Vec3d
implements DoubleVec<Vec3d> {
    public static final Vec3d ZERO = new Vec3d();
    private double x;
    private double y;
    private double z;

    public Vec3d() {
        this(0.0);
    }

    public Vec3d(List<Double> v) {
        this.x = v.get(0);
        this.y = v.get(1);
        this.z = v.get(2);
    }

    public Vec3d(DoubleVec<?> v) {
        this.x = v.get(0);
        this.y = v.get(1);
        this.z = v.get(2);
    }

    public Vec3d(double[] a) {
        this(a[0], a[1], a[2]);
    }

    public Vec3d(double v) {
        this(v, v, v);
    }

    public Vec3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public Vec3d set(double x, double y, double z) {
        this.setX(x);
        this.setY(y);
        this.setZ(z);
        return this;
    }

    @Override
    public Vec3d set(Vec3d other) {
        this.setX(other.x());
        this.setY(other.y());
        this.setZ(other.z());
        return this;
    }

    @Override
    public Vec3d add(Vec3d other) {
        this.setX(this.x() + other.x());
        this.setY(this.y() + other.y());
        this.setZ(this.z() + other.z());
        return this;
    }

    @Override
    public Vec3d sub(Vec3d other) {
        this.setX(this.x() - other.x());
        this.setY(this.y() - other.y());
        this.setZ(this.z() - other.z());
        return this;
    }

    @Override
    public Vec3d mul(Vec3d other) {
        this.setX(this.x() * other.x());
        this.setY(this.y() * other.y());
        this.setZ(this.z() * other.z());
        return this;
    }

    @Override
    public Vec3d scale(double scalar) {
        this.setX(this.x() * scalar);
        this.setY(this.y() * scalar);
        this.setZ(this.z() * scalar);
        return this;
    }

    @Override
    public Vec3d min(Vec3d other) {
        this.setX(Math.min(this.x(), other.x()));
        this.setY(Math.min(this.y(), other.y()));
        this.setZ(Math.min(this.z(), other.z()));
        return this;
    }

    @Override
    public Vec3d max(Vec3d other) {
        this.setX(Math.max(this.x(), other.x()));
        this.setY(Math.max(this.y(), other.y()));
        this.setZ(Math.max(this.z(), other.z()));
        return this;
    }

    @Override
    public Vec3d abs() {
        this.setX(Math.abs(this.x()));
        this.setY(Math.abs(this.y()));
        this.setZ(Math.abs(this.z()));
        return this;
    }

    @Override
    public Vec3d cross(Vec3d other) {
        return new Vec3d(this.y() * other.z() - this.z() * other.y(), this.z() * other.x() - this.x() * other.z(), this.x() * other.y() - this.y() * other.x());
    }

    @Override
    public DoubleList values() {
        return DoubleList.of((double)this.x(), (double)this.y(), (double)this.z());
    }

    @Override
    public double length() {
        return class_3532.method_33825((double)this.x, (double)this.y, (double)this.z);
    }

    @Override
    public double lengthSqr() {
        return class_3532.method_41190((double)this.x, (double)this.y, (double)this.z);
    }

    @Override
    public double dist(Vec3d other) {
        double x = this.x() - other.x();
        double y = this.y() - other.y();
        double z = this.z() - other.z();
        return class_3532.method_41190((double)x, (double)y, (double)z);
    }

    @Override
    public double distSqr(Vec3d other) {
        double x = this.x() - other.x();
        double y = this.y() - other.y();
        double z = this.z() - other.z();
        return class_3532.method_33825((double)x, (double)y, (double)z);
    }

    @Override
    public double dot(Vec3d other) {
        return this.x() * other.x() + this.y() * other.y() + this.z() * other.z();
    }

    @Override
    public Vec3d zero() {
        return ZERO;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Vec3d) {
            Vec3d other = (Vec3d)obj;
            return this.x() == other.x() && this.y() == other.y() && this.z() == other.z();
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = (int)((double)(prime * result) + this.x());
        result = (int)((double)(prime * result) + this.y());
        result = (int)((double)(prime * result) + this.z());
        return result;
    }

    public String toString() {
        return this.name();
    }

    @Override
    public Vec3d mul(Matrix3dc mat) {
        double lx = this.x;
        double ly = this.y;
        double lz = this.z;
        this.x = Math.fma(mat.m00(), lx, Math.fma(mat.m10(), ly, mat.m20() * lz));
        this.y = Math.fma(mat.m01(), lx, Math.fma(mat.m11(), ly, mat.m21() * lz));
        this.z = Math.fma(mat.m02(), lx, Math.fma(mat.m12(), ly, mat.m22() * lz));
        return this;
    }

    @Override
    public Vec3d mul(Quaternionf quaternionf) {
        return this.mul(this.x(), this.y(), this.z(), quaternionf);
    }

    public Vec3d mul(double x, double y, double z, Quaternionf quaternionf) {
        double xx = quaternionf.x * quaternionf.x;
        double yy = quaternionf.y * quaternionf.y;
        double zz = quaternionf.z * quaternionf.z;
        double ww = quaternionf.w * quaternionf.w;
        double xy = quaternionf.x * quaternionf.y;
        double xz = quaternionf.x * quaternionf.z;
        double yz = quaternionf.y * quaternionf.z;
        double xw = quaternionf.x * quaternionf.w;
        double zw = quaternionf.z * quaternionf.w;
        double yw = quaternionf.y * quaternionf.w;
        double k = 1.0 / (xx + yy + zz + ww);
        return this.set(Math.fma((xx - yy - zz + ww) * k, x, Math.fma(2.0 * (xy - zw) * k, y, 2.0 * (xz + yw) * k * z)), Math.fma(2.0 * (xy + zw) * k, x, Math.fma((yy - xx - zz + ww) * k, y, 2.0 * (yz - xw) * k * z)), Math.fma(2.0 * (xz - yw) * k, x, Math.fma(2.0 * (yz + xw) * k, y, (zz - xx - yy + ww) * k * z)));
    }

    public Vector3d joml() {
        return new Vector3d(this.x(), this.y(), this.z());
    }

    public class_243 minecraft() {
        return new class_243(this.x(), this.y(), this.z());
    }
}

