/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.mtjava.math.vec;

import com.mr_toad.lib.mtjava.math.MtMath;
import com.mr_toad.lib.mtjava.math.vec.Vec4f;
import com.mr_toad.lib.mtjava.math.vec.base.FloatVec;
import it.unimi.dsi.fastutil.floats.FloatList;
import java.util.List;
import org.joml.Matrix3fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class Vec3f
implements FloatVec<Vec3f> {
    public static final Vec3f ZERO = new Vec3f();
    private float x;
    private float y;
    private float z;

    public Vec3f() {
        this(0.0f);
    }

    public Vec3f(Vec4f vec) {
        this.x = vec.x();
        this.y = vec.y();
        this.z = vec.z();
    }

    public Vec3f(List<Float> v) {
        this.x = v.get(0).floatValue();
        this.y = v.get(1).floatValue();
        this.z = v.get(2).floatValue();
    }

    public Vec3f(FloatVec<?> v) {
        this.x = v.get(0);
        this.y = v.get(1);
        this.z = v.get(2);
    }

    public Vec3f(float[] a) {
        this(a[0], a[1], a[2]);
    }

    public Vec3f(float v) {
        this(v, v, v);
    }

    public Vec3f(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public float z() {
        return this.z;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setZ(float z) {
        this.z = z;
    }

    public Vec3f set(float x, float y, float z) {
        this.setX(x);
        this.setY(y);
        this.setZ(z);
        return this;
    }

    @Override
    public Vec3f set(Vec3f other) {
        this.setX(other.x());
        this.setY(other.y());
        this.setZ(other.z());
        return this;
    }

    @Override
    public Vec3f add(Vec3f other) {
        this.setX(this.x() + other.x());
        this.setY(this.y() + other.y());
        this.setZ(this.z() + other.z());
        return this;
    }

    @Override
    public Vec3f sub(Vec3f other) {
        this.setX(this.x() - other.x());
        this.setY(this.y() - other.y());
        this.setZ(this.z() - other.z());
        return this;
    }

    @Override
    public Vec3f mul(Vec3f other) {
        this.setX(this.x() * other.x());
        this.setY(this.y() * other.y());
        this.setZ(this.z() * other.z());
        return this;
    }

    @Override
    public Vec3f scale(float scalar) {
        this.setX(this.x() * scalar);
        this.setY(this.y() * scalar);
        this.setZ(this.z() * scalar);
        return this;
    }

    @Override
    public Vec3f min(Vec3f other) {
        this.setX(Math.min(this.x(), other.x()));
        this.setY(Math.min(this.y(), other.y()));
        this.setZ(Math.min(this.z(), other.z()));
        return this;
    }

    @Override
    public Vec3f max(Vec3f other) {
        this.setX(Math.max(this.x(), other.x()));
        this.setY(Math.max(this.y(), other.y()));
        this.setZ(Math.max(this.z(), other.z()));
        return this;
    }

    @Override
    public Vec3f abs() {
        this.setX(Math.abs(this.x()));
        this.setY(Math.abs(this.y()));
        this.setZ(Math.abs(this.z()));
        return this;
    }

    @Override
    public Vec3f cross(Vec3f other) {
        return new Vec3f(this.y() * other.z() - this.z() * other.y(), this.z() * other.x() - this.x() * other.z(), this.x() * other.y() - this.y() * other.x());
    }

    @Override
    public FloatList values() {
        return FloatList.of((float)this.x(), (float)this.y(), (float)this.z());
    }

    @Override
    public float length() {
        return MtMath.length(this.x, this.y, this.z);
    }

    @Override
    public float lengthSqr() {
        return MtMath.lengthSquared(this.x, this.y, this.z);
    }

    @Override
    public float dist(Vec3f other) {
        float x = this.x() - other.x();
        float y = this.y() - other.y();
        float z = this.z() - other.z();
        return MtMath.length(x, y, z);
    }

    @Override
    public float distSqr(Vec3f other) {
        float x = this.x() - other.x();
        float y = this.y() - other.y();
        float z = this.z() - other.z();
        return MtMath.lengthSquared(x, y, z);
    }

    @Override
    public float dot(Vec3f other) {
        return this.x() * other.x() + this.y() * other.y() + this.z() * other.z();
    }

    @Override
    public Vec3f zero() {
        return ZERO;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Vec3f) {
            Vec3f other = (Vec3f)obj;
            return this.x() == other.x() && this.y() == other.y() && this.z() == other.z();
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = (int)((float)(prime * result) + this.x());
        result = (int)((float)(prime * result) + this.y());
        result = (int)((float)(prime * result) + this.z());
        return result;
    }

    public String toString() {
        return this.name();
    }

    @Override
    public Vec3f mul(Matrix3fc mat) {
        float lx = this.x;
        float ly = this.y;
        float lz = this.z;
        this.x = Math.fma(mat.m00(), lx, Math.fma(mat.m10(), ly, mat.m20() * lz));
        this.y = Math.fma(mat.m01(), lx, Math.fma(mat.m11(), ly, mat.m21() * lz));
        this.z = Math.fma(mat.m02(), lx, Math.fma(mat.m12(), ly, mat.m22() * lz));
        return this;
    }

    @Override
    public Vec3f mul(Quaternionf quaternionf) {
        return this.mul(this.x(), this.y(), this.z(), quaternionf);
    }

    public Vec3f mul(float x, float y, float z, Quaternionf quaternionf) {
        float xx = quaternionf.x * quaternionf.x;
        float yy = quaternionf.y * quaternionf.y;
        float zz = quaternionf.z * quaternionf.z;
        float ww = quaternionf.w * quaternionf.w;
        float xy = quaternionf.x * quaternionf.y;
        float xz = quaternionf.x * quaternionf.z;
        float yz = quaternionf.y * quaternionf.z;
        float xw = quaternionf.x * quaternionf.w;
        float zw = quaternionf.z * quaternionf.w;
        float yw = quaternionf.y * quaternionf.w;
        float k = 1.0f / (xx + yy + zz + ww);
        return this.set(Math.fma((xx - yy - zz + ww) * k, x, Math.fma(2.0f * (xy - zw) * k, y, 2.0f * (xz + yw) * k * z)), Math.fma(2.0f * (xy + zw) * k, x, Math.fma((yy - xx - zz + ww) * k, y, 2.0f * (yz - xw) * k * z)), Math.fma(2.0f * (xz - yw) * k, x, Math.fma(2.0f * (yz + xw) * k, y, (zz - xx - yy + ww) * k * z)));
    }

    public Vector3f joml() {
        return new Vector3f(this.x(), this.y(), this.z());
    }
}

