/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.mtjava.math.vec;

import com.mr_toad.lib.mtjava.math.MtMath;
import com.mr_toad.lib.mtjava.math.vec.base.DoubleVec;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.List;
import org.joml.Matrix4dc;
import org.joml.Vector4d;

public class Vec4d
implements DoubleVec<Vec4d> {
    public static final Vec4d ZERO = new Vec4d();
    private double x;
    private double y;
    private double z;
    private double w;

    public Vec4d() {
        this(0.0);
    }

    public Vec4d(List<Double> v) {
        this.x = v.get(0);
        this.y = v.get(1);
        this.z = v.get(2);
        this.w = v.get(3);
    }

    public Vec4d(DoubleVec<?> v) {
        this.x = v.get(0);
        this.y = v.get(1);
        this.z = v.get(2);
        this.w = v.get(3);
    }

    public Vec4d(double[] a) {
        this(a[0], a[1], a[2], a[3]);
    }

    public Vec4d(double v) {
        this(v, v, v, v);
    }

    public Vec4d(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public double w() {
        return this.w;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public void setW(double w) {
        this.w = w;
    }

    public Vec4d set(double x, double y, double z, double w) {
        this.setX(x);
        this.setY(y);
        this.setZ(z);
        this.setW(w);
        return this;
    }

    @Override
    public Vec4d set(Vec4d other) {
        this.setX(other.x());
        this.setY(other.y());
        this.setZ(other.z());
        this.setW(other.w());
        return this;
    }

    @Override
    public Vec4d add(Vec4d other) {
        this.setX(this.x() + other.x());
        this.setY(this.y() + other.y());
        this.setZ(this.z() + other.z());
        this.setW(this.w() + other.w());
        return this;
    }

    @Override
    public Vec4d sub(Vec4d other) {
        this.setX(this.x() - other.x());
        this.setY(this.y() - other.y());
        this.setZ(this.z() - other.z());
        this.setW(this.w() - other.w());
        return this;
    }

    @Override
    public Vec4d mul(Vec4d other) {
        this.setX(this.x() * other.x());
        this.setY(this.y() * other.y());
        this.setZ(this.z() * other.z());
        this.setW(this.w() * other.w());
        return this;
    }

    @Override
    public Vec4d scale(double scalar) {
        this.setX(this.x() * scalar);
        this.setY(this.y() * scalar);
        this.setZ(this.z() * scalar);
        this.setW(this.w() * scalar);
        return this;
    }

    @Override
    public Vec4d min(Vec4d other) {
        this.setX(Math.min(this.x(), other.x()));
        this.setY(Math.min(this.y(), other.y()));
        this.setZ(Math.min(this.z(), other.z()));
        this.setW(Math.min(this.w(), other.w()));
        return this;
    }

    @Override
    public Vec4d max(Vec4d other) {
        this.setX(Math.max(this.x(), other.x()));
        this.setY(Math.max(this.y(), other.y()));
        this.setZ(Math.max(this.z(), other.z()));
        this.setW(Math.max(this.w(), other.w()));
        return this;
    }

    @Override
    public Vec4d abs() {
        this.setX(Math.abs(this.x()));
        this.setY(Math.abs(this.y()));
        this.setZ(Math.abs(this.z()));
        this.setW(Math.abs(this.w()));
        return this;
    }

    @Override
    public Vec4d cross(Vec4d other) {
        double cx = this.y() * other.z() - this.z() * other.y() - this.w() * other.w();
        double cy = this.z() * other.x() - this.x() * other.z() - this.w() * other.w();
        double cz = this.x() * other.y() - this.y() * other.x() - this.w() * other.w();
        double cw = this.w() * other.w();
        return new Vec4d(cx, cy, cz, cw);
    }

    @Override
    public DoubleList values() {
        return DoubleList.of((double[])new double[]{this.x(), this.y(), this.z(), this.w()});
    }

    @Override
    public double length() {
        return MtMath.length(this.x, this.y, this.z, this.w);
    }

    @Override
    public double lengthSqr() {
        return MtMath.lengthSquared(this.x, this.y, this.z, this.w);
    }

    @Override
    public double dist(Vec4d other) {
        double x = this.x() - other.x();
        double y = this.y() - other.y();
        double z = this.z() - other.z();
        double w = this.w() - other.w();
        return MtMath.length(x, y, z, w);
    }

    @Override
    public double distSqr(Vec4d other) {
        double x = this.x() - other.x();
        double y = this.y() - other.y();
        double z = this.z() - other.z();
        double w = this.w() - other.w();
        return MtMath.lengthSquared(x, y, z, w);
    }

    @Override
    public double dot(Vec4d other) {
        return this.x() * other.x() + this.y() * other.y() + this.z() * other.z() + this.w() * other.w();
    }

    @Override
    public Vec4d zero() {
        return ZERO;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Vec4d) {
            Vec4d other = (Vec4d)obj;
            return this.x() == other.x() && this.y() == other.y() && this.z() == other.z() && this.w() == other.w();
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = (int)((double)(prime * result) + this.x());
        result = (int)((double)(prime * result) + this.y());
        result = (int)((double)(prime * result) + this.z());
        result = (int)((double)(prime * result) + this.w());
        return result;
    }

    public String toString() {
        return this.name();
    }

    @Override
    public Vec4d mul(Matrix4dc mat) {
        if ((mat.properties() & 2) != 0) {
            return this.mulAffine(mat);
        }
        return this.mulGeneric(mat);
    }

    public Vec4d mulTranspose(Matrix4dc mat) {
        if ((mat.properties() & 2) != 0) {
            return this.mulAffineTranspose(mat);
        }
        return this.mulGenericTranspose(mat);
    }

    private Vec4d mulAffine(Matrix4dc mat) {
        double x = this.x;
        double y = this.y;
        double z = this.z;
        double w = this.w;
        this.x = Math.fma(mat.m00(), x, Math.fma(mat.m10(), y, Math.fma(mat.m20(), z, mat.m30() * w)));
        this.y = Math.fma(mat.m01(), x, Math.fma(mat.m11(), y, Math.fma(mat.m21(), z, mat.m31() * w)));
        this.z = Math.fma(mat.m02(), x, Math.fma(mat.m12(), y, Math.fma(mat.m22(), z, mat.m32() * w)));
        this.w = w;
        return this;
    }

    private Vec4d mulGeneric(Matrix4dc mat) {
        double x = this.x;
        double y = this.y;
        double z = this.z;
        double w = this.w;
        this.x = Math.fma(mat.m00(), x, Math.fma(mat.m10(), y, Math.fma(mat.m20(), z, mat.m30() * w)));
        this.y = Math.fma(mat.m01(), x, Math.fma(mat.m11(), y, Math.fma(mat.m21(), z, mat.m31() * w)));
        this.z = Math.fma(mat.m02(), x, Math.fma(mat.m12(), y, Math.fma(mat.m22(), z, mat.m32() * w)));
        this.w = Math.fma(mat.m03(), x, Math.fma(mat.m13(), y, Math.fma(mat.m23(), z, mat.m33() * w)));
        return this;
    }

    private Vec4d mulAffineTranspose(Matrix4dc mat) {
        double x = this.x;
        double y = this.y;
        double z = this.z;
        double w = this.w;
        this.x = Math.fma(mat.m00(), x, Math.fma(mat.m01(), y, mat.m02() * z));
        this.y = Math.fma(mat.m10(), x, Math.fma(mat.m11(), y, mat.m12() * z));
        this.z = Math.fma(mat.m20(), x, Math.fma(mat.m21(), y, mat.m22() * z));
        this.w = Math.fma(mat.m30(), x, Math.fma(mat.m31(), y, mat.m32() * z + w));
        return this;
    }

    private Vec4d mulGenericTranspose(Matrix4dc mat) {
        double x = this.x;
        double y = this.y;
        double z = this.z;
        double w = this.w;
        this.x = Math.fma(mat.m00(), x, Math.fma(mat.m01(), y, Math.fma(mat.m02(), z, mat.m03() * w)));
        this.y = Math.fma(mat.m10(), x, Math.fma(mat.m11(), y, Math.fma(mat.m12(), z, mat.m13() * w)));
        this.z = Math.fma(mat.m20(), x, Math.fma(mat.m21(), y, Math.fma(mat.m22(), z, mat.m23() * w)));
        this.w = Math.fma(mat.m30(), x, Math.fma(mat.m31(), y, Math.fma(mat.m32(), z, mat.m33() * w)));
        return this;
    }

    public Vector4d joml() {
        return new Vector4d(this.x(), this.y(), this.z(), this.w());
    }
}

