/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.mtjava.math.vec.base;

import it.unimi.dsi.fastutil.doubles.DoubleList;

public interface DoubleVec<S> {
    public S set(S var1);

    public S add(S var1);

    public S sub(S var1);

    public S mul(S var1);

    public S scale(double var1);

    public S min(S var1);

    public S max(S var1);

    public S abs();

    public S cross(S var1);

    public DoubleList values();

    public double length();

    public double lengthSqr();

    public double dist(S var1);

    public double distSqr(S var1);

    public double dot(S var1);

    public S zero();

    default public double get(int index) {
        return this.values().getDouble(index);
    }

    default public double set(int index, double value) {
        return this.values().set(index, value);
    }

    default public int size() {
        return this.values().size();
    }

    default public S destroy() {
        return this.set(this.zero());
    }

    default public S inverse() {
        return this.scale(-1.0);
    }

    default public void normalize() {
        double f = this.length();
        if (f < (double)1.0E-4f) {
            this.destroy();
        } else {
            for (int i = 0; i < this.values().size(); ++i) {
                double v = this.get(i);
                this.set(i, v / f);
            }
        }
    }

    default public String name() {
        return "Vec" + this.size() + "[" + String.join((CharSequence)",", this.values().stream().map(String::valueOf).toList()) + "]";
    }
}

