/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.mtjava.math.vec.base;

import it.unimi.dsi.fastutil.floats.FloatList;

public interface FloatVec<S> {
    public S set(S var1);

    public S add(S var1);

    public S sub(S var1);

    public S mul(S var1);

    public S scale(float var1);

    public S min(S var1);

    public S max(S var1);

    public S abs();

    public S cross(S var1);

    public FloatList values();

    public float length();

    public float lengthSqr();

    public float dist(S var1);

    public float distSqr(S var1);

    public float dot(S var1);

    public S zero();

    default public float get(int index) {
        return this.values().getFloat(index);
    }

    default public float set(int index, float value) {
        return this.values().set(index, value);
    }

    default public int size() {
        return this.values().size();
    }

    default public S destroy() {
        return this.set(this.zero());
    }

    default public S inverse() {
        return this.scale(-1.0f);
    }

    default public void normalize() {
        float f = this.length();
        if (f < 1.0E-4f) {
            this.destroy();
        } else {
            for (int i = 0; i < this.values().size(); ++i) {
                float v = this.get(i);
                this.set(i, v / f);
            }
        }
    }

    default public String name() {
        return "Vec" + this.size() + "[" + String.join((CharSequence)",", this.values().stream().map(String::valueOf).toList()) + "]";
    }
}

